/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.changelog;

import com.avaje.ebean.event.changelog.BeanChange;
import com.avaje.ebean.event.changelog.ChangeLogListener;
import com.avaje.ebean.event.changelog.ChangeSet;
import com.avaje.ebean.event.changelog.ChangeType;
import com.avaje.ebean.plugin.SpiServer;
import com.avaje.ebean.plugin.SpiServerPlugin;
import com.avaje.ebeaninternal.server.changelog.ChangeJsonBuilder;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeLogListener
implements ChangeLogListener,
SpiServerPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultChangeLogListener.class);
    protected static final Logger changeLog = LoggerFactory.getLogger((String)"org.avaje.ebean.ChangeLog");
    protected ChangeJsonBuilder jsonBuilder;
    protected int defaultBufferSize = 400;
    protected int defaultDeleteBufferSize = 250;

    @Override
    public void configure(SpiServer server) {
        String bufferSize;
        this.jsonBuilder = new ChangeJsonBuilder(server.json());
        Properties properties = server.getServerConfig().getProperties();
        if (properties != null && (bufferSize = properties.getProperty("ebean.changeLog.bufferSize")) != null) {
            this.defaultBufferSize = Integer.parseInt(bufferSize);
        }
    }

    @Override
    public void online(boolean online) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void log(ChangeSet changeSet) {
        List<BeanChange> changes = changeSet.getChanges();
        for (int i = 0; i < changes.size(); ++i) {
            BeanChange beanChange = changes.get(i);
            try {
                StringWriter writer = new StringWriter(this.getBufferSize(beanChange));
                this.jsonBuilder.writeBeanJson(writer, beanChange, changeSet, i);
                changeLog.info(writer.toString());
                continue;
            }
            catch (Exception e) {
                logger.error("Exception logging beanChange " + beanChange.toString(), (Throwable)e);
            }
        }
    }

    protected int getBufferSize(BeanChange beanChange) {
        return ChangeType.DELETE == beanChange.getType() ? this.defaultDeleteBufferSize : this.defaultBufferSize;
    }
}

