/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.mcast;

import com.avaje.ebeaninternal.server.cluster.Packet;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McastSender {
    private static final Logger logger = LoggerFactory.getLogger(McastSender.class);
    private final int port;
    private final InetAddress inetAddress;
    private final DatagramSocket sock;
    private final InetSocketAddress sendAddr;
    private final String senderHostPort;

    public McastSender(int port, String address, int sendPort, String sendAddress) {
        try {
            this.port = port;
            this.inetAddress = InetAddress.getByName(address);
            InetAddress sendInetAddress = sendAddress != null ? InetAddress.getByName(sendAddress) : InetAddress.getLocalHost();
            this.sock = sendPort > 0 ? new DatagramSocket(sendPort, sendInetAddress) : new DatagramSocket(new InetSocketAddress(sendInetAddress, 0));
            String msg = "Cluster Multicast Sender on[" + sendInetAddress.getHostAddress() + ":" + this.sock.getLocalPort() + "]";
            logger.info(msg);
            this.sendAddr = new InetSocketAddress(sendInetAddress, this.sock.getLocalPort());
            this.senderHostPort = sendInetAddress.getHostAddress() + ":" + this.sock.getLocalPort();
        }
        catch (Exception e) {
            String msg = "McastSender port:" + port + " sendPort:" + sendPort + " " + address;
            throw new RuntimeException(msg, e);
        }
    }

    public InetSocketAddress getAddress() {
        return this.sendAddr;
    }

    public String getSenderHostPort() {
        return this.senderHostPort;
    }

    public int sendPacket(Packet packet) throws IOException {
        byte[] pktBytes = packet.getBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("OUTGOING packet: " + packet.getPacketId() + " size:" + pktBytes.length);
        }
        if (pktBytes.length > 65507) {
            logger.warn("OUTGOING packet: " + packet.getPacketId() + " size:" + pktBytes.length + " likely to be truncated using UDP with a MAXIMUM length of 65507");
        }
        DatagramPacket pack = new DatagramPacket(pktBytes, pktBytes.length, this.inetAddress, this.port);
        this.sock.send(pack);
        return pktBytes.length;
    }

    public int sendPackets(List<Packet> packets) throws IOException {
        int totalBytes = 0;
        for (int i = 0; i < packets.size(); ++i) {
            totalBytes += this.sendPacket(packets.get(i));
        }
        return totalBytes;
    }
}

