/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.BeanRequest;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import com.avaje.ebeaninternal.server.persist.BatchPostExecute;
import com.avaje.ebeaninternal.server.persist.PersistExecute;

public abstract class PersistRequest
extends BeanRequest
implements BatchPostExecute {
    protected boolean persistCascade;
    protected Type type;
    protected final PersistExecute persistExecute;

    public PersistRequest(SpiEbeanServer server, SpiTransaction t, PersistExecute persistExecute) {
        super(server, t);
        this.persistExecute = persistExecute;
    }

    public abstract int executeOrQueue();

    public abstract int executeNow();

    @Override
    public boolean isLogSql() {
        return this.transaction.isLogSql();
    }

    @Override
    public boolean isLogSummary() {
        return this.transaction.isLogSummary();
    }

    public boolean isBatchThisRequest() {
        return this.transaction.isBatchThisRequest(this.type);
    }

    public int executeStatement() {
        int rows;
        boolean batch = this.isBatchThisRequest();
        BatchControl control = this.transaction.getBatchControl();
        if (control != null) {
            rows = control.executeStatementOrBatch(this, batch);
        } else if (batch) {
            control = this.persistExecute.createBatchControl(this.transaction);
            rows = control.executeStatementOrBatch(this, true);
        } else {
            rows = this.executeNow();
        }
        return rows;
    }

    public void initTransIfRequired() {
        this.createImplicitTransIfRequired();
        this.persistCascade = this.transaction.isPersistCascade();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPersistCascade() {
        return this.persistCascade;
    }

    public static enum Type {
        INSERT,
        UPDATE,
        DELETE,
        UPDATESQL,
        CALLABLESQL;

    }
}

