/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionAdd;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.ClassUtil;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocManyJsonTransient;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class BeanPropertyAssocManyJsonHelp {
    private final BeanPropertyAssocMany<?> many;
    private final BeanPropertyAssocManyJsonTransient jsonTransient;

    public BeanPropertyAssocManyJsonHelp(BeanPropertyAssocMany<?> many) {
        this.many = many;
        this.jsonTransient = !ClassUtil.isJacksonObjectMapperPresent() ? null : new BeanPropertyAssocManyJsonTransient();
    }

    public void jsonRead(ReadJson readJson, EntityBean parentBean) throws IOException {
        EntityBean detailBean;
        if (!this.many.jsonDeserialize) {
            return;
        }
        JsonParser parser = readJson.getParser();
        JsonToken event = parser.nextToken();
        if (JsonToken.VALUE_NULL == event) {
            return;
        }
        if (JsonToken.START_ARRAY != event) {
            throw new JsonParseException("Unexpected token " + event + " - expecting start_array ", parser.getCurrentLocation());
        }
        if (this.many.isTransient()) {
            this.jsonReadTransientUsingObjectMapper(readJson, parentBean);
            return;
        }
        BeanCollection<?> collection = this.many.createEmpty(parentBean);
        BeanCollectionAdd add = this.many.getBeanCollectionAdd(collection, null);
        while ((detailBean = (EntityBean)this.many.targetDescriptor.jsonRead(readJson, this.many.name)) != null) {
            add.addBean(detailBean);
            if (parentBean == null || this.many.childMasterProperty == null) continue;
            this.many.childMasterProperty.setValue(detailBean, parentBean);
        }
        this.many.setValue(parentBean, collection);
    }

    private void jsonReadTransientUsingObjectMapper(ReadJson readJson, EntityBean parentBean) throws IOException {
        if (this.jsonTransient == null) {
            throw new IllegalStateException("Jackson ObjectMapper is required to read this Transient property " + this.many.getFullBeanName());
        }
        this.jsonTransient.jsonReadUsingObjectMapper(this.many, readJson, parentBean);
    }
}

