/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoin;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlJoinType;

public final class TableJoin {
    private final String table;
    private final SqlJoinType type;
    private final InheritInfo inheritInfo;
    private final TableJoinColumn[] columns;
    private final int queryHash;

    public TableJoin(DeployTableJoin deploy) {
        this.table = InternString.intern(deploy.getTable());
        this.type = deploy.getType();
        this.inheritInfo = deploy.getInheritInfo();
        DeployTableJoinColumn[] deployCols = deploy.columns();
        this.columns = new TableJoinColumn[deployCols.length];
        for (int i = 0; i < deployCols.length; ++i) {
            this.columns[i] = new TableJoinColumn(deployCols[i]);
        }
        this.queryHash = this.calcQueryHash();
    }

    private int calcQueryHash() {
        int hc = this.type.hashCode();
        hc = hc * 31 + (this.table == null ? 0 : this.table.hashCode());
        for (int i = 0; i < this.columns.length; ++i) {
            hc = hc * 31 + this.columns[i].queryHash();
        }
        return hc;
    }

    public int queryHash() {
        return this.queryHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append((Object)this.type).append(" ").append(this.table).append(" ");
        for (int i = 0; i < this.columns.length; ++i) {
            sb.append(this.columns[i]).append(" ");
        }
        return sb.toString();
    }

    public TableJoinColumn[] columns() {
        return this.columns;
    }

    public String getTable() {
        return this.table;
    }

    public SqlJoinType getType() {
        return this.type;
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String prefix, DbSqlContext ctx) {
        String[] names = SplitName.split(prefix);
        String a1 = ctx.getTableAlias(names[0]);
        String a2 = ctx.getTableAlias(prefix);
        return this.addJoin(joinType, a1, a2, ctx);
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String a1, String a2, DbSqlContext ctx) {
        String inheritance = this.inheritInfo != null ? this.inheritInfo.getWhere() : null;
        String joinLiteral = joinType.getLiteral(this.type);
        ctx.addJoin(joinLiteral, this.table, this.columns(), a1, a2, inheritance);
        return joinType.autoToOuter(this.type);
    }
}

