/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebean.annotation.CacheStrategy;
import com.avaje.ebean.annotation.CacheTuning;
import com.avaje.ebean.annotation.EntityConcurrencyMode;
import com.avaje.ebean.annotation.History;
import com.avaje.ebean.annotation.Index;
import com.avaje.ebean.annotation.NamedUpdate;
import com.avaje.ebean.annotation.NamedUpdates;
import com.avaje.ebean.annotation.ReadAudit;
import com.avaje.ebean.annotation.UpdateMode;
import com.avaje.ebean.config.TableName;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.CompoundUniqueConstraint;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedUpdate;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationParser;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

public class AnnotationClass
extends AnnotationParser {
    private final String asOfViewSuffix;
    private final String versionsBetweenSuffix;

    public AnnotationClass(DeployBeanInfo<?> info, boolean validationAnnotations, String asOfViewSuffix, String versionsBetweenSuffix) {
        super(info, validationAnnotations);
        this.asOfViewSuffix = asOfViewSuffix;
        this.versionsBetweenSuffix = versionsBetweenSuffix;
    }

    @Override
    public void parse() {
        this.read(this.descriptor.getBeanType());
        this.setTableName();
    }

    private void setTableName() {
        if (this.descriptor.isBaseTableType()) {
            TableName tableName = this.namingConvention.getTableName(this.descriptor.getBeanType());
            this.descriptor.setBaseTable(tableName, this.asOfViewSuffix, this.versionsBetweenSuffix);
        }
    }

    private void read(Class<?> cls) {
        EntityConcurrencyMode entityConcurrencyMode;
        NamedUpdate namedUpdate;
        NamedUpdates namedUpdates;
        NamedQuery namedQuery;
        NamedQueries namedQueries;
        UpdateMode updateMode;
        History history;
        ReadAudit readAudit;
        UniqueConstraint[] uniqueConstraints;
        Table table;
        UniqueConstraint uc;
        Index index;
        Embeddable embeddable;
        Entity entity = cls.getAnnotation(Entity.class);
        if (entity != null) {
            if (entity.name().equals("")) {
                this.descriptor.setName(cls.getSimpleName());
            } else {
                this.descriptor.setName(entity.name());
            }
        }
        if ((embeddable = cls.getAnnotation(Embeddable.class)) != null) {
            this.descriptor.setEntityType(BeanDescriptor.EntityType.EMBEDDED);
            this.descriptor.setName("Embeddable:" + cls.getSimpleName());
        }
        if ((index = cls.getAnnotation(Index.class)) != null) {
            this.descriptor.addCompoundUniqueConstraint(new CompoundUniqueConstraint(index.columnNames(), index.name(), index.unique()));
        }
        if ((uc = cls.getAnnotation(UniqueConstraint.class)) != null) {
            this.descriptor.addCompoundUniqueConstraint(new CompoundUniqueConstraint(uc.columnNames()));
        }
        if ((table = cls.getAnnotation(Table.class)) != null && (uniqueConstraints = table.uniqueConstraints()) != null) {
            for (UniqueConstraint c : uniqueConstraints) {
                this.descriptor.addCompoundUniqueConstraint(new CompoundUniqueConstraint(c.columnNames()));
            }
        }
        if ((readAudit = cls.getAnnotation(ReadAudit.class)) != null) {
            this.descriptor.setReadAuditing();
        }
        if ((history = cls.getAnnotation(History.class)) != null) {
            this.descriptor.setHistorySupport();
        }
        if ((updateMode = cls.getAnnotation(UpdateMode.class)) != null) {
            this.descriptor.setUpdateChangesOnly(updateMode.updateChangesOnly());
        }
        if ((namedQueries = cls.getAnnotation(NamedQueries.class)) != null) {
            this.readNamedQueries(namedQueries);
        }
        if ((namedQuery = cls.getAnnotation(NamedQuery.class)) != null) {
            this.readNamedQuery(namedQuery);
        }
        if ((namedUpdates = cls.getAnnotation(NamedUpdates.class)) != null) {
            this.readNamedUpdates(namedUpdates);
        }
        if ((namedUpdate = cls.getAnnotation(NamedUpdate.class)) != null) {
            this.readNamedUpdate(namedUpdate);
        }
        CacheStrategy cacheStrategy = cls.getAnnotation(CacheStrategy.class);
        CacheTuning cacheTuning = cls.getAnnotation(CacheTuning.class);
        if (cacheStrategy != null || cacheTuning != null) {
            this.readCacheStrategy(cacheStrategy, cacheTuning);
        }
        if ((entityConcurrencyMode = cls.getAnnotation(EntityConcurrencyMode.class)) != null) {
            this.descriptor.setConcurrencyMode(entityConcurrencyMode.value());
        }
    }

    private void readCacheStrategy(CacheStrategy cacheStrategy, CacheTuning cacheTuning) {
        CacheOptions cacheOptions = this.descriptor.getCacheOptions();
        if (cacheTuning != null) {
            cacheOptions.setMaxSecsToLive(cacheTuning.maxSecsToLive());
            cacheOptions.setMaxIdleSecs(cacheTuning.maxIdleSecs());
        }
        if (cacheStrategy != null) {
            String propName;
            DeployBeanProperty beanProperty;
            cacheOptions.setUseCache(cacheStrategy.useBeanCache());
            cacheOptions.setReadOnly(cacheStrategy.readOnly());
            cacheOptions.setWarmingQuery(cacheStrategy.warmingQuery());
            if (cacheStrategy.naturalKey().length() > 0 && (beanProperty = this.descriptor.getBeanProperty(propName = cacheStrategy.naturalKey().trim())) != null) {
                beanProperty.setNaturalKey();
                cacheOptions.setNaturalKey(propName);
            }
        }
    }

    private void readNamedQueries(NamedQueries namedQueries) {
        NamedQuery[] queries = namedQueries.value();
        for (int i = 0; i < queries.length; ++i) {
            this.readNamedQuery(queries[i]);
        }
    }

    private void readNamedQuery(NamedQuery namedQuery) {
        DeployNamedQuery q = new DeployNamedQuery(namedQuery);
        this.descriptor.add(q);
    }

    private void readNamedUpdates(NamedUpdates updates) {
        NamedUpdate[] updateArray = updates.value();
        for (int i = 0; i < updateArray.length; ++i) {
            this.readNamedUpdate(updateArray[i]);
        }
    }

    private void readNamedUpdate(NamedUpdate update) {
        DeployNamedUpdate upd = new DeployNamedUpdate(update);
        this.descriptor.add(upd);
    }
}

