/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebean.annotation.CreatedTimestamp;
import com.avaje.ebean.annotation.DbHstore;
import com.avaje.ebean.annotation.DbJson;
import com.avaje.ebean.annotation.DbJsonB;
import com.avaje.ebean.annotation.EmbeddedColumns;
import com.avaje.ebean.annotation.Encrypted;
import com.avaje.ebean.annotation.Expose;
import com.avaje.ebean.annotation.Formula;
import com.avaje.ebean.annotation.HistoryExclude;
import com.avaje.ebean.annotation.Index;
import com.avaje.ebean.annotation.JsonIgnore;
import com.avaje.ebean.annotation.UpdatedTimestamp;
import com.avaje.ebean.annotation.WhenCreated;
import com.avaje.ebean.annotation.WhenModified;
import com.avaje.ebean.annotation.WhoCreated;
import com.avaje.ebean.annotation.WhoModified;
import com.avaje.ebean.config.EncryptDeploy;
import com.avaje.ebean.config.dbplatform.DbEncrypt;
import com.avaje.ebean.config.dbplatform.DbEncryptFunction;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedPropertyFactory;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationParser;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.type.CtCompoundType;
import com.avaje.ebeaninternal.server.type.DataEncryptSupport;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesBase;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesEncrypted;
import com.avaje.ebeaninternal.server.type.ScalarTypeEncryptedWrapper;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;

public class AnnotationFields
extends AnnotationParser {
    private final boolean jacksonAnnotationsPresent;
    private final GeneratedPropertyFactory generatedPropFactory;
    private FetchType defaultLobFetchType = FetchType.LAZY;

    public AnnotationFields(GeneratedPropertyFactory generatedPropFactory, DeployBeanInfo<?> info, boolean javaxValidationAnnotations, boolean jacksonAnnotationsPresent, boolean eagerFetchLobs) {
        super(info, javaxValidationAnnotations);
        this.jacksonAnnotationsPresent = jacksonAnnotationsPresent;
        this.generatedPropFactory = generatedPropFactory;
        if (eagerFetchLobs) {
            this.defaultLobFetchType = FetchType.EAGER;
        }
    }

    @Override
    public void parse() {
        for (DeployBeanProperty prop : this.descriptor.propertiesAll()) {
            if (prop instanceof DeployBeanPropertyAssoc) {
                this.readAssocOne(prop);
                continue;
            }
            this.readField(prop);
        }
    }

    private void readAssocOne(DeployBeanProperty prop) {
        EmbeddedId embeddedId;
        this.readJsonAnnotations(prop);
        Id id = this.get(prop, Id.class);
        if (id != null) {
            prop.setId();
            prop.setNullable(false);
        }
        if ((embeddedId = this.get(prop, EmbeddedId.class)) != null) {
            prop.setId();
            prop.setNullable(false);
            prop.setEmbedded();
        }
        if (prop instanceof DeployBeanPropertyAssocOne) {
            if (prop.isId() && !prop.isEmbedded()) {
                prop.setEmbedded();
            }
            this.readEmbeddedAttributeOverrides((DeployBeanPropertyAssocOne)prop);
        }
    }

    private void readField(DeployBeanProperty prop) {
        Index index;
        Transient t;
        EmbeddedColumns columns;
        Basic basic;
        Version version;
        Formula formula;
        Id id;
        GeneratedValue gen;
        boolean isEnum = prop.getPropertyType().isEnum();
        Enumerated enumerated = this.get(prop, Enumerated.class);
        if (isEnum || enumerated != null) {
            this.util.setEnumScalarType(enumerated, prop);
        }
        prop.setDbRead(true);
        prop.setDbInsertable(true);
        prop.setDbUpdateable(true);
        Column column = this.get(prop, Column.class);
        if (column != null) {
            this.readColumn(column, prop);
        }
        this.readJsonAnnotations(prop);
        if (prop.getDbColumn() == null) {
            String dbColumn = this.namingConvention.getColumnFromProperty(this.beanType, prop.getName());
            prop.setDbColumn(dbColumn);
        }
        if ((gen = this.get(prop, GeneratedValue.class)) != null) {
            this.readGenValue(gen, prop);
        }
        if ((id = this.get(prop, Id.class)) != null) {
            this.readId(prop);
        }
        Lob lob = this.get(prop, Lob.class);
        Temporal temporal = this.get(prop, Temporal.class);
        if (temporal != null) {
            this.readTemporal(temporal, prop);
        } else if (lob != null) {
            this.util.setLobType(prop);
        }
        DbJson dbJson = this.get(prop, DbJson.class);
        if (dbJson != null) {
            this.util.setDbJsonType(prop, dbJson);
        } else if (this.get(prop, DbJsonB.class) != null) {
            this.util.setDbJsonBType(prop);
        }
        if (this.get(prop, DbHstore.class) != null) {
            this.util.setDbHstore(prop);
        }
        if ((formula = this.get(prop, Formula.class)) != null) {
            prop.setSqlFormula(formula.select(), formula.join());
        }
        if ((version = this.get(prop, Version.class)) != null) {
            prop.setVersionColumn();
            this.generatedPropFactory.setVersion(prop);
        }
        if ((basic = this.get(prop, Basic.class)) != null) {
            prop.setFetchType(basic.fetch());
            if (!basic.optional()) {
                prop.setNullable(false);
            }
        } else if (prop.isLob()) {
            prop.setFetchType(this.defaultLobFetchType);
        }
        if (this.get(prop, WhenCreated.class) != null || this.get(prop, CreatedTimestamp.class) != null) {
            this.generatedPropFactory.setInsertTimestamp(prop);
        }
        if (this.get(prop, WhenModified.class) != null || this.get(prop, UpdatedTimestamp.class) != null) {
            this.generatedPropFactory.setUpdateTimestamp(prop);
        }
        if (this.get(prop, WhoCreated.class) != null) {
            this.generatedPropFactory.setWhoCreated(prop);
        }
        if (this.get(prop, WhoModified.class) != null) {
            this.generatedPropFactory.setWhoModified(prop);
        }
        if (this.get(prop, HistoryExclude.class) != null) {
            prop.setExcludedFromHistory();
        }
        if (this.validationAnnotations) {
            Size size;
            NotNull notNull = this.get(prop, NotNull.class);
            if (notNull != null && this.isNotNullOnAllValidationGroups(notNull.groups())) {
                prop.setNullable(false);
            }
            if ((size = this.get(prop, Size.class)) != null && size.max() < Integer.MAX_VALUE) {
                prop.setDbLength(size.max());
            }
        }
        if ((columns = this.get(prop, EmbeddedColumns.class)) != null) {
            if (prop instanceof DeployBeanPropertyCompound) {
                DeployBeanPropertyCompound p = (DeployBeanPropertyCompound)prop;
                String propColumns = columns.columns();
                Map<String, String> propMap = StringHelper.delimitedToMap(propColumns, ",", "=");
                p.getDeployEmbedded().putAll(propMap);
                CtCompoundType<?> compoundType = p.getCompoundType();
                if (compoundType == null) {
                    throw new RuntimeException("No registered CtCompoundType for " + p.getPropertyType());
                }
            } else {
                throw new RuntimeException("Can't use EmbeddedColumns on ScalarType " + prop.getFullBeanName());
            }
        }
        if ((t = this.get(prop, Transient.class)) != null) {
            prop.setDbRead(false);
            prop.setDbInsertable(false);
            prop.setDbUpdateable(false);
            prop.setTransient();
        }
        if (!prop.isTransient()) {
            EncryptDeploy encryptDeploy = this.util.getEncryptDeploy(this.info.getDescriptor().getBaseTableFull(), prop.getDbColumn());
            if (encryptDeploy == null || encryptDeploy.getMode().equals((Object)EncryptDeploy.Mode.MODE_ANNOTATION)) {
                Encrypted encrypted = this.get(prop, Encrypted.class);
                if (encrypted != null) {
                    this.setEncryption(prop, encrypted.dbEncryption(), encrypted.dbLength());
                }
            } else if (EncryptDeploy.Mode.MODE_ENCRYPT.equals((Object)encryptDeploy.getMode())) {
                this.setEncryption(prop, encryptDeploy.isDbEncrypt(), encryptDeploy.getDbLength());
            }
        }
        if ((index = this.get(prop, Index.class)) != null) {
            if (this.hasRelationshipItem(prop)) {
                throw new RuntimeException("Can't use Index on foreign key relationships.");
            }
            prop.setIndexed();
            prop.setIndexName(index.name());
        }
    }

    private void readJsonAnnotations(DeployBeanProperty prop) {
        JsonIgnore jsonIgnore;
        Expose expose;
        com.fasterxml.jackson.annotation.JsonIgnore jsonIgnore2;
        if (this.jacksonAnnotationsPresent && (jsonIgnore2 = this.get(prop, com.fasterxml.jackson.annotation.JsonIgnore.class)) != null) {
            prop.setJsonSerialize(!jsonIgnore2.value());
            prop.setJsonDeserialize(!jsonIgnore2.value());
        }
        if ((expose = this.get(prop, Expose.class)) != null) {
            prop.setJsonSerialize(expose.serialize());
            prop.setJsonDeserialize(expose.deserialize());
        }
        if ((jsonIgnore = this.get(prop, JsonIgnore.class)) != null) {
            prop.setJsonSerialize(jsonIgnore.serialize());
            prop.setJsonDeserialize(jsonIgnore.deserialize());
        }
    }

    private boolean hasRelationshipItem(DeployBeanProperty prop) {
        return this.get(prop, OneToMany.class) != null || this.get(prop, ManyToOne.class) != null || this.get(prop, OneToOne.class) != null;
    }

    private boolean isNotNullOnAllValidationGroups(Class<?>[] groups) {
        return groups.length == 0 || groups.length == 1 && Default.class.isAssignableFrom(groups[0]);
    }

    private void setEncryption(DeployBeanProperty prop, boolean dbEncString, int dbLen) {
        int jdbcType;
        DbEncryptFunction dbEncryptFunction;
        DbEncrypt dbEncrypt;
        this.util.checkEncryptKeyManagerDefined(prop.getFullBeanName());
        ScalarType<?> st = prop.getScalarType();
        if (byte[].class.equals(st.getType())) {
            ScalarTypeBytesBase baseType = (ScalarTypeBytesBase)st;
            DataEncryptSupport support = this.createDataEncryptSupport(prop);
            ScalarTypeBytesEncrypted encryptedScalarType = new ScalarTypeBytesEncrypted(baseType, support);
            prop.setScalarType(encryptedScalarType);
            prop.setLocalEncrypted();
            return;
        }
        if (dbEncString && (dbEncrypt = this.util.getDbPlatform().getDbEncrypt()) != null && (dbEncryptFunction = dbEncrypt.getDbEncryptFunction(jdbcType = prop.getScalarType().getJdbcType())) != null) {
            prop.setDbEncryptFunction(dbEncryptFunction, dbEncrypt, dbLen);
            return;
        }
        prop.setScalarType(this.createScalarType(prop, st));
        prop.setLocalEncrypted();
        if (dbLen > 0) {
            prop.setDbLength(dbLen);
        }
    }

    private ScalarTypeEncryptedWrapper<?> createScalarType(DeployBeanProperty prop, ScalarType<?> st) {
        DataEncryptSupport support = this.createDataEncryptSupport(prop);
        ScalarTypeBytesBase byteType = this.getDbEncryptType(prop);
        return new ScalarTypeEncryptedWrapper(st, byteType, support);
    }

    private ScalarTypeBytesBase getDbEncryptType(DeployBeanProperty prop) {
        int dbType = prop.isLob() ? 2004 : -3;
        return (ScalarTypeBytesBase)this.util.getTypeManager().getScalarType(dbType);
    }

    private DataEncryptSupport createDataEncryptSupport(DeployBeanProperty prop) {
        String table = this.info.getDescriptor().getBaseTable();
        String column = prop.getDbColumn();
        return this.util.createDataEncryptSupport(table, column);
    }

    private void readId(DeployBeanProperty prop) {
        prop.setId();
        prop.setNullable(false);
        if (prop.getPropertyType().equals(UUID.class) && this.descriptor.getIdGeneratorName() == null) {
            this.descriptor.setIdGeneratorName("auto.uuid");
            this.descriptor.setIdType(IdType.GENERATOR);
        }
    }

    private void readGenValue(GeneratedValue gen, DeployBeanProperty prop) {
        GenerationType strategy;
        String genName = gen.generator();
        SequenceGenerator sequenceGenerator = this.find(prop, SequenceGenerator.class);
        if (sequenceGenerator != null) {
            if (sequenceGenerator.name().equals(genName)) {
                genName = sequenceGenerator.sequenceName();
            }
            this.descriptor.setSequenceInitialValue(sequenceGenerator.initialValue());
            this.descriptor.setSequenceAllocationSize(sequenceGenerator.allocationSize());
        }
        if ((strategy = gen.strategy()) == GenerationType.IDENTITY) {
            this.descriptor.setIdType(IdType.IDENTITY);
        } else if (strategy == GenerationType.SEQUENCE) {
            this.descriptor.setIdType(IdType.SEQUENCE);
            if (genName != null && genName.length() > 0) {
                this.descriptor.setIdGeneratorName(genName);
            }
        } else if (strategy == GenerationType.AUTO && prop.getPropertyType().equals(UUID.class)) {
            this.descriptor.setIdGeneratorName("auto.uuid");
            this.descriptor.setIdType(IdType.GENERATOR);
        }
    }

    private void readTemporal(Temporal temporal, DeployBeanProperty prop) {
        TemporalType type = temporal.value();
        if (type.equals((Object)TemporalType.DATE)) {
            prop.setDbType(91);
        } else if (type.equals((Object)TemporalType.TIMESTAMP)) {
            prop.setDbType(93);
        } else if (type.equals((Object)TemporalType.TIME)) {
            prop.setDbType(92);
        } else {
            throw new PersistenceException("Unhandled type " + type);
        }
    }

    private void readColumn(Column columnAnn, DeployBeanProperty prop) {
        if (!this.isEmpty(columnAnn.name())) {
            String dbColumn = this.databasePlatform.convertQuotedIdentifiers(columnAnn.name());
            prop.setDbColumn(dbColumn);
        }
        prop.setDbInsertable(columnAnn.insertable());
        prop.setDbUpdateable(columnAnn.updatable());
        prop.setNullable(columnAnn.nullable());
        prop.setUnique(columnAnn.unique());
        if (columnAnn.precision() > 0) {
            prop.setDbLength(columnAnn.precision());
        } else if (columnAnn.length() != 255) {
            prop.setDbLength(columnAnn.length());
        }
        prop.setDbScale(columnAnn.scale());
        prop.setDbColumnDefn(columnAnn.columnDefinition());
        String baseTable = this.descriptor.getBaseTable();
        String tableName = columnAnn.table();
        if (!"".equals(tableName) && !tableName.equalsIgnoreCase(baseTable)) {
            prop.setSecondaryTable(tableName);
        }
    }
}

