/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebean.annotation.DbJson;
import com.avaje.ebean.annotation.DbJsonType;
import com.avaje.ebean.config.EncryptDeploy;
import com.avaje.ebean.config.EncryptDeployManager;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.Encryptor;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.TableName;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyCompound;
import com.avaje.ebeaninternal.server.type.DataEncryptSupport;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeEnumStandard;
import com.avaje.ebeaninternal.server.type.SimpleAesEncryptor;
import com.avaje.ebeaninternal.server.type.TypeManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployUtil {
    private static final Logger logger = LoggerFactory.getLogger(DeployUtil.class);
    private static final int dbCLOBType = 2005;
    private static final int dbBLOBType = 2004;
    private static final int DEFAULT_JSON_VARCHAR_LENGTH = 3000;
    private final NamingConvention namingConvention;
    private final TypeManager typeManager;
    private final DatabasePlatform dbPlatform;
    private final EncryptDeployManager encryptDeployManager;
    private final EncryptKeyManager encryptKeyManager;
    private final Encryptor bytesEncryptor;

    public DeployUtil(TypeManager typeMgr, ServerConfig serverConfig) {
        this.typeManager = typeMgr;
        this.namingConvention = serverConfig.getNamingConvention();
        this.dbPlatform = serverConfig.getDatabasePlatform();
        this.encryptDeployManager = serverConfig.getEncryptDeployManager();
        this.encryptKeyManager = serverConfig.getEncryptKeyManager();
        Encryptor be = serverConfig.getEncryptor();
        this.bytesEncryptor = be != null ? be : new SimpleAesEncryptor();
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public DatabasePlatform getDbPlatform() {
        return this.dbPlatform;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void checkEncryptKeyManagerDefined(String fullPropName) {
        if (this.encryptKeyManager == null) {
            String msg = "Using encryption on " + fullPropName + " but no EncryptKeyManager defined!";
            throw new PersistenceException(msg);
        }
    }

    public EncryptDeploy getEncryptDeploy(TableName table, String column) {
        if (this.encryptDeployManager == null) {
            return EncryptDeploy.ANNOTATION;
        }
        return this.encryptDeployManager.getEncryptDeploy(table, column);
    }

    public DataEncryptSupport createDataEncryptSupport(String table, String column) {
        return new DataEncryptSupport(this.encryptKeyManager, this.bytesEncryptor, table, column);
    }

    public void setEnumScalarType(Enumerated enumerated, DeployBeanProperty prop) {
        Class<?> enumType = prop.getPropertyType();
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("Class [" + enumType + "] is Not a Enum?");
        }
        ScalarType<?> scalarType = this.typeManager.getScalarType(enumType);
        if (scalarType == null) {
            scalarType = this.typeManager.createEnumScalarType(enumType);
            if (scalarType == null) {
                EnumType type = enumerated != null ? enumerated.value() : null;
                scalarType = this.createEnumScalarTypePerSpec(enumType, type);
            }
            this.typeManager.add(scalarType);
        }
        prop.setScalarType(scalarType);
        prop.setDbType(scalarType.getJdbcType());
    }

    private ScalarType<?> createEnumScalarTypePerSpec(Class<?> enumType, EnumType type) {
        if (type == null) {
            return new ScalarTypeEnumStandard.OrdinalEnum(enumType);
        }
        if (type == EnumType.ORDINAL) {
            return new ScalarTypeEnumStandard.OrdinalEnum(enumType);
        }
        return new ScalarTypeEnumStandard.StringEnum(enumType);
    }

    public void setScalarType(DeployBeanProperty property) {
        if (property.getScalarType() != null) {
            return;
        }
        if (property instanceof DeployBeanPropertyCompound) {
            return;
        }
        ScalarType<?> scalarType = this.getScalarType(property);
        if (scalarType != null) {
            property.setDbType(scalarType.getJdbcType());
            property.setScalarType(scalarType);
        }
    }

    private ScalarType<?> getScalarType(DeployBeanProperty property) {
        Class<?> propType = property.getPropertyType();
        try {
            ScalarType<?> scalarType = this.typeManager.getScalarType(propType, property.getDbType());
            if (scalarType != null) {
                return scalarType;
            }
            String msg = property.getFullBeanName() + " has no ScalarType - type[" + propType.getName() + "]";
            if (!property.isTransient()) {
                throw new PersistenceException(msg);
            }
            logger.trace("... transient property " + msg);
            return null;
        }
        catch (IllegalArgumentException e) {
            if (property.isTransient()) {
                return null;
            }
            throw e;
        }
    }

    public void setDbHstore(DeployBeanProperty prop) {
        ScalarType<?> scalarType = this.typeManager.getScalarType(5000);
        if (scalarType == null) {
            throw new RuntimeException("No ScalarType found for HSTORE on [" + prop.getFullBeanName() + "]");
        }
        prop.setDbType(5000);
        prop.setScalarType(scalarType);
    }

    public void setDbJsonType(DeployBeanProperty prop, DbJson dbJsonType) {
        int dbType = this.getDbJsonStorage(dbJsonType.storage());
        this.setDbJsonType(prop, dbType, dbJsonType.length());
    }

    public void setDbJsonBType(DeployBeanProperty prop) {
        this.setDbJsonType(prop, 5002, 0);
    }

    private void setDbJsonType(DeployBeanProperty prop, int dbType, int dbLength) {
        Class<?> type = prop.getPropertyType();
        ScalarType<?> scalarType = this.typeManager.getJsonScalarType(type, dbType);
        if (scalarType == null) {
            throw new RuntimeException("No ScalarType for JSON type [" + type + "] [" + dbType + "]");
        }
        prop.setDbType(dbType);
        prop.setScalarType(scalarType);
        if (dbType == 12) {
            int columnLength = dbLength > 0 ? dbLength : 3000;
            prop.setDbLength(columnLength);
        }
    }

    private int getDbJsonStorage(DbJsonType dbJsonType) {
        switch (dbJsonType) {
            case JSON: {
                return 5001;
            }
            case JSONB: {
                return 5002;
            }
            case VARCHAR: {
                return 12;
            }
            case CLOB: {
                return 2005;
            }
            case BLOB: {
                return 2004;
            }
        }
        return 5001;
    }

    public void setLobType(DeployBeanProperty prop) {
        Class<?> type;
        int lobType = this.isClobType(type = prop.getPropertyType()) ? 2005 : 2004;
        ScalarType<?> scalarType = this.typeManager.getScalarType(type, lobType);
        if (scalarType == null) {
            throw new RuntimeException("No ScalarType for LOB type [" + type + "] [" + lobType + "]");
        }
        prop.setDbType(lobType);
        prop.setScalarType(scalarType);
    }

    public boolean isClobType(Class<?> type) {
        return type.equals(String.class);
    }
}

