/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;

class CaseInsensitiveEqualExpression
extends AbstractExpression {
    private static final long serialVersionUID = -6406036750998971064L;
    private final String value;

    CaseInsensitiveEqualExpression(String propertyName, String value) {
        super(propertyName);
        this.value = value.toLowerCase();
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
            request.addBindValue(encryptKey);
        }
        request.addBindValue(this.value);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String propertyName;
        String pname = propertyName = this.getPropertyName();
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.getBeanProperty().getDecryptProperty(propertyName);
        }
        request.append("lower(").append(pname).append(") =? ");
    }

    @Override
    public void queryAutoTuneHash(HashQueryPlanBuilder builder) {
        builder.add(CaseInsensitiveEqualExpression.class).add(this.propName);
        builder.bind(1);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoTuneHash(builder);
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }
}

