/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.query.CQuery;
import java.util.ArrayList;

class InQueryExpression
extends AbstractExpression {
    private static final long serialVersionUID = 666990277309851644L;
    private final boolean not;
    private final SpiQuery<?> subQuery;
    private transient CQuery<?> compiledSubQuery;

    public InQueryExpression(String propertyName, SpiQuery<?> subQuery, boolean not) {
        super(propertyName);
        this.subQuery = subQuery;
        this.not = not;
    }

    @Override
    public void queryAutoTuneHash(HashQueryPlanBuilder builder) {
        builder.add(InQueryExpression.class).add(this.propName).add(this.not);
        this.subQuery.queryAutoTuneHash(builder);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.compiledSubQuery = this.compileSubQuery(request);
        this.queryAutoTuneHash(builder);
    }

    private CQuery<?> compileSubQuery(BeanQueryRequest<?> queryRequest) {
        SpiEbeanServer ebeanServer = (SpiEbeanServer)queryRequest.getEbeanServer();
        return ebeanServer.compileQuery(this.subQuery, queryRequest.getTransaction());
    }

    @Override
    public int queryBindHash() {
        return this.subQuery.queryBindHash();
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String subSelect = this.compiledSubQuery.getGeneratedSql();
        subSelect = subSelect.replace('\n', ' ');
        String propertyName = this.getPropertyName();
        request.append(" (").append(propertyName).append(")");
        if (this.not) {
            request.append(" not");
        }
        request.append(" in (");
        request.append(subSelect);
        request.append(") ");
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ArrayList<Object> bindParams = this.compiledSubQuery.getPredicates().getWhereExprBindValues();
        if (bindParams == null) {
            return;
        }
        for (int i = 0; i < bindParams.size(); ++i) {
            request.addBindValue(bindParams.get(i));
        }
    }
}

