/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.Op;

class JsonPathExpression
extends AbstractExpression {
    protected final String path;
    protected final Op operator;
    protected final Object value;
    protected final Object upperValue;

    JsonPathExpression(String propertyName, String path, Op operator, Object value) {
        super(propertyName);
        this.path = path;
        this.operator = operator;
        this.value = value;
        this.upperValue = null;
    }

    JsonPathExpression(String propertyName, String path, Object value, Object upperValue) {
        super(propertyName);
        this.path = path;
        this.operator = Op.BETWEEN;
        this.value = value;
        this.upperValue = upperValue;
    }

    @Override
    public void queryAutoTuneHash(HashQueryPlanBuilder builder) {
        builder.add(JsonPathExpression.class).add(this.propName).add(this.path).add((Object)this.operator);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoTuneHash(builder);
    }

    @Override
    public int queryBindHash() {
        int hc = this.value == null ? 0 : this.value.hashCode();
        hc = this.upperValue == null ? hc : hc * 31 + this.upperValue.hashCode();
        return hc;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.getJsonHander().addSql(request, this.propName, this.path, this.operator, this.value);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.value != null) {
            request.addBindValue(this.value);
        }
        if (this.upperValue != null) {
            request.addBindValue(this.upperValue);
        }
    }
}

