/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.persist.BatchDepthComparator;
import com.avaje.ebeaninternal.server.persist.BatchedBeanHolder;
import com.avaje.ebeaninternal.server.persist.BatchedPstmtHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.persistence.PersistenceException;

public final class BatchControl {
    private static final BatchDepthComparator depthComparator = new BatchDepthComparator();
    private final BatchedPstmtHolder pstmtHolder = new BatchedPstmtHolder();
    private final HashMap<String, BatchedBeanHolder> beanHoldMap = new HashMap();
    private final SpiTransaction transaction;
    private int batchSize;
    private boolean getGeneratedKeys;
    private boolean batchFlushOnMixed = true;

    public BatchControl(SpiTransaction t, int batchSize, boolean getGenKeys) {
        this.transaction = t;
        this.batchSize = batchSize;
        this.getGeneratedKeys = getGenKeys;
        this.transaction.setBatchControl(this);
    }

    public void setBatchFlushOnMixed(boolean flushBatchOnMixed) {
        this.batchFlushOnMixed = flushBatchOnMixed;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize > 1) {
            this.batchSize = batchSize;
        }
    }

    public void setGetGeneratedKeys(Boolean getGeneratedKeys) {
        if (getGeneratedKeys != null) {
            this.getGeneratedKeys = getGeneratedKeys;
        }
    }

    public int executeStatementOrBatch(PersistRequest request, boolean batch) {
        if (!batch || this.batchFlushOnMixed && !this.isBeansEmpty()) {
            this.flush();
        }
        if (!batch) {
            return request.executeNow();
        }
        if (this.pstmtHolder.getMaxSize() >= this.batchSize) {
            this.flush();
        }
        request.executeNow();
        return -1;
    }

    public int executeOrQueue(PersistRequestBean<?> request, boolean batch) {
        if (!batch || this.batchFlushOnMixed && !this.pstmtHolder.isEmpty()) {
            this.flush();
        }
        if (!batch) {
            return request.executeNow();
        }
        if (this.addToBatch(request)) {
            this.flush();
        }
        return -1;
    }

    private boolean addToBatch(PersistRequestBean<?> request) {
        BatchedBeanHolder beanHolder = this.getBeanHolder(request);
        int bufferSize = beanHolder.append(request);
        return bufferSize == this.batchSize && beanHolder.getOrder() == 100;
    }

    public BatchedPstmtHolder getPstmtHolder() {
        return this.pstmtHolder;
    }

    public boolean isEmpty() {
        return this.isBeansEmpty() && this.pstmtHolder.isEmpty();
    }

    protected void flushPstmtHolder() {
        this.pstmtHolder.flush(this.getGeneratedKeys);
    }

    protected void executeNow(ArrayList<PersistRequest> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (i % this.batchSize == 0) {
                this.flushPstmtHolder();
            }
            list.get(i).executeNow();
        }
        this.flushPstmtHolder();
    }

    public void flush() throws PersistenceException {
        this.flush(false);
    }

    public void flushReset() throws PersistenceException {
        this.flush(true);
    }

    private void flush(boolean resetTop) throws PersistenceException {
        if (!this.pstmtHolder.isEmpty()) {
            this.flushPstmtHolder();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] bsArray = this.getBeanHolderArray();
        Arrays.sort(bsArray, depthComparator);
        if (this.transaction.isLogSummary()) {
            this.transaction.logSummary("BatchControl flush " + Arrays.toString(bsArray));
        }
        for (int i = 0; i < bsArray.length; ++i) {
            ((BatchedBeanHolder)bsArray[i]).executeNow();
        }
        if (resetTop) {
            this.beanHoldMap.clear();
        }
    }

    private BatchedBeanHolder getBeanHolder(PersistRequestBean<?> request) {
        BeanDescriptor<?> beanDescriptor = request.getBeanDescriptor();
        BatchedBeanHolder batchBeanHolder = this.beanHoldMap.get(beanDescriptor.getFullName());
        if (batchBeanHolder == null) {
            int relativeDepth = this.transaction.depth();
            if (relativeDepth == 0 && !this.beanHoldMap.isEmpty()) {
                this.flushReset();
            }
            batchBeanHolder = new BatchedBeanHolder(this, beanDescriptor, 100 + relativeDepth);
            this.beanHoldMap.put(beanDescriptor.getFullName(), batchBeanHolder);
        }
        return batchBeanHolder;
    }

    private boolean isBeansEmpty() {
        if (this.beanHoldMap.isEmpty()) {
            return true;
        }
        for (BatchedBeanHolder beanHolder : this.beanHoldMap.values()) {
            if (beanHolder.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private BatchedBeanHolder[] getBeanHolderArray() {
        return this.beanHoldMap.values().toArray(new BatchedBeanHolder[this.beanHoldMap.size()]);
    }
}

