/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Transaction;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.query.CQueryPredicates;
import com.avaje.ebeaninternal.server.type.DataBind;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryDelete {
    private static final Logger logger = LoggerFactory.getLogger(CQueryDelete.class);
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private PreparedStatement pstmt;
    private String bindLog;
    private int executionTimeMicros;
    private int rowCount;

    public CQueryDelete(OrmQueryRequest<?> request, CQueryPredicates predicates, String sql) {
        this.request = request;
        this.query = request.getQuery();
        this.sql = sql;
        this.query.setGeneratedSql(sql);
        this.desc = request.getBeanDescriptor();
        this.predicates = predicates;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("Delete exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.getName()).append("] predicates[").append(this.predicates.getLogWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public String getGeneratedSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete() throws SQLException {
        long startNano = System.nanoTime();
        try {
            Transaction t = this.request.getTransaction();
            Connection conn = t.getInternalConnection();
            this.pstmt = conn.prepareStatement(this.sql);
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            this.bindLog = this.predicates.bind(new DataBind(this.pstmt));
            this.rowCount = this.pstmt.executeUpdate();
            long exeNano = System.nanoTime() - startNano;
            this.executionTimeMicros = (int)exeNano / 1000;
            int n = this.rowCount;
            return n;
        }
        finally {
            this.close();
        }
    }

    private void close() {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException e) {
            logger.error(null, (Throwable)e);
        }
    }
}

