/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.meta.MetaQueryPlanOriginCount;
import com.avaje.ebean.meta.MetaQueryPlanStatistic;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.util.LongAdder;
import com.avaje.ebeaninternal.server.util.LongMaxUpdater;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class CQueryPlanStats {
    private final CQueryPlan queryPlan;
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final LongAdder totalBeans = new LongAdder();
    private final LongMaxUpdater maxTime = new LongMaxUpdater();
    private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
    private long lastQueryTime;
    private final ConcurrentHashMap<ObjectGraphNode, LongAdder> origins;

    public CQueryPlanStats(CQueryPlan queryPlan, boolean collectQueryOrigins) {
        this.queryPlan = queryPlan;
        this.origins = !collectQueryOrigins ? null : new ConcurrentHashMap();
    }

    public void add(long loadedBeanCount, long timeMicros, ObjectGraphNode objectGraphNode) {
        this.count.increment();
        this.totalBeans.add(loadedBeanCount);
        this.totalTime.add(timeMicros);
        this.maxTime.update(timeMicros);
        this.lastQueryTime = System.currentTimeMillis();
        if (this.origins != null && objectGraphNode != null) {
            LongAdder counter = this.origins.get(objectGraphNode);
            if (counter == null) {
                counter = new LongAdder();
                this.origins.put(objectGraphNode, counter);
            }
            counter.increment();
        }
    }

    public void reset() {
        this.count.reset();
        this.totalBeans.reset();
        this.totalTime.reset();
        this.maxTime.reset();
        this.startTime.set(System.currentTimeMillis());
        if (this.origins != null) {
            for (LongAdder counter : this.origins.values()) {
                counter.reset();
            }
        }
    }

    public long getLastQueryTime() {
        return this.lastQueryTime;
    }

    public Snapshot getSnapshot(boolean reset) {
        List<MetaQueryPlanOriginCount> origins = this.getOrigins(reset);
        if (reset) {
            return new Snapshot(this.queryPlan, this.count.sumThenReset(), this.totalTime.sumThenReset(), this.totalBeans.sumThenReset(), this.maxTime.maxThenReset(), this.startTime.getAndSet(System.currentTimeMillis()), this.lastQueryTime, origins);
        }
        return new Snapshot(this.queryPlan, this.count.sum(), this.totalTime.sum(), this.totalBeans.sum(), this.maxTime.max(), this.startTime.get(), this.lastQueryTime, origins);
    }

    private List<MetaQueryPlanOriginCount> getOrigins(boolean reset) {
        if (this.origins == null) {
            return Collections.emptyList();
        }
        ArrayList<MetaQueryPlanOriginCount> list = new ArrayList<MetaQueryPlanOriginCount>();
        for (Map.Entry<ObjectGraphNode, LongAdder> entry : this.origins.entrySet()) {
            if (reset) {
                list.add(new OriginSnapshot(entry.getKey(), entry.getValue().sumThenReset()));
                continue;
            }
            list.add(new OriginSnapshot(entry.getKey(), entry.getValue().sum()));
        }
        return list;
    }

    public static class Snapshot
    implements MetaQueryPlanStatistic {
        private final CQueryPlan queryPlan;
        private final long count;
        private final long totalTime;
        private final long totalBeans;
        private final long maxTime;
        private final long startTime;
        private final long lastQueryTime;
        private final List<MetaQueryPlanOriginCount> origins;

        public Snapshot(CQueryPlan queryPlan, long count, long totalTime, long totalBeans, long maxTime, long startTime, long lastQueryTime, List<MetaQueryPlanOriginCount> origins) {
            this.queryPlan = queryPlan;
            this.count = count;
            this.totalTime = totalTime;
            this.totalBeans = totalBeans;
            this.maxTime = maxTime;
            this.startTime = startTime;
            this.lastQueryTime = lastQueryTime;
            this.origins = origins;
        }

        public String toString() {
            return this.queryPlan + " count:" + this.count + " time:" + this.totalTime + " maxTime:" + this.maxTime + " beans:" + this.totalBeans + " start:" + this.startTime + " lastQuery:" + this.lastQueryTime + " origins:" + this.origins;
        }

        @Override
        public Class<?> getBeanType() {
            return this.queryPlan.getBeanType();
        }

        @Override
        public long getExecutionCount() {
            return this.count;
        }

        @Override
        public long getTotalTimeMicros() {
            return this.totalTime;
        }

        @Override
        public long getTotalLoadedBeans() {
            return this.totalBeans;
        }

        @Override
        public long getMaxTimeMicros() {
            return this.maxTime;
        }

        @Override
        public long getCollectionStart() {
            return this.startTime;
        }

        @Override
        public long getLastQueryTime() {
            return this.lastQueryTime;
        }

        @Override
        public boolean isAutoTuned() {
            return this.queryPlan.isAutoTuned();
        }

        @Override
        public String getQueryPlanHash() {
            return this.queryPlan.getHash().toString();
        }

        @Override
        public String getSql() {
            return this.queryPlan.getSql();
        }

        @Override
        public long getAvgTimeMicros() {
            return this.count < 1L ? 0L : this.totalTime / this.count;
        }

        @Override
        public long getAvgLoadedBeans() {
            return this.count < 1L ? 0L : this.totalBeans / this.count;
        }

        @Override
        public List<MetaQueryPlanOriginCount> getOrigins() {
            return this.origins;
        }
    }

    private static class OriginSnapshot
    implements MetaQueryPlanOriginCount {
        private final ObjectGraphNode objectGraphNode;
        private final long count;

        public OriginSnapshot(ObjectGraphNode objectGraphNode, long count) {
            this.objectGraphNode = objectGraphNode;
            this.count = count;
        }

        public String toString() {
            return "node[" + this.objectGraphNode + "] count[" + this.count + "]";
        }

        @Override
        public ObjectGraphNode getObjectGraphNode() {
            return this.objectGraphNode;
        }

        @Override
        public long getCount() {
            return this.count;
        }
    }
}

