/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.query.SqlTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SqlTree {
    private final SqlTreeNode rootNode;
    private final BeanPropertyAssocMany<?> manyProperty;
    private final Set<String> includes;
    private final String summary;
    private final String selectSql;
    private final String fromSql;
    private final BeanProperty[] encryptedProps;
    private final String inheritanceWhereSql;
    private final boolean includeJoins;

    public SqlTree(String summary, SqlTreeNode rootNode, String selectSql, String fromSql, String inheritanceWhereSql, BeanProperty[] encryptedProps, BeanPropertyAssocMany<?> manyProperty, Set<String> includes, boolean includeJoins) {
        this.summary = summary;
        this.rootNode = rootNode;
        this.selectSql = selectSql;
        this.fromSql = fromSql;
        this.inheritanceWhereSql = inheritanceWhereSql;
        this.encryptedProps = encryptedProps;
        this.manyProperty = manyProperty;
        this.includes = includes;
        this.includeJoins = includeJoins;
    }

    public SqlTree(String summary, SqlTreeNode rootNode) {
        this.summary = summary;
        this.rootNode = rootNode;
        this.selectSql = null;
        this.fromSql = null;
        this.inheritanceWhereSql = null;
        this.encryptedProps = null;
        this.manyProperty = null;
        this.includes = null;
        this.includeJoins = false;
    }

    public boolean isIncludeJoins() {
        return this.includeJoins;
    }

    public void addAsOfTableAlias(SpiQuery<?> query) {
        this.rootNode.addAsOfTableAlias(query);
    }

    public List<String> buildRawSqlSelectChain() {
        ArrayList<String> list = new ArrayList<String>();
        this.rootNode.buildRawSqlSelectChain(list);
        return list;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public String getFromSql() {
        return this.fromSql;
    }

    public String getInheritanceWhereSql() {
        return this.inheritanceWhereSql;
    }

    public String getSummary() {
        return this.summary;
    }

    public SqlTreeNode getRootNode() {
        return this.rootNode;
    }

    public BeanPropertyAssocMany<?> getManyProperty() {
        return this.manyProperty;
    }

    public BeanProperty[] getEncryptedProps() {
        return this.encryptedProps;
    }
}

