/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.json;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebean.text.json.JsonContext;
import com.avaje.ebean.text.json.JsonIOException;
import com.avaje.ebean.text.json.JsonReadOptions;
import com.avaje.ebean.text.json.JsonScalar;
import com.avaje.ebean.text.json.JsonWriteBeanVisitor;
import com.avaje.ebean.text.json.JsonWriteOptions;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.text.json.DefaultJsonScalar;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.avaje.ebeaninternal.server.type.TypeManager;
import com.avaje.ebeaninternal.util.ParamTypeHelper;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DJsonContext
implements JsonContext {
    private final SpiEbeanServer server;
    private final JsonFactory jsonFactory;
    private final TypeManager typeManager;
    private final Object defaultObjectMapper;
    private final JsonConfig.Include defaultInclude;

    public DJsonContext(SpiEbeanServer server, JsonFactory jsonFactory, TypeManager typeManager) {
        this.server = server;
        this.typeManager = typeManager;
        this.jsonFactory = jsonFactory != null ? jsonFactory : new JsonFactory();
        this.defaultObjectMapper = this.server.getServerConfig().getObjectMapper();
        this.defaultInclude = this.server.getServerConfig().getJsonInclude();
    }

    @Override
    public JsonScalar getScalar(JsonGenerator generator) {
        return new DefaultJsonScalar(this.typeManager, new WriteJson(generator, this.defaultInclude));
    }

    @Override
    public boolean isSupportedType(Type genericType) {
        return this.server.isSupportedType(genericType);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) throws JsonIOException {
        try {
            return this.jsonFactory.createGenerator(writer);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public JsonParser createParser(Reader reader) throws JsonIOException {
        try {
            return this.jsonFactory.createParser(reader);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public <T> T toBean(Class<T> cls, String json) throws JsonIOException {
        return this.toBean(cls, new StringReader(json));
    }

    @Override
    public <T> T toBean(Class<T> cls, String json, JsonReadOptions options) throws JsonIOException {
        return this.toBean(cls, new StringReader(json), options);
    }

    @Override
    public <T> T toBean(Class<T> cls, Reader jsonReader) throws JsonIOException {
        return this.toBean(cls, this.createParser(jsonReader));
    }

    @Override
    public <T> T toBean(Class<T> cls, Reader jsonReader, JsonReadOptions options) throws JsonIOException {
        return this.toBean(cls, this.createParser(jsonReader), options);
    }

    @Override
    public <T> T toBean(Class<T> cls, JsonParser parser) throws JsonIOException {
        return this.toBean(cls, parser, null);
    }

    @Override
    public <T> T toBean(Class<T> cls, JsonParser parser, JsonReadOptions options) throws JsonIOException {
        ReadJson readJson = new ReadJson(parser, options, this.determineObjectMapper(options));
        try {
            BeanDescriptor<T> d = this.getDescriptor(cls);
            return d.jsonRead(readJson, null);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public <T> List<T> toList(Class<T> cls, String json) throws JsonIOException {
        return this.toList(cls, new StringReader(json));
    }

    @Override
    public <T> List<T> toList(Class<T> cls, String json, JsonReadOptions options) throws JsonIOException {
        return this.toList(cls, new StringReader(json), options);
    }

    @Override
    public <T> List<T> toList(Class<T> cls, Reader jsonReader) throws JsonIOException {
        return this.toList(cls, this.createParser(jsonReader));
    }

    @Override
    public <T> List<T> toList(Class<T> cls, Reader jsonReader, JsonReadOptions options) throws JsonIOException {
        return this.toList(cls, this.createParser(jsonReader), options);
    }

    @Override
    public <T> List<T> toList(Class<T> cls, JsonParser src) throws JsonIOException {
        return this.toList(cls, src, null);
    }

    @Override
    public <T> List<T> toList(Class<T> cls, JsonParser src, JsonReadOptions options) throws JsonIOException {
        ReadJson readJson = new ReadJson(src, options, this.determineObjectMapper(options));
        try {
            T bean;
            JsonToken event;
            BeanDescriptor<T> d = this.getDescriptor(cls);
            ArrayList<T> list = new ArrayList<T>();
            JsonToken currentToken = src.getCurrentToken();
            if (currentToken != JsonToken.START_ARRAY && (event = src.nextToken()) != JsonToken.START_ARRAY) {
                throw new JsonParseException("Expecting start_array event but got " + event, src.getCurrentLocation());
            }
            while ((bean = d.jsonRead(readJson, null)) != null) {
                list.add(bean);
            }
            return list;
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public Object toObject(Type genericType, String json) throws JsonIOException {
        return this.toObject(genericType, this.createParser(new StringReader(json)));
    }

    @Override
    public Object toObject(Type genericType, Reader json) throws JsonIOException {
        return this.toObject(genericType, this.createParser(json));
    }

    @Override
    public Object toObject(Type genericType, JsonParser jsonParser) throws JsonIOException {
        ParamTypeHelper.TypeInfo info = ParamTypeHelper.getTypeInfo(genericType);
        ParamTypeHelper.ManyType manyType = info.getManyType();
        switch (manyType) {
            case NONE: {
                return this.toBean(info.getBeanType(), jsonParser);
            }
            case LIST: {
                return this.toList(info.getBeanType(), jsonParser);
            }
        }
        throw new JsonIOException("Type " + (Object)((Object)manyType) + " not supported");
    }

    @Override
    public void toJson(Object value, JsonGenerator generator) throws JsonIOException {
        this.toJsonNoClose(value, generator, null);
    }

    @Override
    public void toJson(Object value, JsonGenerator generator, PathProperties pathProperties) throws JsonIOException {
        this.toJsonNoClose(value, generator, JsonWriteOptions.pathProperties(pathProperties));
    }

    @Override
    public void toJson(Object o, JsonGenerator generator, JsonWriteOptions options) throws JsonIOException {
        this.toJsonNoClose(o, generator, options);
    }

    @Override
    public void toJson(Object o, Writer writer) throws JsonIOException {
        this.toJsonWithClose(o, this.createGenerator(writer), null);
    }

    @Override
    public String toJson(Object value, PathProperties pathProperties) throws JsonIOException {
        return this.toJson(value, JsonWriteOptions.pathProperties(pathProperties));
    }

    @Override
    public void toJson(Object o, Writer writer, PathProperties pathProperties) throws JsonIOException {
        this.toJsonWithClose(o, this.createGenerator(writer), JsonWriteOptions.pathProperties(pathProperties));
    }

    @Override
    public void toJson(Object o, Writer writer, JsonWriteOptions options) throws JsonIOException {
        this.toJsonWithClose(o, this.createGenerator(writer), options);
    }

    private void toJsonWithClose(Object o, JsonGenerator generator, JsonWriteOptions options) throws JsonIOException {
        try {
            this.toJsonInternal(o, generator, options);
            generator.close();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    private void toJsonNoClose(Object o, JsonGenerator generator, JsonWriteOptions options) throws JsonIOException {
        try {
            this.toJsonInternal(o, generator, options);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public String toJson(Object o) throws JsonIOException {
        return this.toJsonString(o, null);
    }

    @Override
    public String toJson(Object o, JsonWriteOptions options) throws JsonIOException {
        return this.toJsonString(o, options);
    }

    private String toJsonString(Object value, JsonWriteOptions options) throws JsonIOException {
        try {
            StringWriter writer = new StringWriter(500);
            JsonGenerator gen = this.createGenerator(writer);
            this.toJsonInternal(value, gen, options);
            gen.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    private void toJsonInternal(Object value, JsonGenerator gen, JsonWriteOptions options) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else if (value instanceof Number) {
            gen.writeNumber(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            gen.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            gen.writeString((String)value);
        } else if (value instanceof Map) {
            this.toJsonFromMap((Map)value, gen, options);
        } else if (value instanceof Collection) {
            this.toJsonFromCollection((Collection)value, null, gen, options);
        } else if (value instanceof EntityBean) {
            BeanDescriptor<?> d = this.getDescriptor(value.getClass());
            WriteJson writeJson = this.createWriteJson(gen, options);
            d.jsonWrite(writeJson, (EntityBean)value, null);
        }
    }

    private WriteJson createWriteJson(JsonGenerator gen, JsonWriteOptions options) {
        PathProperties pathProps = options == null ? null : options.getPathProperties();
        Map<String, JsonWriteBeanVisitor<?>> visitors = options == null ? null : options.getVisitorMap();
        return new WriteJson(this.server, gen, pathProps, visitors, this.determineObjectMapper(options), this.determineInclude(options));
    }

    private <T> void toJsonFromCollection(Collection<T> collection, String key, JsonGenerator gen, JsonWriteOptions options) throws IOException {
        if (key != null) {
            gen.writeFieldName(key);
        }
        gen.writeStartArray();
        WriteJson writeJson = this.createWriteJson(gen, options);
        for (T bean : collection) {
            BeanDescriptor<?> d = this.getDescriptor(bean.getClass());
            d.jsonWrite(writeJson, (EntityBean)bean, null);
        }
        gen.writeEndArray();
    }

    private void toJsonFromMap(Map<Object, Object> map, JsonGenerator gen, JsonWriteOptions options) throws IOException {
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<Object, Object>> it = entrySet.iterator();
        WriteJson writeJson = this.createWriteJson(gen, options);
        gen.writeStartObject();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) {
                gen.writeNullField(key);
                continue;
            }
            if (value instanceof Collection) {
                this.toJsonFromCollection((Collection)value, key, gen, options);
                continue;
            }
            if (value instanceof EntityBean) {
                BeanDescriptor<?> d = this.getDescriptor(value.getClass());
                d.jsonWrite(writeJson, (EntityBean)value, key);
                continue;
            }
            EJson.write(entry, gen);
        }
        gen.writeEndObject();
    }

    private <T> BeanDescriptor<T> getDescriptor(Class<T> beanType) {
        BeanDescriptor<T> d = this.server.getBeanDescriptor(beanType);
        if (d == null) {
            throw new RuntimeException("No BeanDescriptor found for " + beanType);
        }
        return d;
    }

    private Object determineObjectMapper(JsonReadOptions options) {
        if (options == null) {
            return this.defaultObjectMapper;
        }
        Object mapper = options.getObjectMapper();
        return mapper != null ? mapper : this.defaultObjectMapper;
    }

    private Object determineObjectMapper(JsonWriteOptions options) {
        if (options == null) {
            return this.defaultObjectMapper;
        }
        Object mapper = options.getObjectMapper();
        return mapper != null ? mapper : this.defaultObjectMapper;
    }

    private JsonConfig.Include determineInclude(JsonWriteOptions options) {
        if (options == null) {
            return this.defaultInclude;
        }
        JsonConfig.Include include = options.getInclude();
        return include != null ? include : this.defaultInclude;
    }
}

