/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.json;

import com.avaje.ebean.text.json.JsonReadBeanVisitor;
import com.avaje.ebean.text.json.JsonReadOptions;
import com.avaje.ebeaninternal.server.text.json.PathStack;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;

public class ReadJson {
    final JsonParser parser;
    final PathStack pathStack;
    final Map<String, JsonReadBeanVisitor<?>> visitorMap;
    final Object objectMapper;

    public ReadJson(JsonParser parser, JsonReadOptions readOptions, Object objectMapper) {
        this.parser = parser;
        this.objectMapper = objectMapper;
        this.visitorMap = readOptions == null ? null : readOptions.getVisitorMap();
        this.pathStack = this.visitorMap == null ? null : new PathStack();
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            throw new IllegalStateException("Jackson ObjectMapper required but has not set. The ObjectMapper can be set on either the ServerConfig or on JsonReadOptions.");
        }
        return (ObjectMapper)this.objectMapper;
    }

    public JsonParser getParser() {
        return this.parser;
    }

    public JsonToken nextToken() throws IOException {
        return this.parser.nextToken();
    }

    public void pushPath(String path) {
        if (this.pathStack != null) {
            this.pathStack.pushPathKey(path);
        }
    }

    public void popPath() {
        if (this.pathStack != null) {
            this.pathStack.pop();
        }
    }

    public void beanVisitor(Object bean, Map<String, Object> unmappedProperties) {
        JsonReadBeanVisitor<?> visitor;
        if (this.visitorMap != null && (visitor = this.visitorMap.get(this.pathStack.peekWithNull())) != null) {
            visitor.visit(bean, unmappedProperties);
        }
    }

    public Object readValueUsingObjectMapper(Class<?> propertyType) throws IOException {
        return this.getObjectMapper().readValue(this.parser, propertyType);
    }
}

