/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.DateTimeJsonParser;
import com.avaje.ebeaninternal.server.type.DecimalUtils;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;

public abstract class ScalarTypeBaseDateTime<T>
extends ScalarTypeBase<T> {
    protected final DateTimeJsonParser dateTimeParser = new DateTimeJsonParser();
    protected final JsonConfig.DateTime mode;

    public ScalarTypeBaseDateTime(JsonConfig.DateTime mode, Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
        this.mode = mode;
    }

    public abstract Timestamp convertToTimestamp(T var1);

    public abstract T convertFromTimestamp(Timestamp var1);

    @Override
    public abstract T convertFromMillis(long var1);

    public abstract long convertToMillis(T var1);

    protected abstract String toJsonNanos(T var1);

    protected abstract String toJsonISO8601(T var1);

    @Override
    public void bind(DataBind b, T value) throws SQLException {
        if (value == null) {
            b.setNull(93);
        } else {
            b.setTimestamp(this.convertToTimestamp(value));
        }
    }

    @Override
    public T read(DataReader dataReader) throws SQLException {
        Timestamp ts = dataReader.getTimestamp();
        if (ts == null) {
            return null;
        }
        return this.convertFromTimestamp(ts);
    }

    protected String toJsonNanos(long epochSecs, int nanos) {
        return DecimalUtils.toDecimal(epochSecs, nanos);
    }

    @Override
    public T jsonRead(JsonParser parser, JsonToken event) throws IOException {
        switch (event) {
            case VALUE_NUMBER_INT: {
                return this.convertFromMillis(parser.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                BigDecimal value = parser.getDecimalValue();
                Timestamp timestamp = DecimalUtils.toTimestamp(value);
                return this.convertFromTimestamp(timestamp);
            }
        }
        String jsonDateTime = parser.getText();
        return this.convertFromTimestamp(this.dateTimeParser.parse(jsonDateTime));
    }

    @Override
    public void jsonWrite(JsonWriter writer, String name, T value) throws IOException {
        switch (this.mode) {
            case ISO8601: {
                writer.writeFieldName(name);
                writer.gen().writeString(this.toJsonISO8601(value));
                break;
            }
            case NANOS: {
                writer.writeFieldName(name);
                writer.gen().writeNumber(this.toJsonNanos(value));
                break;
            }
            default: {
                writer.gen().writeNumberField(name, this.convertToMillis(value));
            }
        }
    }

    @Override
    public String formatValue(T t) {
        Timestamp ts = this.convertToTimestamp(t);
        return ts.toString();
    }

    @Override
    public T parse(String value) {
        Timestamp ts = Timestamp.valueOf(value);
        return this.convertFromTimestamp(ts);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        long val = dataInput.readLong();
        Timestamp ts = new Timestamp(val);
        return this.convertFromTimestamp(ts);
    }

    @Override
    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            Timestamp ts = this.convertToTimestamp(value);
            dataOutput.writeLong(ts.getTime());
        }
    }
}

