/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;

public abstract class ScalarTypeJsonMap
extends ScalarTypeBase<Map> {
    public ScalarTypeJsonMap(int jdbcType) {
        super(Map.class, false, jdbcType);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return !(value instanceof ModifyAwareOwner) || ((ModifyAwareOwner)value).isMarkedDirty();
    }

    @Override
    public Map read(DataReader dataReader) throws SQLException {
        String rawJson = dataReader.getString();
        if (rawJson == null) {
            return null;
        }
        return this.parse(rawJson);
    }

    @Override
    public void bind(DataBind b, Map value) throws SQLException {
        if (value == null) {
            b.setNull(12);
        } else {
            String rawJson = this.formatValue(value);
            b.setString(rawJson);
        }
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public Map toBeanType(Object value) {
        return (Map)value;
    }

    @Override
    public String formatValue(Map v) {
        try {
            return EJson.write(v);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public Map parse(String value) {
        try {
            return EJson.parseObject(value, true);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    public Map parse(Reader reader) {
        try {
            return EJson.parseObject(reader, true);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public Map convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Map readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String json = dataInput.readUTF();
        return this.parse(json);
    }

    @Override
    public void writeData(DataOutput dataOutput, Map v) throws IOException {
        if (v == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            String json = this.format(v);
            dataOutput.writeUTF(json);
        }
    }

    @Override
    public void jsonWrite(JsonWriter writer, String name, Map value) throws IOException {
        if (value == null) {
            writer.writeNullField(name);
        } else if (!value.isEmpty() || writer.isIncludeEmpty()) {
            writer.writeFieldName(name);
            EJson.write((Object)value, writer.gen());
        }
    }

    @Override
    public Map jsonRead(JsonParser parser, JsonToken event) throws IOException {
        return EJson.parseObject(parser, event);
    }

    public static class Blob
    extends ScalarTypeJsonMap {
        public Blob() {
            super(2004);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map read(DataReader dataReader) throws SQLException {
            Map map;
            InputStream is = dataReader.getBinaryStream();
            if (is == null) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader(is);
            try {
                map = this.parse(reader);
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("Error reading Blob stream from DB", e);
                }
            }
            reader.close();
            return map;
        }

        @Override
        public void bind(DataBind b, Map value) throws SQLException {
            if (value == null) {
                b.setNull(2004);
            } else {
                String rawJson = this.formatValue(value);
                b.setBytes(rawJson.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static class Varchar
    extends ScalarTypeJsonMap {
        public Varchar() {
            super(12);
        }
    }

    public static class Clob
    extends ScalarTypeJsonMap {
        public Clob() {
            super(2005);
        }

        @Override
        public Map read(DataReader dataReader) throws SQLException {
            String content = dataReader.getStringFromStream();
            if (content == null) {
                return null;
            }
            return this.parse(content);
        }
    }
}

