/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import org.postgresql.util.PGobject;

public abstract class ScalarTypeJsonNodePostgres
extends ScalarTypeJsonNode {
    private static final String POSTGRES_TYPE_JSON = "json";
    private static final String POSTGRES_TYPE_JSONB = "jsonb";
    final ObjectMapper objectMapper;
    final String postgresType;

    ScalarTypeJsonNodePostgres(ObjectMapper objectMapper, int jdbcType, String postgresType) {
        super(objectMapper, jdbcType);
        this.objectMapper = objectMapper;
        this.postgresType = postgresType;
    }

    @Override
    public void bind(DataBind dataBind, JsonNode value) throws SQLException {
        String rawJson = value == null ? null : this.formatValue(value);
        PGobject pgo = new PGobject();
        pgo.setType(this.postgresType);
        pgo.setValue(rawJson);
        dataBind.setObject(pgo);
    }

    public static class JSONB
    extends ScalarTypeJsonNodePostgres {
        public JSONB(ObjectMapper objectMapper) {
            super(objectMapper, 5002, ScalarTypeJsonNodePostgres.POSTGRES_TYPE_JSONB);
        }
    }

    public static class JSON
    extends ScalarTypeJsonNodePostgres {
        public JSON(ObjectMapper objectMapper) {
            super(objectMapper, 5001, ScalarTypeJsonNodePostgres.POSTGRES_TYPE_JSON);
        }
    }
}

