/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.util;

import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.core.JsonExpressionHandler;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import com.avaje.ebeaninternal.server.persist.Binder;
import java.util.ArrayList;

public class DefaultExpressionRequest
implements SpiExpressionRequest {
    private final SpiOrmQueryRequest<?> queryRequest;
    private final BeanDescriptor<?> beanDescriptor;
    private final StringBuilder sb = new StringBuilder();
    private final ArrayList<Object> bindValues = new ArrayList();
    private final DeployParser deployParser;
    private final Binder binder;
    private int paramIndex;

    public DefaultExpressionRequest(SpiOrmQueryRequest<?> queryRequest, DeployParser deployParser, Binder binder) {
        this.queryRequest = queryRequest;
        this.beanDescriptor = queryRequest.getBeanDescriptor();
        this.deployParser = deployParser;
        this.binder = binder;
    }

    public DefaultExpressionRequest(BeanDescriptor<?> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
        this.queryRequest = null;
        this.deployParser = null;
        this.binder = null;
    }

    @Override
    public JsonExpressionHandler getJsonHander() {
        return this.binder.getJsonExpressionHandler();
    }

    @Override
    public String parseDeploy(String logicalProp) {
        String s = this.deployParser.getDeployWord(logicalProp);
        return s == null ? logicalProp : s;
    }

    @Override
    public void appendLike() {
        this.sb.append(" ");
        this.sb.append(this.queryRequest.getDBLikeClause());
        this.sb.append(" ");
    }

    @Override
    public int nextParameter() {
        return ++this.paramIndex;
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public SpiOrmQueryRequest<?> getQueryRequest() {
        return this.queryRequest;
    }

    @Override
    public SpiExpressionRequest append(String sql) {
        this.sb.append(sql);
        return this;
    }

    @Override
    public void addBindValue(Object bindValue) {
        this.bindValues.add(bindValue);
    }

    @Override
    public String getSql() {
        return this.sb.toString();
    }

    @Override
    public ArrayList<Object> getBindValues() {
        return this.bindValues;
    }
}

