package com.avaje.ebeaninternal.server.lib.resource;

/**
 * A Source for ResourceManager.
 * <p>
 * Typically a File System Directory based source or a ServletContext URL
 * resource based source (for Servlet WAR files).
 * </p>
 */
public interface ResourceSource {

	/**
	 * Return the File System path of the root of the ResourceSource.
	 * <p>
	 * This will return null IF the ResourceSource is an unpacked WAR file.
	 * </p>
	 */
	String getRealPath();
	
	/**
	 * Find the content with a given entry name. This will return null if no
	 * matching content was found.
	 */
	ResourceContent getContent(String entry);

}
