/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import io.vavr.Tuple2;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import org.awsutils.dynamodb.annotations.DbAttribute;
import org.awsutils.dynamodb.annotations.KeyType;
import org.awsutils.dynamodb.repositories.GSI;
import org.springframework.util.StringUtils;

final class AttributeMapper<T> {
    private final Class<T> mappedClass;
    private final Map<String, Tuple2<Field, DbAttribute>> mappedFields;
    private final Constructor<T> constructor;
    private final Map<KeyType, Tuple2<String, Field>> primaryKeyMapping;
    private final Map<String, GSI> globalSecondaryIndexMap;
    private final String tableName;
    private final Tuple2<String, Field> dateUpdatedField;
    private final Tuple2<String, Field> dateCreatedField;
    private final Tuple2<Field, DbAttribute> versionAttributeField;

    private AttributeMapper(Class<T> mappedClass, Map<String, Tuple2<Field, DbAttribute>> mappedFields, Constructor<T> constructor, Map<KeyType, Tuple2<String, Field>> primaryKeyMapping, String tableName, Tuple2<String, Field> dateUpdatedField, Tuple2<String, Field> dateCreatedField, Map<String, GSI> globalSecondaryIndexMap, Tuple2<Field, DbAttribute> versionAttributeField) {
        this.mappedClass = mappedClass;
        this.mappedFields = mappedFields;
        this.constructor = constructor;
        this.primaryKeyMapping = primaryKeyMapping;
        this.tableName = !StringUtils.isEmpty((Object)tableName) ? tableName : mappedClass.getSimpleName();
        this.dateUpdatedField = dateUpdatedField;
        this.dateCreatedField = dateCreatedField;
        this.globalSecondaryIndexMap = globalSecondaryIndexMap;
        this.versionAttributeField = versionAttributeField;
    }

    public static <T> Builder<T> builder() {
        return new AttributeMapperBuilder();
    }

    public Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public Map<String, Tuple2<Field, DbAttribute>> getMappedFields() {
        return this.mappedFields;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public Map<KeyType, Tuple2<String, Field>> getPrimaryKeyMapping() {
        return this.primaryKeyMapping;
    }

    public Map<String, GSI> getGlobalSecondaryIndexMap() {
        return this.globalSecondaryIndexMap;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Tuple2<String, Field> getDateUpdatedField() {
        return this.dateUpdatedField;
    }

    public Tuple2<String, Field> getDateCreatedField() {
        return this.dateCreatedField;
    }

    public Tuple2<Field, DbAttribute> getVersionAttributeField() {
        return this.versionAttributeField;
    }

    private static class AttributeMapperBuilder<T>
    implements Builder<T> {
        private Class<T> mappedClass;
        private Map<String, Tuple2<Field, DbAttribute>> mappedFields;
        private Constructor<T> constructor;
        private Map<KeyType, Tuple2<String, Field>> primaryKeyMapping;
        private String tableName;
        private Tuple2<String, Field> dateUpdatedField;
        private Tuple2<String, Field> dateCreatedField;
        private Map<String, GSI> globalSecondaryIndexMap;
        private Tuple2<Field, DbAttribute> versionAttributeField;

        private AttributeMapperBuilder() {
        }

        @Override
        public Builder<T> mappedClass(Class<T> mappedClass) {
            this.mappedClass = mappedClass;
            return this;
        }

        @Override
        public Builder<T> mappedFields(Map<String, Tuple2<Field, DbAttribute>> mappedFields) {
            this.mappedFields = mappedFields;
            return this;
        }

        @Override
        public Builder<T> constructor(Constructor<T> constructor) {
            this.constructor = constructor;
            return this;
        }

        @Override
        public Builder<T> primaryKeyMapping(Map<KeyType, Tuple2<String, Field>> primaryKeyMapping) {
            this.primaryKeyMapping = primaryKeyMapping;
            return this;
        }

        @Override
        public Builder<T> tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder<T> dateUpdatedField(Tuple2<String, Field> dateUpdatedField) {
            this.dateUpdatedField = dateUpdatedField;
            return this;
        }

        @Override
        public Builder<T> dateCreatedField(Tuple2<String, Field> dateCreatedField) {
            this.dateCreatedField = dateCreatedField;
            return this;
        }

        @Override
        public Builder<T> globalSecondaryIndexMap(Map<String, GSI> globalSecondaryIndexMap) {
            this.globalSecondaryIndexMap = globalSecondaryIndexMap;
            return this;
        }

        @Override
        public Builder<T> versionAttributeField(Tuple2<Field, DbAttribute> versionAttributeField) {
            this.versionAttributeField = versionAttributeField;
            return this;
        }

        @Override
        public AttributeMapper<T> build() {
            return new AttributeMapper<T>(this.mappedClass, this.mappedFields, this.constructor, this.primaryKeyMapping, this.tableName, this.dateUpdatedField, this.dateCreatedField, this.globalSecondaryIndexMap, this.versionAttributeField);
        }
    }

    public static interface Builder<T> {
        public Builder<T> mappedClass(Class<T> var1);

        public Builder<T> mappedFields(Map<String, Tuple2<Field, DbAttribute>> var1);

        public Builder<T> constructor(Constructor<T> var1);

        public Builder<T> primaryKeyMapping(Map<KeyType, Tuple2<String, Field>> var1);

        public Builder<T> tableName(String var1);

        public Builder<T> dateUpdatedField(Tuple2<String, Field> var1);

        public Builder<T> dateCreatedField(Tuple2<String, Field> var1);

        public Builder<T> globalSecondaryIndexMap(Map<String, GSI> var1);

        public Builder<T> versionAttributeField(Tuple2<Field, DbAttribute> var1);

        public AttributeMapper<T> build();
    }
}

