/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple4;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.awsutils.common.util.Utils;
import org.awsutils.dynamodb.annotations.DbAttribute;
import org.awsutils.dynamodb.annotations.KeyType;
import org.awsutils.dynamodb.data.PrimaryKey;
import org.awsutils.dynamodb.exceptions.DbException;
import org.awsutils.dynamodb.repositories.AttributeMapper;
import org.awsutils.dynamodb.repositories.MapperUtils;
import org.awsutils.dynamodb.utils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

interface DataMapper<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(DataMapper.class);

    default public T mapFromAttributeValueToEntity(Map<String, AttributeValue> attributeValues) {
        AttributeMapper<?> fieldMapping = MapperUtils.getInstance().getAttributeMappingMap().get(this.getParameterType().getName());
        Constructor<?> constructor = fieldMapping.getConstructor();
        Object mappedObject = Utils.constructObject(constructor);
        Map<String, Tuple2<Field, DbAttribute>> fieldMap = fieldMapping.getMappedFields();
        attributeValues.entrySet().stream().filter(a -> fieldMap.get(a.getKey()) != null).forEach(entry -> ReflectionUtils.setField((Field)((Field)((Tuple2)fieldMap.get(entry.getKey()))._1()), (Object)mappedObject, (Object)DbUtils.attributeToModel((Field)((Tuple2)fieldMap.get(entry.getKey()))._1()).apply((AttributeValue)entry.getValue())));
        return (T)mappedObject;
    }

    default public Map<String, AttributeValue> mapFromEntityToAttributeValue(T input) {
        AttributeMapper<?> fieldMapping = MapperUtils.getInstance().getAttributeMappingMap().get(this.getParameterType().getName());
        Map<String, Tuple2<Field, DbAttribute>> fieldMap = fieldMapping.getMappedFields();
        return fieldMapping.getMappedFields().keySet().stream().map(key -> Tuple.of((Object)key, (Object)ReflectionUtils.getField((Field)((Field)((Tuple2)fieldMap.get(key))._1()), (Object)input))).filter(a -> a._2() != null).map(t -> Tuple.of((Object)((String)t._1()), (Object)((AttributeValue)DbUtils.modelToAttributeValue((Field)((Tuple2)fieldMap.get(t._1()))._1(), t._2()).apply(AttributeValue.builder()).build()))).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
    }

    default public Tuple2<Field, DbAttribute> getVersionedAttribute() {
        AttributeMapper<?> fieldMapping = MapperUtils.getInstance().getAttributeMappingMap().get(this.getParameterType().getName());
        return fieldMapping.getVersionAttributeField();
    }

    default public Map<String, AttributeValue> getPrimaryKey(PrimaryKey primaryKey) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put(primaryKey.getHashKeyName(), (AttributeValue)this.getAttributeBuilderFunctionForKeys(primaryKey.getHashKeyValue()).apply(AttributeValue.builder()).build());
        if (!StringUtils.isEmpty((Object)primaryKey.getRangeKeyName())) {
            key.put(primaryKey.getRangeKeyName(), (AttributeValue)this.getAttributeBuilderFunctionForKeys(primaryKey.getRangeKeyValue()).apply(AttributeValue.builder()).build());
        }
        return key;
    }

    default public Function<AttributeValue.Builder, AttributeValue.Builder> getAttributeBuilderFunctionForKeys(Object keyValue) {
        Function<AttributeValue.Builder, AttributeValue.Builder> builderFn;
        if (keyValue instanceof String) {
            builderFn = builder -> builder.s((String)keyValue);
        } else if (keyValue instanceof Number) {
            builderFn = builder -> builder.n(Utils.getUnformattedNumber((Number)((Number)keyValue)));
        } else if (keyValue.getClass().isEnum()) {
            builderFn = builder -> builder.s((String)Utils.invokeMethod((Object)keyValue, (String)"name"));
        } else {
            throw new DbException("Only string and number type supported for hash/range key values");
        }
        return builderFn;
    }

    default public PrimaryKey createPKFromItem(T item) {
        AttributeMapper<?> fieldMapping = MapperUtils.getInstance().getAttributeMappingMap().get(this.getParameterType().getName());
        Map<KeyType, Tuple2<String, Field>> pkMap = fieldMapping.getPrimaryKeyMapping();
        Tuple2<String, Field> hashKeyTuple = pkMap.get((Object)KeyType.HASH_KEY);
        Tuple2<String, Field> rangeKeyTuple = pkMap.get((Object)KeyType.RANGE_KEY);
        PrimaryKey.Builder pkBuilder = PrimaryKey.builder();
        Object hashKeyValue = DbUtils.serializeValue((Field)hashKeyTuple._2(), ReflectionUtils.getField((Field)((Field)hashKeyTuple._2()), item));
        pkBuilder.hashKeyValue(hashKeyValue instanceof Long || hashKeyValue instanceof Integer ? hashKeyValue : String.valueOf(hashKeyValue)).hashKeyName((String)hashKeyTuple._1());
        if (rangeKeyTuple != null) {
            Object rangeKeyValue = DbUtils.serializeValue((Field)rangeKeyTuple._2(), ReflectionUtils.getField((Field)((Field)rangeKeyTuple._2()), item));
            pkBuilder.rangeKeyValue(rangeKeyValue instanceof Long || rangeKeyValue instanceof Integer ? rangeKeyValue : String.valueOf(rangeKeyValue)).rangeKeyName((String)rangeKeyTuple._1());
        }
        return pkBuilder.build();
    }

    default public void applyTTLLogic(T item, Map<String, AttributeValue> attributeValueMap) {
        throw new UnsupportedOperationException();
    }

    public Class<T> getParameterType();

    default public String tableName() {
        return MapperUtils.getInstance().getAttributeMappingMap().get(this.getParameterType().getName()).getTableName();
    }

    default public Stream<Tuple4<String, Object, Field, DbAttribute>> getMappedValues(T input) {
        String parameterType = this.getParameterType().getName();
        return MapperUtils.getInstance().getMappedValues(input, parameterType);
    }

    default public Map<KeyType, Tuple2<String, Field>> getPKMapping() {
        return MapperUtils.getInstance().getAttributeMappingMap().get(this.getParameterType().getName()).getPrimaryKeyMapping();
    }
}

