/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.jgroups.commandhandling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.axonframework.commandhandling.distributed.ReplyMessage;
import org.axonframework.serialization.Serializer;
import org.jgroups.util.Streamable;

public class JGroupsReplyMessage
extends ReplyMessage
implements Streamable,
Externalizable {
    private static final long serialVersionUID = 6955710928767199410L;
    private static final String NULL = "_null";

    public JGroupsReplyMessage() {
    }

    public JGroupsReplyMessage(String commandIdentifier, boolean success, Object returnValue, Serializer serializer) {
        super(commandIdentifier, success, returnValue, serializer);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.commandIdentifier);
        out.writeBoolean(this.success);
        if (this.resultType == null) {
            out.writeUTF(NULL);
        } else {
            out.writeUTF(this.resultType);
            out.writeUTF(this.resultRevision == null ? NULL : this.resultRevision);
            out.writeInt(this.serializedResult.length);
            out.write(this.serializedResult);
        }
    }

    public void readFrom(DataInput in) throws IOException {
        this.commandIdentifier = in.readUTF();
        this.success = in.readBoolean();
        this.resultType = in.readUTF();
        if (NULL.equals(this.resultType)) {
            this.resultType = null;
        } else {
            this.resultRevision = in.readUTF();
            if (NULL.equals(this.resultRevision)) {
                this.resultRevision = null;
            }
            this.serializedResult = new byte[in.readInt()];
            in.readFully(this.serializedResult);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readFrom(in);
    }
}

