/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.deadline;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.deadline.ScheduledDeadlineInfo;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class DeadlineManagerValidator {
    private final StubDeadlineManager deadlineManager;
    private final FieldFilter fieldFilter;

    public DeadlineManagerValidator(StubDeadlineManager deadlineManager, FieldFilter fieldFilter) {
        this.deadlineManager = deadlineManager;
        this.fieldFilter = fieldFilter;
    }

    public Instant currentDateTime() {
        return this.deadlineManager.getCurrentDateTime();
    }

    public void assertScheduledDeadlineMatching(Duration duration, Matcher<?> matcher) {
        Instant targetTime = this.currentDateTime().plus(duration);
        this.assertScheduledDeadlineMatching(targetTime, matcher);
    }

    public void assertScheduledDeadlineMatching(Instant scheduledTime, Matcher<?> matcher) {
        List<ScheduledDeadlineInfo> scheduledDeadlines = this.deadlineManager.getScheduledDeadlines();
        for (ScheduledDeadlineInfo scheduledDeadline : scheduledDeadlines) {
            if (!scheduledDeadline.getScheduleTime().equals(scheduledTime) || !matcher.matches(scheduledDeadline.deadlineMessage())) continue;
            return;
        }
        StringDescription expected = new StringDescription();
        StringDescription actual = new StringDescription();
        matcher.describeTo((Description)expected);
        this.describe(scheduledDeadlines, (Description)actual);
        throw new AxonAssertionError(String.format("Did not find a deadline at the given deadline manager. \nExpected:\n<%s> at <%s>\nGot:%s\n", expected, scheduledTime, actual));
    }

    public void assertNoScheduledDeadlineMatching(Matcher<?> matcher) {
        for (ScheduledDeadlineInfo scheduledDeadline : this.deadlineManager.getScheduledDeadlines()) {
            if (!matcher.matches(scheduledDeadline.deadlineMessage())) continue;
            StringDescription unexpected = new StringDescription();
            matcher.describeTo((Description)unexpected);
            throw new AxonAssertionError(String.format("Unexpected matching deadline found at the given deadline manager. \nGot:%s\n", unexpected));
        }
    }

    public void assertDeadlinesMetMatching(Matcher<? extends Iterable<?>> matcher) {
        List<ScheduledDeadlineInfo> deadlinesMet = this.deadlineManager.getDeadlinesMet();
        List deadlineMessages = deadlinesMet.stream().map(ScheduledDeadlineInfo::deadlineMessage).collect(Collectors.toList());
        if (!matcher.matches(deadlineMessages)) {
            StringDescription expected = new StringDescription();
            StringDescription actual = new StringDescription();
            matcher.describeTo((Description)expected);
            this.describe(deadlinesMet, (Description)actual);
            throw new AxonAssertionError(String.format("Expected deadlines were not met at the given deadline manager. \nExpected:\n<%s>\nGot:%s\n", expected, actual));
        }
    }

    public void assertDeadlinesMet(Object ... expected) {
        List<ScheduledDeadlineInfo> deadlinesMet = this.deadlineManager.getDeadlinesMet();
        if (deadlinesMet.size() != expected.length) {
            throw new AxonAssertionError(String.format("Got wrong number of deadlines met. Expected <%s>, got <%s>", expected.length, deadlinesMet.size()));
        }
        this.assertDeadlinesMetMatching(Matchers.payloadsMatching(Matchers.exactSequenceOf(this.createEqualToMatchers(expected))));
    }

    public void assertNoScheduledDeadlines() {
        List<ScheduledDeadlineInfo> scheduledDeadlines = this.deadlineManager.getScheduledDeadlines();
        if (scheduledDeadlines != null && !scheduledDeadlines.isEmpty()) {
            throw new AxonAssertionError("Expected no scheduled deadlines, got " + scheduledDeadlines.size());
        }
    }

    private void describe(List<ScheduledDeadlineInfo> scheduleDeadlines, Description description) {
        if (scheduleDeadlines.isEmpty()) {
            description.appendText("\n<no scheduled events>");
        }
        for (ScheduledDeadlineInfo item : scheduleDeadlines) {
            description.appendText("\n<").appendText(item.deadlineMessage().toString()).appendText("> at <").appendText(DateTimeUtils.formatInstant((TemporalAccessor)item.getScheduleTime())).appendText(">");
        }
    }

    private Matcher<Object>[] createEqualToMatchers(Object[] expected) {
        ArrayList<EqualFieldsMatcher<Object>> matchers = new ArrayList<EqualFieldsMatcher<Object>>(expected.length);
        for (Object deadline : expected) {
            matchers.add(Matchers.equalTo(deadline, this.fieldFilter));
        }
        return matchers.toArray(new Matcher[0]);
    }
}

