/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.lsp.server.AyaLanguageClient;
import org.aya.lsp.server.AyaLanguageServer;
import org.aya.lsp.utils.Log;
import org.aya.lsp.utils.LspArgs;
import org.javacs.lsp.LSP;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

public class LspMain
extends LspArgs
implements Callable<Integer> {
    public static void main(String[] args) {
        new CommandLine((Object)new LspMain()).execute(args);
    }

    @Override
    public Integer call() throws Exception {
        Log.i("Hello, this is Aya language server", new Object[0]);
        Startup startup = switch (this.mode) {
            default -> throw new RuntimeException(null, null);
            case LspArgs.Mode.server -> this.runServer();
            case LspArgs.Mode.client -> this.runClient();
            case LspArgs.Mode.debug -> LspMain.runDebug();
        };
        LSP.connect(AyaLanguageClient.class, client -> new AyaLanguageServer(CompilerAdvisor.inMemory(), (AyaLanguageClient)client), (InputStream)startup.in, (OutputStream)startup.out);
        return 0;
    }

    @NotNull
    private static Startup runDebug() {
        Log.i("Debug mode, using stdin and stdout", new Object[0]);
        return new Startup(System.in, System.out);
    }

    @NotNull
    private Startup runClient() throws IOException {
        Log.i("Client mode, connecting to %s:%d", this.host, this.port);
        Socket socket = new Socket(this.host, this.port);
        return new Startup(new CloseAwareInputStream(socket.getInputStream()), socket.getOutputStream());
    }

    @NotNull
    private Startup runServer() throws IOException {
        Log.i("Server mode, listening on %s:%d", this.host, this.port);
        try (ServerSocket server = new ServerSocket(this.port, 0, InetAddress.getByName(this.host));){
            Socket client = server.accept();
            Startup startup = new Startup(new CloseAwareInputStream(client.getInputStream()), client.getOutputStream());
            return startup;
        }
    }

    private record Startup(@NotNull InputStream in, @NotNull OutputStream out) {
    }

    private static class CloseAwareInputStream
    extends InputStream {
        private final InputStream inputStream;

        private CloseAwareInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        private int closeIfRemoteClosed(int len) throws IOException {
            if (len < 0) {
                this.inputStream.close();
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            return this.closeIfRemoteClosed(this.inputStream.read());
        }

        @Override
        public int read(byte @NotNull [] b) throws IOException {
            return this.closeIfRemoteClosed(this.inputStream.read(b));
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            return this.closeIfRemoteClosed(this.inputStream.read(b, off, len));
        }
    }
}

