/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.actions;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.ide.Resolver;
import org.aya.ide.action.FindReferences;
import org.aya.ide.syntax.SyntaxDeclAction;
import org.aya.lsp.utils.LspRange;
import org.aya.util.error.SourcePos;
import org.javacs.lsp.CodeLens;
import org.javacs.lsp.Command;
import org.javacs.lsp.Range;
import org.jetbrains.annotations.NotNull;

public record LensMaker(@NotNull SeqView<LibraryOwner> libraries, @NotNull MutableList<CodeLens> codeLens) implements SyntaxDeclAction
{
    @NotNull
    public static List<CodeLens> invoke(@NotNull LibrarySource source, @NotNull SeqView<LibraryOwner> libraries) {
        LensMaker maker = new LensMaker(libraries, (MutableList<CodeLens>)MutableList.create());
        ImmutableSeq program = (ImmutableSeq)source.program().get();
        if (program != null) {
            program.forEach((Consumer)((Object)maker));
        }
        return maker.codeLens.asJava();
    }

    @NotNull
    public static CodeLens resolve(@NotNull CodeLens codeLens) {
        Command cmd = (Command)new Gson().fromJson((JsonElement)codeLens.data, Command.class);
        return new CodeLens(codeLens.range, cmd, codeLens.data);
    }

    public void accept(@NotNull Stmt stmt) {
        if (stmt instanceof Decl) {
            Decl maybe = (Decl)stmt;
            Resolver.withChildren((Decl)maybe).filter(dv -> dv.concrete != null).forEach(dv -> {
                ImmutableSeq refs = FindReferences.findRefsOutsideDefs((SeqView)SeqView.of((Object)dv), this.libraries).toImmutableSeq();
                if (refs.size() > 0) {
                    SourcePos sourcePos = dv.concrete.sourcePos();
                    Option<URI> uri = LspRange.toFileUri(sourcePos);
                    Range range = LspRange.toRange(sourcePos);
                    String title = refs.sizeEquals(1) ? "1 usage" : "%d usages".formatted(refs.size());
                    List locations = refs.mapNotNull(LspRange::toLoc).asJava();
                    Command cmd = (Command)uri.getOrElse(it -> new Command(title, "editor.action.showReferences", List.of(it, range.end, locations)), () -> new Command(title, "", Collections.emptyList()));
                    this.codeLens.append((Object)new CodeLens(range, null, (Object)cmd));
                }
            });
        }
        super.accept(stmt);
    }
}

