/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.actions;

import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.literate.SyntaxHighlight;
import org.aya.lsp.models.HighlightResult;
import org.aya.lsp.utils.LspRange;
import org.jetbrains.annotations.NotNull;

public interface SemanticHighlight {
    @NotNull
    public static ImmutableSeq<HighlightResult> invoke(@NotNull LibraryOwner owner) {
        MutableList symbols = MutableList.create();
        SemanticHighlight.highlight(owner, (MutableList<HighlightResult>)symbols);
        return symbols.toImmutableSeq();
    }

    private static void highlight(@NotNull LibraryOwner owner, @NotNull MutableList<HighlightResult> result) {
        owner.librarySources().forEach(src -> result.append((Object)SemanticHighlight.highlightOne(src)));
        owner.libraryDeps().forEach(dep -> SemanticHighlight.highlight(dep, result));
    }

    @NotNull
    private static HighlightResult highlightOne(@NotNull LibrarySource source) {
        MutableList symbols = MutableList.create();
        ImmutableSeq program = (ImmutableSeq)source.program().get();
        if (program != null) {
            SyntaxHighlight.highlight(null, (Option)Option.none(), (ImmutableSeq)program).view().flatMap(HighlightResult.Symbol::from).forEach(arg_0 -> ((MutableList)symbols).append(arg_0));
        }
        return new HighlightResult(source.underlyingFile().toUri(), (Seq<HighlightResult.Symbol>)symbols.filter(t -> t.range() != LspRange.NONE));
    }
}

