/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.actions;

import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.literate.HighlightInfo;
import org.aya.ide.action.ProjectSymbol;
import org.aya.lsp.utils.LspRange;
import org.aya.util.prettier.PrettierOptions;
import org.javacs.lsp.DocumentSymbol;
import org.javacs.lsp.Location;
import org.javacs.lsp.Range;
import org.javacs.lsp.WorkspaceSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SymbolMaker {
    @NotNull
    public static ImmutableSeq<DocumentSymbol> documentSymbols(@NotNull PrettierOptions options, @NotNull LibrarySource source) {
        return ProjectSymbol.invoke((PrettierOptions)options, (LibrarySource)source).map(SymbolMaker::documentSymbol);
    }

    @NotNull
    public static ImmutableSeq<WorkspaceSymbol> workspaceSymbols(@NotNull PrettierOptions options, @NotNull SeqView<LibraryOwner> libraries) {
        return ProjectSymbol.invoke((PrettierOptions)options, libraries).mapNotNull(SymbolMaker::workspaceSymbol);
    }

    private static int kindOf(@NotNull HighlightInfo.DefKind kind) {
        int symbolKind = switch (kind) {
            default -> throw new RuntimeException(null, null);
            case HighlightInfo.DefKind.Data -> 10;
            case HighlightInfo.DefKind.Con -> 22;
            case HighlightInfo.DefKind.Clazz -> 23;
            case HighlightInfo.DefKind.Member -> 8;
            case HighlightInfo.DefKind.Fn, HighlightInfo.DefKind.Prim -> 12;
            case HighlightInfo.DefKind.Generalized -> 26;
            case HighlightInfo.DefKind.LocalVar -> 13;
            case HighlightInfo.DefKind.Module -> 2;
            case HighlightInfo.DefKind.Unknown -> 21;
        };
        return symbolKind;
    }

    @Nullable
    private static WorkspaceSymbol workspaceSymbol(@NotNull ProjectSymbol.Symbol symbol) {
        Location nameLoc = LspRange.toLoc(symbol.nameLocation());
        if (nameLoc == null) {
            return null;
        }
        return new WorkspaceSymbol(symbol.name(), SymbolMaker.kindOf(symbol.kind()), nameLoc);
    }

    @NotNull
    private static DocumentSymbol documentSymbol(@NotNull ProjectSymbol.Symbol symbol) {
        Range nameLoc = LspRange.toRange(symbol.nameLocation());
        Range entireLoc = LspRange.toRange(symbol.entireLocation());
        return new DocumentSymbol(symbol.name(), symbol.description().commonRender(), SymbolMaker.kindOf(symbol.kind()), false, entireLoc, nameLoc, symbol.children().map(SymbolMaker::documentSymbol).asJava());
    }
}

