/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.library;

import java.nio.file.Path;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.prelude.GeneratedVersion;
import org.aya.util.FileUtil;
import org.aya.util.error.SourceFileLocator;
import org.jetbrains.annotations.NotNull;

public record WsLibrary(@NotNull SourceFileLocator locator, @NotNull MutableList<LibrarySource> sources, @NotNull LibraryConfig mockConfig, @NotNull Path workspace) implements LibraryOwner
{
    @NotNull
    public static WsLibrary mock(@NotNull Path ayaSource) {
        Path canonicalPath = FileUtil.canonicalize((Path)ayaSource);
        Path parent = canonicalPath.getParent();
        LibraryConfig mockConfig = WsLibrary.mockConfig(parent);
        SourceFileLocator.Module locator = new SourceFileLocator.Module((SeqLike)SeqView.of((Object)parent));
        WsLibrary owner = new WsLibrary((SourceFileLocator)locator, (MutableList<LibrarySource>)MutableList.create(), mockConfig, parent);
        owner.sources.append((Object)LibrarySource.create((LibraryOwner)owner, (Path)canonicalPath));
        return owner;
    }

    @NotNull
    private static LibraryConfig mockConfig(@NotNull Path folder) {
        return new LibraryConfig(GeneratedVersion.VERSION, folder.getFileName().toString(), "1.0.0", folder, folder, folder.resolve("build"), folder.resolve("build"), new LibraryConfig.LibraryLiterateConfig(null, "/", folder.resolve("build")), ImmutableSeq.empty());
    }

    @NotNull
    public SeqView<Path> modulePath() {
        return SeqView.of((Object)this.workspace);
    }

    @NotNull
    public SeqView<LibrarySource> librarySources() {
        return this.sources.view();
    }

    @NotNull
    public SeqView<LibraryOwner> libraryDeps() {
        return SeqView.empty();
    }

    @NotNull
    public LibraryConfig underlyingLibrary() {
        return this.mockConfig;
    }

    public void addModulePath(@NotNull Path newPath) {
    }
}

