/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.models;

import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import kala.collection.Seq;
import kala.control.Option;
import kala.value.TransientVar;
import org.aya.cli.literate.HighlightInfo;
import org.aya.lsp.utils.LspRange;
import org.aya.util.error.SourcePos;
import org.javacs.lsp.Range;
import org.jetbrains.annotations.NotNull;

public record HighlightResult(@NotNull URI uri, @NotNull List<Symbol> symbols) {
    public HighlightResult(@NotNull URI uri, @NotNull Seq<Symbol> symbols) {
        this(uri, symbols.asJava());
    }

    public record Symbol(@NotNull Range range, @NotNull Kind kind, @NotNull TransientVar<SourcePos> sourcePos) {
        @NotNull
        public static Option<Symbol> from(@NotNull HighlightInfo info) {
            return Symbol.kindOf(info).map(k -> {
                SourcePos pos = info.sourcePos();
                return new Symbol(LspRange.toRange(pos), (Kind)((Object)k), (TransientVar<SourcePos>)new TransientVar((Object)pos));
            });
        }

        @NotNull
        private static Option<Kind> kindOf(@NotNull HighlightInfo symbol) {
            HighlightInfo highlightInfo = symbol;
            Objects.requireNonNull(highlightInfo);
            HighlightInfo highlightInfo2 = highlightInfo;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HighlightInfo.Def.class, HighlightInfo.Ref.class, HighlightInfo.Lit.class, HighlightInfo.Err.class}, (Object)highlightInfo2, n)) {
                default -> throw new RuntimeException(null, null);
                case 0 -> {
                    HighlightInfo.Def def = (HighlightInfo.Def)highlightInfo2;
                    switch (def.kind()) {
                        default: {
                            throw new RuntimeException(null, null);
                        }
                        case LocalVar: {
                            yield Option.none();
                        }
                        case Generalized: {
                            yield Option.some((Object)((Object)Kind.GeneralizeDef));
                        }
                        case Module: {
                            yield Option.some((Object)((Object)Kind.ModuleDef));
                        }
                        case Fn: {
                            yield Option.some((Object)((Object)Kind.FnDef));
                        }
                        case Data: {
                            yield Option.some((Object)((Object)Kind.DataDef));
                        }
                        case Clazz: {
                            yield Option.some((Object)((Object)Kind.StructDef));
                        }
                        case Con: {
                            yield Option.some((Object)((Object)Kind.ConDef));
                        }
                        case Member: {
                            yield Option.some((Object)((Object)Kind.FieldDef));
                        }
                        case Prim: {
                            yield Option.some((Object)((Object)Kind.PrimDef));
                        }
                        case Unknown: 
                    }
                    yield Option.none();
                }
                case 1 -> {
                    HighlightInfo.Ref ref = (HighlightInfo.Ref)highlightInfo2;
                    switch (ref.kind()) {
                        default: {
                            throw new RuntimeException(null, null);
                        }
                        case LocalVar: {
                            yield Option.none();
                        }
                        case Generalized: {
                            yield Option.some((Object)((Object)Kind.GeneralizeRef));
                        }
                        case Module: {
                            yield Option.some((Object)((Object)Kind.ModuleRef));
                        }
                        case Fn: {
                            yield Option.some((Object)((Object)Kind.FnRef));
                        }
                        case Data: {
                            yield Option.some((Object)((Object)Kind.DataRef));
                        }
                        case Clazz: {
                            yield Option.some((Object)((Object)Kind.StructRef));
                        }
                        case Con: {
                            yield Option.some((Object)((Object)Kind.ConRef));
                        }
                        case Member: {
                            yield Option.some((Object)((Object)Kind.FieldRef));
                        }
                        case Prim: {
                            yield Option.some((Object)((Object)Kind.PrimRef));
                        }
                        case Unknown: 
                    }
                    yield Option.none();
                }
                case 2 -> Option.none();
                case 3 -> Option.none();
            };
        }
    }

    public static enum Kind {
        ModuleDef,
        FnDef,
        DataDef,
        StructDef,
        ConDef,
        FieldDef,
        PrimDef,
        GeneralizeDef,
        FnRef,
        DataRef,
        StructRef,
        ConRef,
        FieldRef,
        PrimRef,
        ModuleRef,
        GeneralizeRef;

    }
}

