/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.models;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import org.aya.cli.render.Color;
import org.aya.cli.render.RenderOptions;
import org.aya.lsp.utils.Log;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.aya.pretty.style.AyaStyleKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerRenderOptions {
    @Nullable
    public String colorScheme;
    @Nullable
    public Map<String, String> override;
    @Nullable
    public RenderOptions.OutputTarget target = RenderOptions.OutputTarget.Plain;

    public ServerRenderOptions() {
    }

    public ServerRenderOptions(@Nullable String colorScheme, @Nullable Map<String, String> override, @Nullable RenderOptions.OutputTarget target) {
        this.colorScheme = colorScheme;
        this.override = override;
        this.target = target;
    }

    @NotNull
    public RenderOptions buildRenderOptions() {
        String colorSchemeName = this.colorScheme;
        if (colorSchemeName != null) {
            colorSchemeName = colorSchemeName.toLowerCase();
        }
        String string = colorSchemeName;
        int n = 0;
        AyaColorScheme colorScheme = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"emacs", "intellij"}, (Object)string, n)) {
            case 0 -> AyaColorScheme.EMACS;
            case 1 -> AyaColorScheme.INTELLIJ;
            default -> {
                String cause = colorSchemeName == null ? "unspecified" : "invalid";
                Log.w("Property 'colorScheme' is %s, 'Emacs' will be used.", cause);
                yield AyaColorScheme.EMACS;
            }
        };
        if (this.override != null) {
            this.override.forEach((name, colorCode) -> {
                try {
                    AyaStyleKey key = AyaStyleKey.valueOf((String)name);
                    Integer value = (Integer)Color.Adapter.parseColor((String)colorCode).getOrThrow();
                    colorScheme.definedColors().put((Object)key.key(), (Object)value);
                }
                catch (NumberFormatException e) {
                    Log.w("Color '%s' is invalid, because: %s", colorCode, e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    Log.w("Key '%s' is not a valid style key.", name);
                }
            });
        }
        RenderOptions opts = new RenderOptions();
        opts.colorScheme = RenderOptions.ColorSchemeName.Custom;
        opts.styleFamily = RenderOptions.StyleFamilyName.Default;
        opts.doBadThing((ColorScheme)colorScheme, (StyleFamily)AyaStyleFamily.DEFAULT);
        return opts;
    }

    @NotNull
    public RenderOptions.OutputTarget target() {
        return this.target == null ? RenderOptions.OutputTarget.Plain : this.target;
    }
}

