/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.server;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import org.aya.lsp.utils.Log;
import org.aya.lsp.utils.LspRange;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.javacs.lsp.Diagnostic;
import org.javacs.lsp.LanguageClient;
import org.javacs.lsp.PublishDiagnosticsParams;
import org.jetbrains.annotations.NotNull;

public interface AyaLanguageClient
extends LanguageClient {
    default public void publishAyaProblems(@NotNull ImmutableMap<Path, ImmutableSeq<Problem>> problems, @NotNull PrettierOptions options) {
        problems.forEach((filePath, value) -> {
            Log.i("Found %d issues in %s", value.size(), filePath);
            PublishDiagnosticsParams param = new PublishDiagnosticsParams(filePath.toUri(), ((Map)value.collect(Collectors.groupingBy(Problem::sourcePos, ImmutableSeq.factory()))).entrySet().stream().map(kv -> AyaLanguageClient.toDiagnostic((SourcePos)kv.getKey(), (Seq<Problem>)((Seq)kv.getValue()), options)).toList());
            this.publishDiagnostics(param);
        });
    }

    default public void clearAyaProblems(@NotNull ImmutableSeq<Path> files) {
        files.forEach(f -> this.publishDiagnostics(new PublishDiagnosticsParams(f.toUri(), Collections.emptyList())));
    }

    @NotNull
    private static Diagnostic toDiagnostic(@NotNull SourcePos sourcePos, @NotNull Seq<Problem> problems, @NotNull PrettierOptions options) {
        StringBuilder msgBuilder = new StringBuilder();
        int severity = 4;
        for (Problem p : problems) {
            msgBuilder.append(p.brief(options).debugRender()).append(System.lineSeparator());
            int ps = AyaLanguageClient.severityOf(p);
            if (ps >= severity) continue;
            severity = ps;
        }
        return new Diagnostic(LspRange.toRange(sourcePos), severity, "", "Aya", msgBuilder.toString(), Collections.emptyList());
    }

    private static int severityOf(@NotNull Problem problem) {
        return switch (problem.level()) {
            default -> throw new RuntimeException(null, null);
            case Problem.Severity.WARN -> 2;
            case Problem.Severity.ERROR -> 1;
            case Problem.Severity.INFO -> 3;
            case Problem.Severity.GOAL -> 4;
        };
    }
}

