/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.cli.library.LibraryCompiler;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.incremental.DelegateCompilerAdvisor;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.json.LibraryConfigData;
import org.aya.cli.library.source.DiskLibraryOwner;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.library.source.MutableLibraryOwner;
import org.aya.cli.render.RenderOptions;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.utils.InlineHintProblem;
import org.aya.core.def.PrimDef;
import org.aya.core.term.Term;
import org.aya.generic.util.AyaFiles;
import org.aya.ide.LspPrimFactory;
import org.aya.ide.action.ComputeSignature;
import org.aya.ide.action.ComputeTerm;
import org.aya.ide.action.FindReferences;
import org.aya.ide.action.Folding;
import org.aya.ide.action.GotoDefinition;
import org.aya.ide.action.InlayHints;
import org.aya.ide.action.Rename;
import org.aya.ide.util.XY;
import org.aya.ide.util.XYXY;
import org.aya.lsp.actions.LensMaker;
import org.aya.lsp.actions.SemanticHighlight;
import org.aya.lsp.actions.SymbolMaker;
import org.aya.lsp.library.WsLibrary;
import org.aya.lsp.models.ComputeTermResult;
import org.aya.lsp.models.HighlightResult;
import org.aya.lsp.models.ServerOptions;
import org.aya.lsp.models.ServerRenderOptions;
import org.aya.lsp.server.AyaLanguageClient;
import org.aya.lsp.utils.Log;
import org.aya.lsp.utils.LspRange;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.pretty.doc.Doc;
import org.aya.util.FileUtil;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.BufferReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.javacs.lsp.CodeAction;
import org.javacs.lsp.CodeActionParams;
import org.javacs.lsp.CodeLens;
import org.javacs.lsp.CodeLensParams;
import org.javacs.lsp.CompletionItem;
import org.javacs.lsp.CompletionList;
import org.javacs.lsp.DidChangeWatchedFilesParams;
import org.javacs.lsp.DocumentFormattingParams;
import org.javacs.lsp.DocumentHighlight;
import org.javacs.lsp.DocumentLink;
import org.javacs.lsp.DocumentLinkParams;
import org.javacs.lsp.DocumentSymbolParams;
import org.javacs.lsp.FoldingRange;
import org.javacs.lsp.FoldingRangeParams;
import org.javacs.lsp.GenericDocumentSymbol;
import org.javacs.lsp.GenericLocation;
import org.javacs.lsp.GenericWorkspaceSymbol;
import org.javacs.lsp.Hover;
import org.javacs.lsp.InitializeParams;
import org.javacs.lsp.InitializeResult;
import org.javacs.lsp.InlayHint;
import org.javacs.lsp.InlayHintParams;
import org.javacs.lsp.LanguageServer;
import org.javacs.lsp.Location;
import org.javacs.lsp.LocationLink;
import org.javacs.lsp.LspRequest;
import org.javacs.lsp.MarkedString;
import org.javacs.lsp.Range;
import org.javacs.lsp.ReferenceParams;
import org.javacs.lsp.RenameParams;
import org.javacs.lsp.RenameResponse;
import org.javacs.lsp.ServerCapabilities;
import org.javacs.lsp.ShowMessageParams;
import org.javacs.lsp.SignatureHelp;
import org.javacs.lsp.TextDocumentPositionParams;
import org.javacs.lsp.TextEdit;
import org.javacs.lsp.WillSaveTextDocumentParams;
import org.javacs.lsp.WorkspaceEdit;
import org.javacs.lsp.WorkspaceSymbolParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AyaLanguageServer
implements LanguageServer {
    @NotNull
    private static final CompilerFlags FLAGS = new CompilerFlags(CompilerFlags.Message.EMOJI, false, false, null, (SeqLike)SeqView.empty(), null);
    private final BufferReporter reporter = new BufferReporter();
    @NotNull
    private final MutableList<LibraryOwner> libraries = MutableList.create();
    @NotNull
    protected final MutableMap<LibraryConfig, LspPrimFactory> primFactories = MutableMap.create();
    @NotNull
    private final CompilerAdvisor advisor;
    @NotNull
    private final AyaLanguageClient client;
    @NotNull
    private final PrettierOptions options = AyaPrettierOptions.pretty();
    @NotNull
    private ServerOptions serverOptions;
    @NotNull
    private RenderOptions renderOptions;

    public AyaLanguageServer(@NotNull CompilerAdvisor advisor, @NotNull AyaLanguageClient client) {
        this.advisor = new CallbackAdvisor(this, advisor);
        this.client = client;
        Log.init(this.client);
    }

    @NotNull
    public SeqView<LibraryOwner> libraries() {
        return this.libraries.view();
    }

    public void registerLibrary(@NotNull Path path) {
        Log.i("Adding library path %s", path);
        if (!this.tryAyaLibrary(path)) {
            this.mockLibraries(path);
        }
    }

    private boolean tryAyaLibrary(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        Path ayaJson = path.resolve("aya.json");
        if (!Files.exists(ayaJson, new LinkOption[0])) {
            return this.tryAyaLibrary(path.getParent());
        }
        try {
            LibraryConfig config = LibraryConfigData.fromLibraryRoot((Path)path);
            DiskLibraryOwner owner = DiskLibraryOwner.from((LibraryConfig)config);
            this.libraries.append((Object)owner);
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            Log.e("Cannot load library. Stack trace:\n%s", s.toString());
        }
        catch (LibraryConfigData.BadConfig bad) {
            this.client.showMessage(new ShowMessageParams(1, "Cannot load malformed library: " + bad.getMessage()));
        }
        return true;
    }

    private void mockLibraries(@NotNull Path path) {
        this.libraries.appendAll((Iterable)AyaFiles.collectAyaSourceFiles((Path)path, (int)1).map(WsLibrary::mock));
    }

    public void initialized() {
    }

    public List<TextEdit> willSaveWaitUntilTextDocument(WillSaveTextDocumentParams params) {
        throw new UnsupportedOperationException();
    }

    public InitializeResult initialize(InitializeParams params) {
        ServerCapabilities cap = new ServerCapabilities();
        cap.textDocumentSync = 0;
        ServerCapabilities.WorkspaceFoldersOptions workOps = new ServerCapabilities.WorkspaceFoldersOptions(true, true);
        ServerCapabilities.WorkspaceServerCapabilities workCap = new ServerCapabilities.WorkspaceServerCapabilities(workOps);
        cap.completionProvider = new ServerCapabilities.CompletionOptions(true, Collections.singletonList("QWERTYUIOPASDFGHJKLZXCVBNM.qwertyuiopasdfghjklzxcvbnm+-*/_[]:"));
        cap.workspace = workCap;
        cap.definitionProvider = true;
        cap.referencesProvider = true;
        cap.hoverProvider = true;
        cap.renameProvider = new ServerCapabilities.RenameOptions(true);
        cap.documentHighlightProvider = true;
        cap.codeLensProvider = new ServerCapabilities.CodeLensOptions(true);
        cap.inlayHintProvider = true;
        cap.documentSymbolProvider = true;
        cap.workspaceSymbolProvider = true;
        cap.foldingRangeProvider = true;
        this.initializeOptions((ServerOptions)new Gson().fromJson(params.initializationOptions, ServerOptions.class));
        List folders = params.workspaceFolders;
        if (folders != null) {
            folders.forEach(f -> this.registerLibrary(Path.of(f.uri)));
        }
        return new InitializeResult(cap);
    }

    private void initializeOptions(@Nullable ServerOptions options) {
        if (options == null) {
            options = new ServerOptions();
        }
        if (options.renderOptions == null) {
            options.renderOptions = new ServerRenderOptions();
        }
        this.serverOptions = options;
        this.renderOptions = options.renderOptions.buildRenderOptions();
    }

    @Nullable
    private LibraryOwner findOwner(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        Path ayaJson = path.resolve("aya.json");
        if (!Files.exists(ayaJson, new LinkOption[0])) {
            return this.findOwner(path.getParent());
        }
        MutableSet book = MutableSet.create();
        for (LibraryOwner lib : this.libraries) {
            LibraryOwner found = this.findOwner((MutableSet<LibraryConfig>)book, lib, path);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    private LibraryOwner findOwner(@NotNull MutableSet<LibraryConfig> book, @NotNull LibraryOwner owner, @NotNull Path libraryRoot) {
        if (book.contains((Object)owner.underlyingLibrary())) {
            return null;
        }
        book.add((Object)owner.underlyingLibrary());
        if (owner.underlyingLibrary().libraryRoot().equals(libraryRoot)) {
            return owner;
        }
        for (LibraryOwner dep : owner.libraryDeps()) {
            LibraryOwner found = this.findOwner(book, dep, libraryRoot);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    private LibrarySource find(@NotNull LibraryOwner owner, Path moduleFile) {
        Option found = owner.librarySources().find(src -> src.underlyingFile().equals(moduleFile));
        if (found.isDefined()) {
            return (LibrarySource)found.get();
        }
        for (LibraryOwner dep : owner.libraryDeps()) {
            LibrarySource foundDep = this.find(dep, moduleFile);
            if (foundDep == null) continue;
            return foundDep;
        }
        return null;
    }

    @Nullable
    public LibrarySource find(@NotNull Path moduleFile) {
        for (LibraryOwner lib : this.libraries) {
            LibrarySource found = this.find(lib, moduleFile);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public LibrarySource find(@NotNull URI uri) {
        return this.find(this.toPath(uri));
    }

    @NotNull
    private Path toPath(@NotNull URI uri) {
        return FileUtil.canonicalize((Path)Path.of(uri));
    }

    @NotNull
    public ImmutableSeq<HighlightResult> reload() {
        return this.libraries().flatMap(this::loadLibrary).toImmutableSeq();
    }

    @NotNull
    public ImmutableSeq<HighlightResult> loadLibrary(@NotNull LibraryOwner owner) {
        Log.i("Loading library %s", owner.underlyingLibrary().name());
        this.reporter.clear();
        LspPrimFactory primFactory = this.primFactory(owner);
        try {
            LibraryCompiler.newCompiler((PrimDef.Factory)primFactory, (Reporter)this.reporter, (CompilerFlags)FLAGS, (CompilerAdvisor)this.advisor, (LibraryOwner)owner).start();
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            Log.e("IOException occurred when running the compiler. Stack trace:\n%s", s.toString());
        }
        this.publishProblems(this.reporter, this.options);
        return SemanticHighlight.invoke(owner);
    }

    public void publishProblems(@NotNull BufferReporter reporter, @NotNull PrettierOptions options) {
        Map diags = reporter.problems().stream().filter(p -> p.sourcePos().belongsToSomeFile()).peek(p -> Log.d("%s", p.describe(options).debugRender())).flatMap(p -> Stream.concat(Stream.of(p), p.inlineHints(options).stream().map(t -> new InlineHintProblem(p, t)))).flatMap(p -> p.sourcePos().file().underlying().stream().map(uri -> Tuple.of((Object)uri, (Object)p))).collect(Collectors.groupingBy(Tuple2::component1, Collectors.mapping(Tuple2::component2, ImmutableSeq.factory())));
        ImmutableMap from = ImmutableMap.from(diags);
        this.client.publishAyaProblems((ImmutableMap<Path, ImmutableSeq<Problem>>)from, options);
    }

    private void clearProblems(@NotNull ImmutableSeq<ImmutableSeq<LibrarySource>> affected) {
        ImmutableSeq files = affected.flatMap(i -> i.map(LibrarySource::underlyingFile));
        this.client.clearAyaProblems((ImmutableSeq<Path>)files);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.changes.forEach(change -> {
            block0 : switch (change.type) {
                case 1: {
                    Path newSrc = this.toPath(change.uri);
                    LibraryOwner selector0$temp = this.findOwner(newSrc);
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MutableLibraryOwner.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            MutableLibraryOwner ownerMut = (MutableLibraryOwner)selector0$temp;
                            Log.d("Created new file: %s, added to owner: %s", newSrc, ownerMut.underlyingLibrary().name());
                            ownerMut.addLibrarySource(newSrc);
                            break block0;
                        }
                        case -1: {
                            WsLibrary mock = WsLibrary.mock(newSrc);
                            Log.d("Created new file: %s, mocked a library %s for it", newSrc, mock.mockConfig().name());
                            this.libraries.append((Object)mock);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    LibrarySource src = this.find(change.uri);
                    if (src == null) {
                        return;
                    }
                    Log.d("Deleted file: %s, removed from owner: %s", src.underlyingFile(), src.owner().underlyingLibrary().name());
                    LibraryOwner libraryOwner = src.owner();
                    Objects.requireNonNull(libraryOwner);
                    LibraryOwner selector0$temp = libraryOwner;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MutableLibraryOwner.class, WsLibrary.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            MutableLibraryOwner owner = (MutableLibraryOwner)selector0$temp;
                            owner.removeLibrarySource(src);
                            break block0;
                        }
                        case 1: {
                            WsLibrary owner = (WsLibrary)selector0$temp;
                            this.libraries.removeIf(o -> o == owner);
                            break block0;
                        }
                    }
                }
            }
        });
    }

    public Optional<CompletionList> completion(TextDocumentPositionParams position) {
        return Optional.empty();
    }

    public CompletionItem resolveCompletionItem(CompletionItem params) {
        throw new UnsupportedOperationException();
    }

    public Optional<List<? extends GenericLocation>> gotoDefinition(TextDocumentPositionParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Optional.empty();
        }
        return Optional.of((List)GotoDefinition.findDefs((LibrarySource)source, (SeqView)this.libraries.view(), (XY)LspRange.pos(params.position)).mapNotNull(pos -> {
            SourcePos to;
            SourcePos from = pos.sourcePos();
            LocationLink res = LspRange.toLoc(from, to = (SourcePos)pos.data());
            if (res != null) {
                Log.d("Resolved: %s in %s", to, res.targetUri);
            }
            return res;
        }).collect(Collectors.toList()));
    }

    public Optional<Hover> hover(TextDocumentPositionParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Optional.empty();
        }
        Doc doc = ComputeSignature.invokeHover((PrettierOptions)this.options, (LibrarySource)source, (XY)LspRange.pos(params.position));
        if (doc.isEmpty()) {
            return Optional.empty();
        }
        MarkedString marked = new MarkedString("plaintext", this.render(doc));
        return Optional.of(new Hover(List.of(marked)));
    }

    public Optional<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public Optional<List<Location>> findReferences(ReferenceParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Optional.empty();
        }
        return Optional.of((List)FindReferences.findRefs((LibrarySource)source, (SeqView)this.libraries.view(), (XY)LspRange.pos(params.position)).map(LspRange::toLoc).collect(Collectors.toList()));
    }

    public WorkspaceEdit rename(RenameParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return null;
        }
        Map renames = (Map)Rename.rename((LibrarySource)source, (String)params.newName, (SeqView)this.libraries.view(), (XY)LspRange.pos(params.position)).view().flatMap(t -> t.sourcePos().file().underlying().map(f -> Tuple.of((Object)f.toUri(), (Object)t))).collect(Collectors.groupingBy(Tuple2::component1, Collectors.mapping(t -> new TextEdit(LspRange.toRange(((Rename.RenameEdit)t.component2()).sourcePos()), ((Rename.RenameEdit)t.component2()).newText()), Collectors.toList())));
        return new WorkspaceEdit(renames);
    }

    public List<TextEdit> formatting(DocumentFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public Optional<RenameResponse> prepareRename(TextDocumentPositionParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Optional.empty();
        }
        Option begin = Rename.prepare((LibrarySource)source, (XY)LspRange.pos(params.position));
        return begin.map(wp -> new RenameResponse(LspRange.toRange(wp.sourcePos()), (String)wp.data())).asJava();
    }

    public List<DocumentHighlight> documentHighlight(TextDocumentPositionParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Collections.emptyList();
        }
        Option currentFile = Option.ofNullable((Object)source.underlyingFile());
        return FindReferences.findOccurrences((LibrarySource)source, (SeqView)SeqView.of((Object)source.owner()), (XY)LspRange.pos(params.position)).filter(pos -> pos.file().underlying().equals((Object)currentFile)).map(pos -> new DocumentHighlight(LspRange.toRange(pos), 2)).stream().toList();
    }

    public List<CodeLens> codeLens(CodeLensParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Collections.emptyList();
        }
        return LensMaker.invoke(source, (SeqView<LibraryOwner>)this.libraries.view());
    }

    public CodeLens resolveCodeLens(CodeLens codeLens) {
        return LensMaker.resolve(codeLens);
    }

    public List<? extends GenericDocumentSymbol> documentSymbol(DocumentSymbolParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Collections.emptyList();
        }
        return SymbolMaker.documentSymbols(this.options, source).asJava();
    }

    public List<? extends GenericWorkspaceSymbol> workspaceSymbols(WorkspaceSymbolParams params) {
        return SymbolMaker.workspaceSymbols(this.options, (SeqView<LibraryOwner>)this.libraries.view()).asJava();
    }

    public List<CodeAction> codeAction(CodeActionParams params) {
        throw new UnsupportedOperationException();
    }

    public List<FoldingRange> foldingRange(FoldingRangeParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Collections.emptyList();
        }
        return Folding.invoke((LibrarySource)source).view().filter(f -> f.entireSourcePos().linesOfCode() >= 3).map(f -> {
            Range range = LspRange.toRange(f.entireSourcePos());
            return new FoldingRange(range.start.line, range.start.character, range.end.line, range.end.character, "region");
        }).toImmutableSeq().asJava();
    }

    public List<DocumentLink> documentLink(DocumentLinkParams params) {
        throw new UnsupportedOperationException();
    }

    public List<InlayHint> inlayHint(InlayHintParams params) {
        LibrarySource source = this.find(params.textDocument.uri);
        if (source == null) {
            return Collections.emptyList();
        }
        return InlayHints.invoke((PrettierOptions)this.options, (LibrarySource)source, (XYXY)LspRange.range(params.range)).map(h -> new InlayHint(LspRange.toRange((SourcePos)h.sourcePos()).end, this.render(h.doc()))).asJava();
    }

    @LspRequest(value="aya/load")
    public List<HighlightResult> load(Object uri) {
        return this.reload().asJava();
    }

    @LspRequest(value="aya/computeType")
    @NotNull
    public ComputeTermResult computeType(ComputeTermResult.Params input) {
        return this.computeTerm(input, ComputeTerm.Kind.type());
    }

    @LspRequest(value="aya/computeNF")
    @NotNull
    public ComputeTermResult computeNF(ComputeTermResult.Params input) {
        return this.computeTerm(input, ComputeTerm.Kind.nf());
    }

    @LspRequest(value="aya/updateServerOptions")
    public void updateServerOptions(@NotNull ServerOptions options) {
        this.initializeOptions(options);
    }

    public ComputeTermResult computeTerm(@NotNull ComputeTermResult.Params params, ComputeTerm.Kind type) {
        LibrarySource source = this.find(params.uri);
        if (source == null) {
            return ComputeTermResult.bad(params);
        }
        ImmutableSeq program = (ImmutableSeq)source.program().get();
        if (program == null) {
            return ComputeTermResult.bad(params);
        }
        ComputeTerm computer = new ComputeTerm(source, type, (PrimDef.Factory)this.primFactory(source.owner()), LspRange.pos(params.position));
        program.forEach((Consumer)computer);
        return computer.result == null ? ComputeTermResult.bad(params) : ComputeTermResult.good(params, (WithPos<Term>)computer.result);
    }

    @NotNull
    private String render(@NotNull Doc doc) {
        RenderOptions.OutputTarget target = this.serverOptions.renderOptions.target();
        RenderOptions renderOptions = this.renderOptions;
        return renderOptions.render(target, doc, (RenderOptions.BackendSetup)new RenderOptions.DefaultSetup(false, false, false, true, -1, true));
    }

    @NotNull
    private LspPrimFactory primFactory(@NotNull LibraryOwner owner) {
        return (LspPrimFactory)this.primFactories.getOrPut((Object)owner.underlyingLibrary(), LspPrimFactory::new);
    }

    private static final class CallbackAdvisor
    extends DelegateCompilerAdvisor {
        @NotNull
        private final AyaLanguageServer service;

        public CallbackAdvisor(@NotNull AyaLanguageServer service, @NotNull CompilerAdvisor delegate) {
            super(delegate);
            this.service = service;
        }

        public void notifyIncrementalJob(@NotNull ImmutableSeq<LibrarySource> modified, @NotNull ImmutableSeq<ImmutableSeq<LibrarySource>> affected) {
            super.notifyIncrementalJob(modified, affected);
            this.service.clearProblems(affected);
        }
    }
}

