/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.aya.lsp.server.AyaLanguageClient;
import org.aya.util.error.InternalException;
import org.intellij.lang.annotations.PrintFormat;
import org.javacs.lsp.ShowMessageParams;
import org.javacs.lsp.ShowMessageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Log {
    @NotNull
    private static final Path LOG_FILE = Paths.get("aya-last-startup.log", new String[0]).toAbsolutePath();
    @Nullable
    private static volatile AyaLanguageClient CLIENT = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void init(@NotNull AyaLanguageClient client) {
        if (CLIENT == null) {
            Class<Log> clazz = Log.class;
            // MONITORENTER : org.aya.lsp.utils.Log.class
            if (CLIENT != null) throw new InternalException("double initialization occurred");
            CLIENT = client;
            // MONITOREXIT : clazz
        }
        Log.i("Log file: %s", LOG_FILE);
    }

    public static void i(@NotNull @PrintFormat String fmt, Object ... args) {
        Log.log(ShowMessageType.Info, fmt, args);
    }

    public static void e(@NotNull @PrintFormat String fmt, Object ... args) {
        Log.log(ShowMessageType.Error, fmt, args);
    }

    public static void w(@NotNull @PrintFormat String fmt, Object ... args) {
        Log.log(ShowMessageType.Warning, fmt, args);
    }

    public static void d(@NotNull @PrintFormat String fmt, Object ... args) {
        Log.log(ShowMessageType.Log, fmt, args);
    }

    public static void log(@NotNull ShowMessageType type, @NotNull String fmt, Object ... args) {
        String format = fmt.formatted(args);
        Log.logConsole(type, format);
        AyaLanguageClient client = CLIENT;
        if (client != null) {
            client.logMessage(new ShowMessageParams(type.value, format));
        }
    }

    public static void logConsole(@NotNull ShowMessageType type, @NotNull String content) {
        try {
            String format = String.format("[%s]: %s%n", type, content);
            System.err.print(format);
            Files.writeString(LOG_FILE, (CharSequence)format, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

