/*
 * Decompiled with CFR 0.152.
 */
package org.aya.lsp.utils;

import java.net.URI;
import java.nio.file.Path;
import kala.control.Option;
import org.aya.ide.util.XY;
import org.aya.ide.util.XYXY;
import org.aya.util.error.SourcePos;
import org.javacs.lsp.Location;
import org.javacs.lsp.LocationLink;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LspRange {
    @NotNull
    public static final Range NONE = new Range();

    @NotNull
    public static XY pos(@NotNull Position position) {
        return new XY(position.line + 1, position.character - 1);
    }

    @NotNull
    public static XYXY range(@NotNull Range range) {
        return new XYXY(LspRange.pos(range.start), LspRange.pos(range.end));
    }

    @NotNull
    public static Range toRange(@NotNull SourcePos sourcePos) {
        if (sourcePos == SourcePos.NONE) {
            return NONE;
        }
        return new Range(new Position(sourcePos.startLine() - 1, sourcePos.startColumn()), new Position(sourcePos.endLine() - 1, sourcePos.endColumn() + 1));
    }

    @NotNull
    public static Option<URI> toFileUri(@NotNull SourcePos sourcePos) {
        return sourcePos.file().underlying().map(Path::toUri);
    }

    @Nullable
    public static LocationLink toLoc(@NotNull SourcePos from, @NotNull SourcePos to) {
        Option<URI> uri = LspRange.toFileUri(to);
        if (uri.isEmpty()) {
            return null;
        }
        Range fromRange = LspRange.toRange(from);
        Range toRange = LspRange.toRange(to);
        return new LocationLink(fromRange, (URI)uri.get(), toRange, toRange);
    }

    @Nullable
    public static Location toLoc(@NotNull SourcePos to) {
        Option<URI> uri = LspRange.toFileUri(to);
        if (uri.isEmpty()) {
            return null;
        }
        Range toRange = LspRange.toRange(to);
        return new Location((URI)uri.get(), toRange);
    }
}

