/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.html;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.doc.Style;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Html5Stylist
extends ClosingStylist {
    @NotNull
    public static final Html5Stylist DEFAULT = new Html5Stylist(AyaColorScheme.EMACS, AyaStyleFamily.DEFAULT);

    public Html5Stylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
        super(colorScheme, styleFamily);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<i>", "</i>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<b>", "</b>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<span style=\"%s\">".formatted(Html5Stylist.styleToCss(line)), "</span>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean background) {
        return new ClosingStylist.StyleToken("<span style=\"%s:%s;\">".formatted(background ? "background-color" : "color", Html5Stylist.cssColor(rgb)), "</span>", false);
    }

    @NotNull
    public static ImmutableSeq<String> styleKeyToCss(@NotNull String className) {
        return ImmutableSeq.from((Object[])className.split("::", -1)).map(Html5Stylist::normalizeCssId);
    }

    @Nullable
    public static String styleToCss(@NotNull Style style) {
        Style style2 = style;
        Objects.requireNonNull(style2);
        Style style3 = style2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.Attr.class, Style.LineThrough.class, Style.ColorHex.class, Style.ColorName.class}, (Object)style3, n)) {
            case 0 -> {
                Style.Attr attr = (Style.Attr)style3;
                switch (attr) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Italic: {
                        yield "font-style: italic;";
                    }
                    case Bold: 
                }
                yield "font-weight: bold;";
            }
            case 1 -> {
                Object var7_4 = Html5Stylist.$proxy$position((Style.LineThrough)style3);
                Style.LineThrough.Position pos = var7_4;
                var7_4 = Html5Stylist.$proxy$shape((Style.LineThrough)style3);
                Enum shape = var7_4;
                Object color = var7_4 = Html5Stylist.$proxy$color((Style.LineThrough)style3);
                String v2 = switch (pos) {
                    default -> throw new IncompatibleClassChangeError();
                    case Style.LineThrough.Position.Overline -> "text-decoration-line: overline;";
                    case Style.LineThrough.Position.Underline -> "text-decoration-line: underline; text-underline-position: under;";
                    case Style.LineThrough.Position.Strike -> "text-decoration-line: line-through;";
                };
                String decoLine = v2;
                String v3 = switch (1.$SwitchMap$org$aya$pretty$doc$Style$LineThrough$Shape[shape.ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> "text-decoration-style: solid;";
                    case 2 -> "text-decoration-style: wavy;";
                };
                String decoStyle = v3;
                Object var10_11 = color;
                int var11_13 = 0;
                String v4 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.ColorHex.class, Style.ColorName.class}, (Object)var10_11, var11_13)) {
                    default -> throw new RuntimeException(null, null);
                    case 0 -> {
                        int var14_16 = Html5Stylist.$proxy$color((Style.ColorHex)var10_11);
                        int rgb = var14_16;
                        boolean var14_17 = Html5Stylist.$proxy$background((Style.ColorHex)var10_11);
                        boolean $ = var14_17;
                        yield Html5Stylist.cssColor(rgb);
                    }
                    case 1 -> {
                        String var16_21;
                        String var14_18 = var16_21 = Html5Stylist.$proxy$colorName((Style.ColorName)var10_11);
                        boolean var16_22 = Html5Stylist.$proxy$background((Style.ColorName)var10_11);
                        boolean $ = var16_22;
                        yield "var(%s)".formatted(Html5Stylist.cssVar(var14_18));
                    }
                    case -1 -> null;
                };
                String var9_24 = v4;
                String decoColor = var9_24 != null ? "text-decoration-color: %s;".formatted(var9_24) : "";
                yield decoLine + decoStyle + decoColor;
            }
            case 2 -> {
                int var9_25 = Html5Stylist.$proxy$color((Style.ColorHex)style3);
                int rgb = var9_25;
                boolean var9_26 = Html5Stylist.$proxy$background((Style.ColorHex)style3);
                boolean background = var9_26;
                if (background) {
                    yield "background-color: %s".formatted(Html5Stylist.cssColor(rgb));
                }
                yield "color: %s;".formatted(Html5Stylist.cssColor(rgb));
            }
            case 3 -> {
                String var11_14;
                String var9_27 = var11_14 = Html5Stylist.$proxy$colorName((Style.ColorName)style3);
                boolean var11_15 = Html5Stylist.$proxy$background((Style.ColorName)style3);
                boolean background = var11_15;
                if (background) {
                    yield "background-color: var(%s);".formatted(Html5Stylist.cssVar(var9_27));
                }
                yield "color: var(%s);".formatted(Html5Stylist.cssVar(var9_27));
            }
            default -> null;
        };
    }

    @NotNull
    public static String colorsToCss(@NotNull ColorScheme colorScheme) {
        return colorScheme.definedColors().toImmutableSeq().view().map(t -> "%s: %s;".formatted(Html5Stylist.cssVar((String)t.component1()), Html5Stylist.cssColor((Integer)t.component2()))).joinToString((CharSequence)"\n", arg_0 -> Html5Stylist.lambda$colorsToCss$1("  %s", arg_0));
    }

    @NotNull
    public static String cssVar(@NotNull String name) {
        return "--" + Html5Stylist.normalizeCssId(name);
    }

    @NotNull
    public static String cssColor(int rgb) {
        return "#%06x".formatted(rgb);
    }

    @NotNull
    public static String normalizeCssId(@NotNull String selector) {
        selector = selector.replaceAll("::", "-");
        StringBuilder builder = new StringBuilder();
        for (char c : selector.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c >= '\u00a0' || c == '-' || c == '_') {
                builder.append(c);
                continue;
            }
            builder.append(Integer.toHexString(c));
        }
        return builder.toString();
    }

    private static /* synthetic */ Style.LineThrough.Position $proxy$position(Style.LineThrough arg0) {
        try {
            return arg0.position();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Style.LineThrough.Shape $proxy$shape(Style.LineThrough arg0) {
        try {
            return arg0.shape();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Style.Color $proxy$color(Style.LineThrough arg0) {
        try {
            return arg0.color();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ int $proxy$color(Style.ColorHex arg0) {
        try {
            return arg0.color();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ boolean $proxy$background(Style.ColorHex arg0) {
        try {
            return arg0.background();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ String $proxy$colorName(Style.ColorName arg0) {
        try {
            return arg0.colorName();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ boolean $proxy$background(Style.ColorName arg0) {
        try {
            return arg0.background();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ CharSequence lambda$colorsToCss$1(String rec$, Object xva$0) {
        return "  %s".formatted(xva$0);
    }

    public static class ClassedPreset
    extends ClosingStylist.Delegate {
        public ClassedPreset(@NotNull ClosingStylist delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        protected ImmutableSeq<ClosingStylist.StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
            String className = (String)Html5Stylist.styleKeyToCss(styleName).last();
            return ImmutableSeq.of((Object)new ClosingStylist.StyleToken("<span class=\"%s\">".formatted(className), "</span>", false));
        }
    }
}

