/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public final class HtmlConstants {
    @NotNull
    public static final String HOVER_TYPE_POPUP_STYLE = HtmlConstants.tag("style", HtmlConstants.readResource("/aya-html/hover-tooltip.css"));
    @NotNull
    public static final String HOVER_STYLE = HtmlConstants.tag("style", HtmlConstants.readResource("/aya-html/hover.css"));
    @NotNull
    public static final String HOVER_ALL_OCCURS_JS_HIGHLIGHT_FN = HtmlConstants.readResource("/aya-html/highlight-fn.js");
    @NotNull
    public static final String HOVER_ALL_OCCURS_JS_INIT;
    @NotNull
    public static final String HOVER_SHOW_TOOLTIP_JS_SHOW_FN;
    @NotNull
    public static final String HOVER_SHOW_TOOLTIP_JS_INIT;
    @Language(value="HTML")
    @NotNull
    public static final String HOVER;
    @Language(value="HTML")
    @NotNull
    public static final String HOVER_SSR;
    @NotNull
    public static final String KATEX_AUTO_RENDER_EXTERNAL_RESOURCES;
    @NotNull
    public static final String KATEX_AUTO_RENDER_INIT;
    @NotNull
    public static final String KATEX_AUTO_RENDER;

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String readResource(String name) {
        try (InputStream stream = HtmlConstants.class.getResourceAsStream(name);){
            String string;
            assert (stream != null);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String tag(String tag, String read) {
        return "<" + tag + ">\n" + read + "\n</" + tag + ">\n";
    }

    @NotNull
    private static String scoped(String read) {
        return "{\n" + read.indent(2) + "\n}\n";
    }

    static {
        HOVER_SHOW_TOOLTIP_JS_INIT = HtmlConstants.readResource("/aya-html/show-tooltip.js");
        HOVER_SHOW_TOOLTIP_JS_SHOW_FN = HtmlConstants.readResource("/aya-html/show-tooltip-fn.js");
        HOVER_ALL_OCCURS_JS_INIT = HtmlConstants.readResource("/aya-html/highlight-occurrences.js");
        HOVER = "<script>\n" + HOVER_ALL_OCCURS_JS_HIGHLIGHT_FN + HOVER_SHOW_TOOLTIP_JS_SHOW_FN + "window.onload = function () {\n" + HtmlConstants.scoped(HOVER_ALL_OCCURS_JS_INIT) + HtmlConstants.scoped(HOVER_SHOW_TOOLTIP_JS_INIT) + "};\n</script>\n";
        HOVER_SSR = "<script>\nexport default {\n  mounted() {\n" + HOVER_ALL_OCCURS_JS_HIGHLIGHT_FN + HOVER_SHOW_TOOLTIP_JS_SHOW_FN + HtmlConstants.scoped(HOVER_ALL_OCCURS_JS_INIT) + HtmlConstants.scoped(HOVER_SHOW_TOOLTIP_JS_INIT) + "  }\n}\n</script>\n";
        KATEX_AUTO_RENDER_EXTERNAL_RESOURCES = HtmlConstants.readResource("/aya-html/katex.html");
        KATEX_AUTO_RENDER_INIT = HtmlConstants.readResource("/aya-html/katex-auto-render.js");
        KATEX_AUTO_RENDER = KATEX_AUTO_RENDER_EXTERNAL_RESOURCES + HtmlConstants.tag("script", KATEX_AUTO_RENDER_INIT);
    }
}

