/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.md;

import java.util.EnumSet;
import java.util.regex.Pattern;
import org.aya.pretty.backend.html.DocHtmlPrinter;
import org.aya.pretty.backend.html.HtmlConstants;
import org.aya.pretty.backend.md.MdStylist;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Language;
import org.aya.pretty.doc.Link;
import org.jetbrains.annotations.NotNull;

public class DocMdPrinter
extends DocHtmlPrinter<Config> {
    public static final Pattern MD_ESCAPE = Pattern.compile("[#&()*+;<>\\[\\\\\\]_`|~]");
    public static final Pattern MD_ESCAPE_FAKE_LIST = Pattern.compile("(^\\s*\\d+)\\.( |$)", 8);

    @Override
    protected void renderHeader(@NotNull Cursor cursor) {
    }

    @Override
    protected void renderFooter(@NotNull Cursor cursor) {
        if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.HeaderCode, false).booleanValue()) {
            if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.AyaFlavored, false).booleanValue()) {
                cursor.invisibleContent(HtmlConstants.HOVER_STYLE);
                cursor.invisibleContent(HtmlConstants.HOVER_TYPE_POPUP_STYLE);
                cursor.invisibleContent(((Config)this.config).opt(StringPrinterConfig.StyleOptions.ServerSideRendering, false) != false ? HtmlConstants.HOVER_SSR : HtmlConstants.HOVER);
            }
            this.renderCssStyle(cursor);
        }
    }

    @Override
    @NotNull
    protected String escapePlainText(@NotNull String content, EnumSet<StringPrinter.Outer> outer) {
        if (outer.contains((Object)StringPrinter.Outer.EnclosingTag)) {
            return super.escapePlainText(content, outer);
        }
        if (outer.contains((Object)StringPrinter.Outer.Code) || outer.contains((Object)StringPrinter.Outer.Math)) {
            return content;
        }
        content = MD_ESCAPE.matcher(content).replaceAll(result -> {
            String chara = result.group();
            if (chara.equals("\\")) {
                chara = "\\\\";
            }
            return "\\\\" + chara;
        });
        content = MD_ESCAPE_FAKE_LIST.matcher(content).replaceAll("$1\\\\.$2");
        return content;
    }

    @Override
    protected void renderHardLineBreak(@NotNull Cursor cursor, EnumSet<StringPrinter.Outer> outer) {
        cursor.lineBreakWith("\n");
    }

    @Override
    protected void renderHyperLinked(@NotNull Cursor cursor, @NotNull Doc.HyperLinked text, EnumSet<StringPrinter.Outer> outer) {
        Runnable pureMd = () -> {
            Link href = text.href();
            cursor.invisibleContent("[");
            this.renderDoc(cursor, text.doc(), outer);
            cursor.invisibleContent("](");
            cursor.invisibleContent(this.normalizeHref(href));
            cursor.invisibleContent(")");
        };
        this.runSwitch(pureMd, () -> {
            if (!outer.isEmpty()) {
                super.renderHyperLinked(cursor, text, outer);
            } else {
                pureMd.run();
            }
        });
    }

    @Override
    protected void renderImage(@NotNull Cursor cursor, @NotNull Doc.Image image, EnumSet<StringPrinter.Outer> outer) {
        cursor.invisibleContent("![");
        this.renderDoc(cursor, image.alt(), outer);
        cursor.invisibleContent("](");
        cursor.invisibleContent(this.normalizeHref(image.src()));
        cursor.invisibleContent(")");
    }

    @Override
    protected void renderList(@NotNull Cursor cursor, @NotNull Doc.List list, EnumSet<StringPrinter.Outer> outer) {
        this.formatList(cursor, list, outer);
    }

    @Override
    protected void renderInlineMath(@NotNull Cursor cursor,  @NotNull Doc.InlineMath code, EnumSet<StringPrinter.Outer> outer) {
        this.formatInline(cursor, code.formula(), "$", "$", EnumSet.of(StringPrinter.Outer.Math));
    }

    @Override
    protected void renderMathBlock(@NotNull Cursor cursor,  @NotNull Doc.MathBlock block, EnumSet<StringPrinter.Outer> outer) {
        this.formatBlock(cursor, block.formula(), "$$", "$$", EnumSet.of(StringPrinter.Outer.Math));
    }

    @Override
    protected void renderInlineCode(@NotNull Cursor cursor, @NotNull Doc.InlineCode code, EnumSet<StringPrinter.Outer> outer) {
        Runnable pureMd = () -> this.formatInline(cursor, code.code(), "`", "`", EnumSet.of(StringPrinter.Outer.Code));
        this.runSwitch(pureMd, () -> {
            if (code.language().isAya()) {
                this.formatInline(cursor, code.code(), "<code class=\"Aya\">", "</code>", EnumSet.of(StringPrinter.Outer.EnclosingTag));
            } else {
                pureMd.run();
            }
        });
    }

    @Override
    protected void renderCodeBlock(@NotNull Cursor cursor, @NotNull Doc.CodeBlock block, EnumSet<StringPrinter.Outer> outer) {
        String mark = block.language() == Language.Builtin.Markdown ? "~~~" : "```";
        Runnable pureMd = () -> this.formatBlock(cursor, block.code(), mark + block.language().displayName().toLowerCase(), mark, EnumSet.of(StringPrinter.Outer.Code));
        this.runSwitch(pureMd, () -> {
            if (block.language().isAya()) {
                this.formatBlock(cursor, "<pre class=\"Aya\">", "</pre>", outer, () -> this.formatInline(cursor, block.code(), "<code>", "</code>", EnumSet.of(StringPrinter.Outer.EnclosingTag)));
            } else {
                pureMd.run();
            }
        });
    }

    private void runSwitch(@NotNull Runnable pureMd, @NotNull Runnable ayaMd) {
        if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.AyaFlavored, false).booleanValue()) {
            ayaMd.run();
        } else {
            pureMd.run();
        }
    }

    public static class Config
    extends DocHtmlPrinter.Config {
        public Config(@NotNull MdStylist stylist) {
            super(stylist);
        }
    }
}

