/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.doc;

import kala.collection.immutable.ImmutableSeq;
import org.jetbrains.annotations.NotNull;

public interface Language {
    @NotNull
    public String displayName();

    @NotNull
    public ImmutableSeq<Language> parentLanguage();

    default public boolean isAya() {
        return this == Builtin.Aya || this.parentLanguage().anyMatch(Language::isAya);
    }

    @NotNull
    public static Language of(@NotNull String displayName) {
        for (Builtin e : Builtin.values()) {
            if (!e.displayName.equalsIgnoreCase(displayName)) continue;
            return e;
        }
        return new Some(displayName);
    }

    public static enum Builtin implements Language
    {
        Plain(""),
        Markdown("markdown"),
        Aya("aya");

        final String displayName;

        private Builtin(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public ImmutableSeq<Language> parentLanguage() {
            return ImmutableSeq.empty();
        }
    }

    public record Some(@NotNull String displayName) implements Language
    {
        @Override
        @NotNull
        public ImmutableSeq<Language> parentLanguage() {
            return ImmutableSeq.empty();
        }
    }
}

