/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string;

import kala.collection.Map;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.jetbrains.annotations.NotNull;

public class StringPrinter<StringConfig extends StringPrinterConfig>
implements Printer<String, StringConfig>,
Cursor.CursorAPI {
    protected StringConfig config;
    @NotNull
    private static final Map<String, String> unicodeMapping = Map.ofEntries((Tuple2)Tuple.of((Object)"Pi", (Object)"\u03a0"), (Tuple2)Tuple.of((Object)"Sig", (Object)"\u03a3"), (Tuple2)Tuple.of((Object)"\\", (Object)"\u03bb"), (Tuple2)Tuple.of((Object)"=>", (Object)"\u21d2"), (Tuple2)Tuple.of((Object)"->", (Object)"\u2192"));

    @Override
    @NotNull
    public String makeIndent(int indent) {
        return " ".repeat(indent);
    }

    @Override
    @NotNull
    public String render(@NotNull StringConfig config, @NotNull Doc doc) {
        this.config = config;
        Cursor cursor = new Cursor(this);
        this.renderHeader(cursor);
        this.renderDoc(cursor, doc);
        this.renderFooter(cursor);
        return cursor.result().toString();
    }

    private int lineRemaining(@NotNull Cursor cursor) {
        int pw = ((PrinterConfig.Basic)this.config).getPageWidth();
        return pw == -1 ? pw : pw - cursor.getCursor();
    }

    protected int predictWidth(@NotNull Cursor cursor, @NotNull Doc doc) {
        if (doc instanceof Doc.Empty) {
            return 0;
        }
        Doc doc2 = doc;
        if (doc2 instanceof Doc.PlainText) {
            Doc.PlainText text = (Doc.PlainText)doc2;
            return text.text().length();
        }
        doc2 = doc;
        if (doc2 instanceof Doc.SpecialSymbol) {
            Doc.SpecialSymbol symbol = (Doc.SpecialSymbol)doc2;
            return symbol.text().length();
        }
        doc2 = doc;
        if (doc2 instanceof Doc.HyperLinked) {
            Doc.HyperLinked text = (Doc.HyperLinked)doc2;
            return this.predictWidth(cursor, text.doc());
        }
        doc2 = doc;
        if (doc2 instanceof Doc.Styled) {
            Doc.Styled styled = (Doc.Styled)doc2;
            return this.predictWidth(cursor, styled.doc());
        }
        if (doc instanceof Doc.Line) {
            return 0;
        }
        doc2 = doc;
        if (doc2 instanceof Doc.FlatAlt) {
            Doc.FlatAlt alt = (Doc.FlatAlt)doc2;
            return this.predictWidth(cursor, alt.defaultDoc());
        }
        doc2 = doc;
        if (doc2 instanceof Doc.Cat) {
            Doc.Cat cat = (Doc.Cat)doc2;
            return (Integer)cat.inner().view().map(inner -> this.predictWidth(cursor, (Doc)inner)).reduce(Integer::sum);
        }
        doc2 = doc;
        if (doc2 instanceof Doc.Nest) {
            Doc.Nest nest = (Doc.Nest)doc2;
            return this.predictWidth(cursor, nest.doc()) + nest.indent();
        }
        doc2 = doc;
        if (doc2 instanceof Doc.Union) {
            Doc.Union union = (Doc.Union)doc2;
            return this.predictWidth(cursor, union.longerOne());
        }
        doc2 = doc;
        if (doc2 instanceof Doc.Column) {
            Doc.Column column = (Doc.Column)doc2;
            return this.predictWidth(cursor, column.docBuilder().apply(cursor.getCursor()));
        }
        doc2 = doc;
        if (doc2 instanceof Doc.Nesting) {
            Doc.Nesting nesting = (Doc.Nesting)doc2;
            return this.predictWidth(cursor, nesting.docBuilder().apply(cursor.getNestLevel()));
        }
        doc2 = doc;
        if (doc2 instanceof Doc.PageWidth) {
            Doc.PageWidth pageWidth = (Doc.PageWidth)doc2;
            return this.predictWidth(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()));
        }
        throw new IllegalStateException("unreachable");
    }

    @NotNull
    protected Doc fitsBetter(@NotNull Cursor cursor, @NotNull Doc a, @NotNull Doc b) {
        if (cursor.isAtLineStart()) {
            return a;
        }
        int lineRem = this.lineRemaining(cursor);
        return lineRem == -1 || this.predictWidth(cursor, a) <= lineRem ? a : b;
    }

    protected void renderHeader(@NotNull Cursor cursor) {
    }

    protected void renderFooter(@NotNull Cursor cursor) {
    }

    protected void renderDoc(@NotNull Cursor cursor, @NotNull Doc doc) {
        Doc doc2 = doc;
        if (doc2 instanceof Doc.PlainText) {
            Doc.PlainText text = (Doc.PlainText)doc2;
            this.renderPlainText(cursor, text.text());
        } else {
            doc2 = doc;
            if (doc2 instanceof Doc.SpecialSymbol) {
                Doc.SpecialSymbol symbol = (Doc.SpecialSymbol)doc2;
                this.renderSpecialSymbol(cursor, symbol.text());
            } else {
                doc2 = doc;
                if (doc2 instanceof Doc.HyperLinked) {
                    Doc.HyperLinked text = (Doc.HyperLinked)doc2;
                    this.renderHyperLinked(cursor, text);
                } else {
                    doc2 = doc;
                    if (doc2 instanceof Doc.Styled) {
                        Doc.Styled styled = (Doc.Styled)doc2;
                        this.renderStyled(cursor, styled);
                    } else if (doc instanceof Doc.Line) {
                        this.renderHardLineBreak(cursor);
                    } else {
                        doc2 = doc;
                        if (doc2 instanceof Doc.FlatAlt) {
                            Doc.FlatAlt alt = (Doc.FlatAlt)doc2;
                            this.renderFlatAlt(cursor, alt);
                        } else {
                            doc2 = doc;
                            if (doc2 instanceof Doc.Cat) {
                                Doc.Cat cat = (Doc.Cat)doc2;
                                cat.inner().forEach(inner -> this.renderDoc(cursor, (Doc)inner));
                            } else {
                                doc2 = doc;
                                if (doc2 instanceof Doc.Nest) {
                                    Doc.Nest nest = (Doc.Nest)doc2;
                                    this.renderNest(cursor, nest);
                                } else {
                                    doc2 = doc;
                                    if (doc2 instanceof Doc.Union) {
                                        Doc.Union union = (Doc.Union)doc2;
                                        this.renderUnionDoc(cursor, union);
                                    } else {
                                        doc2 = doc;
                                        if (doc2 instanceof Doc.Column) {
                                            Doc.Column column = (Doc.Column)doc2;
                                            this.renderDoc(cursor, column.docBuilder().apply(cursor.getCursor()));
                                        } else {
                                            doc2 = doc;
                                            if (doc2 instanceof Doc.Nesting) {
                                                Doc.Nesting nesting = (Doc.Nesting)doc2;
                                                this.renderDoc(cursor, nesting.docBuilder().apply(cursor.getNestLevel()));
                                            } else {
                                                doc2 = doc;
                                                if (doc2 instanceof Doc.PageWidth) {
                                                    Doc.PageWidth pageWidth = (Doc.PageWidth)doc2;
                                                    this.renderDoc(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected void renderSpecialSymbol(@NotNull Cursor cursor, @NotNull String text) {
        if (((StringPrinterConfig)this.config).unicode) {
            for (String k : unicodeMapping.keysView()) {
                if (!text.contains(k)) continue;
                cursor.visibleContent(text.replace(k, (CharSequence)unicodeMapping.get((Object)k)));
                return;
            }
        }
        this.renderPlainText(cursor, text);
    }

    protected void renderNest(@NotNull Cursor cursor, @NotNull Doc.Nest nest) {
        cursor.nested(nest.indent(), () -> this.renderDoc(cursor, nest.doc()));
    }

    protected void renderUnionDoc(@NotNull Cursor cursor, @NotNull Doc.Union union) {
        this.renderDoc(cursor, this.fitsBetter(cursor, union.shorterOne(), union.longerOne()));
    }

    protected void renderFlatAlt(@NotNull Cursor cursor, @NotNull Doc.FlatAlt alt) {
        this.renderDoc(cursor, this.fitsBetter(cursor, alt.defaultDoc(), alt.preferWhenFlatten()));
    }

    protected void renderHyperLinked(@NotNull Cursor cursor, @NotNull Doc.HyperLinked text) {
        this.renderDoc(cursor, text.doc());
    }

    protected void renderStyled(@NotNull Cursor cursor, @NotNull Doc.Styled styled) {
        StringStylist formatter = ((StringPrinterConfig)this.config).getStyleFormatter();
        formatter.format(styled.styles(), cursor, () -> this.renderDoc(cursor, styled.doc()));
    }

    protected void renderPlainText(@NotNull Cursor cursor, @NotNull String content) {
        cursor.visibleContent(content);
    }

    protected void renderHardLineBreak(@NotNull Cursor cursor) {
        cursor.lineBreakWith("\n");
    }
}

