/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.instrument.impl;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedMap;
import org.babyfish.lang.bytecode.ASMTreeUtils;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.lang.instrument.IllegalClassException;
import org.babyfish.lang.internal.I18NUtils;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.model.Contravariance;
import org.babyfish.model.ModelType;
import org.babyfish.model.instrument.metadata.MetadataClass;
import org.babyfish.model.instrument.metadata.MetadataComparatorPart;
import org.babyfish.model.instrument.metadata.MetadataProperty;
import org.babyfish.model.instrument.metadata.spi.AbstractMetadataClass;
import org.babyfish.model.instrument.spi.AbstractObjectModelInstrumenter;
import org.babyfish.model.jpa.JPAModel;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataPropertyImpl;
import org.babyfish.model.jpa.instrument.metadata.JPAMetadataClass;
import org.babyfish.model.jpa.instrument.metadata.JPAMetadataProperty;
import org.babyfish.model.jpa.metadata.JPAScalarType;
import org.babyfish.org.objectweb.asm.Type;
import org.babyfish.org.objectweb.asm.tree.AnnotationNode;
import org.babyfish.org.objectweb.asm.tree.ClassNode;
import org.babyfish.org.objectweb.asm.tree.FieldNode;
import org.babyfish.org.objectweb.asm.tree.MethodNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instrumented
final class JPAMetadataClassImpl
extends AbstractMetadataClass
implements JPAMetadataClass {
    private static ResourceBundle {resourceBundle};
    private static final Class<? extends Annotation>[] JPA_MODEL_ANNOATION_TYPES;
    private static final ModelType[] MODEL_TYPES;
    ModelType modelType;
    XOrderedMap<String, JPAMetadataPropertyImpl> declaredProperties;
    XOrderedMap<String, JPAMetadataPropertyImpl> properties;
    List<JPAMetadataPropertyImpl> propertyList;
    JPAMetadataClassImpl superClass;
    JPAMetadataClassImpl ancestorClass;
    JPAMetadataPropertyImpl idProperty;
    JPAMetadataPropertyImpl versionProperty;
    Collection<MetadataComparatorPart> comparatorParts;
    Unresolved unresolved = new Unresolved();

    protected JPAMetadataClassImpl(File classFile, ClassNode classNode) {
        super(classFile, classNode);
        this.unresolved.classNode = classNode;
        this.determineModelType();
        this.validateAccess();
        this.validateMethods();
        this.initDeclaredProperties();
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public MetadataClass getSuperClass() {
        return this.superClass;
    }

    public MetadataClass getAncestorClass() {
        return this.ancestorClass;
    }

    public XOrderedMap<String, MetadataProperty> getDeclaredProperties() {
        return this.declaredProperties;
    }

    public XOrderedMap<String, MetadataProperty> getProperties() {
        return this.properties;
    }

    public List<MetadataProperty> getPropertyList() {
        return this.propertyList;
    }

    public Collection<MetadataComparatorPart> getComparatorParts() {
        return this.comparatorParts;
    }

    @Override
    public JPAMetadataProperty getIdProperty() {
        return this.idProperty;
    }

    @Override
    public JPAMetadataProperty getVersionProperty() {
        return this.versionProperty;
    }

    public void finish() {
        this.unresolved = null;
    }

    public void resolveSuperClass(AbstractObjectModelInstrumenter instrumenter) {
        ClassNode classNode;
        AnnotationNode overrideNode;
        JPAMetadataClassImpl superClass = null;
        String superTypeName = this.getSuperTypeName();
        block3: while (!superTypeName.equals("java.lang.Object")) {
            superClass = (JPAMetadataClassImpl)instrumenter.getMetadataClass(superTypeName);
            if (superClass == null) {
                ClassNode superClassNode = instrumenter.getClassNode(superTypeName);
                superTypeName = superClassNode.superName.replace('/', '.');
                continue;
            }
            switch (this.modelType) {
                case REFERENCE: {
                    if (superClass.getModelType() != ModelType.EMBEDDABLE) break block3;
                    throw new IllegalClassException(JPAMetadataClassImpl.invalidSuperModelType(this.getName(), this.unresolved.modelAnnotationType, superClass.getName(), superClass.unresolved.modelAnnotationType));
                }
                default: {
                    if (superClass.getModelType() == ModelType.ABSTRACT) break block3;
                    throw new IllegalClassException(JPAMetadataClassImpl.invalidSuperModelType(this.getName(), this.unresolved.modelAnnotationType, superClass.getName(), superClass.unresolved.modelAnnotationType));
                }
            }
        }
        if ((overrideNode = ASMTreeUtils.getAnnotationNode((Object)(classNode = this.unresolved.classNode), AttributeOverrides.class)) == null) {
            overrideNode = ASMTreeUtils.getAnnotationNode((Object)classNode, AttributeOverride.class);
        }
        if (overrideNode != null && (superClass == null || superClass.getModelType() != ModelType.ABSTRACT)) {
            throw new IllegalClassException(JPAMetadataClassImpl.overridingRequiresSuperAbstractModel(this.getName(), ASMUtils.toClassName((String)overrideNode.desc), JPAModel.class, MappedSuperclass.class));
        }
        this.superClass = superClass;
    }

    public void resolveAncestorClass() {
        if (this.superClass == null) {
            this.ancestorClass = this;
        } else {
            this.superClass.resolveAncestorClass();
            this.ancestorClass = this.superClass.ancestorClass;
        }
    }

    public void resolveProperties() {
        if (this.properties != null) {
            return;
        }
        if (this.superClass == null) {
            this.properties = this.declaredProperties;
            return;
        }
        this.superClass.resolveProperties();
        if (this.declaredProperties.isEmpty()) {
            this.properties = this.superClass.properties;
            return;
        }
        LinkedHashMap map = new LinkedHashMap(this.superClass.properties);
        for (JPAMetadataPropertyImpl property : this.declaredProperties.values()) {
            MetadataProperty superProperty = (MetadataProperty)map.put((Object)property.getName(), (Object)property);
            if (superProperty == null || superProperty.getName().equals(property.unresolved.contravarianceFrom)) continue;
            throw new IllegalClassException(JPAMetadataClassImpl.missContravarinaceWithSameName(property, superProperty, Contravariance.class, property.getName()));
        }
        this.properties = MACollections.unmodifiable((XOrderedMap)map);
    }

    public void resolvePropertyList() {
        if (this.propertyList != null) {
            return;
        }
        if (this.superClass != null) {
            this.superClass.resolvePropertyList();
        }
        int propertyId = this.superClass != null ? this.superClass.propertyList.size() : 0;
        Object[] arr = new JPAMetadataPropertyImpl[propertyId + this.declaredProperties.size()];
        if (this.superClass != null) {
            this.superClass.propertyList.toArray(arr);
        }
        for (JPAMetadataPropertyImpl property : this.declaredProperties.values()) {
            arr[propertyId] = property;
            property.id = propertyId++;
        }
        this.propertyList = MACollections.wrap((Object[])arr);
    }

    public void resolveIdProperty() {
        if (this.unresolved.idPropertyResolved) {
            return;
        }
        this.unresolved.idPropertyResolved = true;
        if (this.superClass != null) {
            this.superClass.resolveIdProperty();
            this.idProperty = this.superClass.idProperty;
        }
        for (JPAMetadataPropertyImpl property : this.declaredProperties.values()) {
            if (property.scalarType != JPAScalarType.ID) continue;
            if (this.idProperty != null) {
                throw new IllegalClassException(JPAMetadataClassImpl.duplicatedSpecialProperty(property, this.idProperty, Id.class));
            }
            if (this.modelType != ModelType.REFERENCE) {
                throw new IllegalClassException(JPAMetadataClassImpl.specicalPropertyRequiresEntity(property, Id.class, Entity.class));
            }
            this.idProperty = property;
        }
        if (this.modelType == ModelType.REFERENCE && this.idProperty == null) {
            throw new IllegalClassException(JPAMetadataClassImpl.idPropertyIsRequired(this.getName(), Id.class, Entity.class));
        }
    }

    public void resolveVersionProperty() {
        if (this.unresolved.versionPropertyResolved) {
            return;
        }
        this.unresolved.versionPropertyResolved = true;
        if (this.superClass != null) {
            this.superClass.resolveVersionProperty();
            this.versionProperty = this.superClass.versionProperty;
        }
        for (JPAMetadataPropertyImpl property : this.declaredProperties.values()) {
            if (property.scalarType != JPAScalarType.VERSION) continue;
            if (this.versionProperty != null) {
                throw new IllegalClassException(JPAMetadataClassImpl.duplicatedSpecialProperty(property, this.versionProperty, Version.class));
            }
            if (this.modelType != ModelType.REFERENCE) {
                throw new IllegalClassException(JPAMetadataClassImpl.specicalPropertyRequiresEntity(property, Version.class, Entity.class));
            }
            this.idProperty = property;
        }
    }

    public void resolveComparatorParts() {
        this.comparatorParts = this.determineComparatorParts(this.unresolved.classNode);
    }

    private void determineModelType() {
        Unresolved unresolved = this.unresolved;
        ClassNode classNode = unresolved.classNode;
        ModelType type = null;
        for (int i = MODEL_TYPES.length - 1; i >= 0; --i) {
            if (ASMTreeUtils.getAnnotationNode((Object)classNode, JPA_MODEL_ANNOATION_TYPES[i]) == null) continue;
            if (unresolved.modelAnnotationType != null) {
                throw new IllegalClassException(JPAMetadataClassImpl.conflictAnnotations(this.getName(), unresolved.modelAnnotationType, JPA_MODEL_ANNOATION_TYPES[i]));
            }
            unresolved.modelAnnotationType = JPA_MODEL_ANNOATION_TYPES[i];
            type = MODEL_TYPES[i];
        }
        if (type == null) {
            throw new IllegalClassException(JPAMetadataClassImpl.missAnnotation(this.getName(), JPA_MODEL_ANNOATION_TYPES));
        }
        this.modelType = type;
    }

    private void validateAccess() {
        ClassNode classNode = this.unresolved.classNode;
        AnnotationNode accessNode = ASMTreeUtils.getAnnotationNode((Object)classNode, Access.class);
        if (accessNode != null) {
            throw new IllegalClassException(JPAMetadataClassImpl.unexpectedJpaModelAccess(this.getName(), Access.class, JPAModel.class));
        }
    }

    private void validateMethods() {
        ClassNode classNode = this.unresolved.classNode;
        if (classNode.methods == null) {
            return;
        }
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.visibleAnnotations == null) continue;
            for (AnnotationNode annotationNode : methodNode.visibleAnnotations) {
                String annotationClassName = ASMUtils.toClassName((String)annotationNode.desc);
                int lastDotIndex = annotationClassName.lastIndexOf(46);
                if (lastDotIndex == -1 || !annotationClassName.substring(0, lastDotIndex).equals("javax.persistence")) continue;
                Type[] types = Type.getArgumentTypes((String)methodNode.desc);
                StringBuilder builder = new StringBuilder();
                builder.append(methodNode.name).append('(');
                boolean addComma = false;
                for (Type type : types) {
                    if (addComma) {
                        builder.append(", ");
                        continue;
                    }
                    builder.append(ASMUtils.toClassName((String)type.getDescriptor()));
                }
                builder.append(')');
                throw new IllegalClassException(JPAMetadataClassImpl.methodShouldNotBeMarkedBy(this.getName(), builder.toString(), annotationClassName, JPAModel.class));
            }
        }
    }

    private void initDeclaredProperties() {
        ClassNode classNode = this.unresolved.classNode;
        if (classNode.fields == null) {
            this.declaredProperties = MACollections.emptyOrderedMap();
            return;
        }
        LinkedHashMap map = new LinkedHashMap();
        for (FieldNode fieldNode : classNode.fields) {
            LinkedHashSet annotationClassNames = new LinkedHashSet();
            JPAMetadataClassImpl.collectAnnoationClassNames(fieldNode.visibleAnnotations, "javax.persistence", (Set<String>)annotationClassNames);
            JPAMetadataClassImpl.collectAnnoationClassNames(fieldNode.invisibleAnnotations, Contravariance.class.getPackage().getName(), (Set<String>)annotationClassNames);
            if ((fieldNode.access & 8) != 0) {
                if (annotationClassNames.isEmpty()) continue;
                throw new IllegalClassException(JPAMetadataClassImpl.annotatedFieldCanNotBeStatic(this.getName(), fieldNode.name, (String)annotationClassNames.iterator().next()));
            }
            if ((fieldNode.access & 2) == 0 && !annotationClassNames.isEmpty()) {
                throw new IllegalClassException(JPAMetadataClassImpl.annotatedFieldMustBePrivate(this.getName(), fieldNode.name, (String)annotationClassNames.iterator().next()));
            }
            if (annotationClassNames.remove(Transient.class.getName())) {
                annotationClassNames.remove(Contravariance.class.getName());
                if (!annotationClassNames.isEmpty()) {
                    throw new IllegalClassException(JPAMetadataClassImpl.transientFieldCanNotBeMarkedBy(this.getName(), fieldNode.name, (String)annotationClassNames.iterator().next(), Transient.class));
                }
            }
            map.put((Object)fieldNode.name, (Object)new JPAMetadataPropertyImpl(this, fieldNode));
        }
        this.declaredProperties = MACollections.unmodifiable((XOrderedMap)map);
    }

    private static void collectAnnoationClassNames(List<AnnotationNode> annotationNodes, String packageName, Set<String> outputClassNames) {
        if (annotationNodes == null) {
            return;
        }
        for (AnnotationNode annotationNode : annotationNodes) {
            String className = ASMUtils.toClassName((String)annotationNode.desc);
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex == -1 || !className.substring(0, lastDotIndex).equals(packageName)) continue;
            outputClassNames.add(className);
        }
    }

    private static String conflictAnnotations(String arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("conflictAnnotations").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String missAnnotation(String arg0, Class[] arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("missAnnotation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String invalidSuperModelType(String arg0, Class arg1, String arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("invalidSuperModelType").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String unexpectedJpaModelAccess(String arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("unexpectedJpaModelAccess").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String annotatedFieldCanNotBeStatic(String arg0, String arg1, String arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("annotatedFieldCanNotBeStatic").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String annotatedFieldMustBePrivate(String arg0, String arg1, String arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("annotatedFieldMustBePrivate").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String transientFieldCanNotBeMarkedBy(String arg0, String arg1, String arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("transientFieldCanNotBeMarkedBy").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String methodShouldNotBeMarkedBy(String arg0, String arg1, String arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("methodShouldNotBeMarkedBy").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String overridingRequiresSuperAbstractModel(String arg0, String arg1, Class arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("overridingRequiresSuperAbstractModel").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String missContravarinaceWithSameName(JPAMetadataPropertyImpl arg0, MetadataProperty arg1, Class arg2, String arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("missContravarinaceWithSameName").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String duplicatedSpecialProperty(JPAMetadataPropertyImpl arg0, JPAMetadataPropertyImpl arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("duplicatedSpecialProperty").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String specicalPropertyRequiresEntity(JPAMetadataPropertyImpl arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("specicalPropertyRequiresEntity").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String idPropertyIsRequired(String arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataClassImpl");
        }
        return {resourceBundle}.getString("idPropertyIsRequired").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    static {
        JPA_MODEL_ANNOATION_TYPES = new Class[]{Entity.class, Embeddable.class, MappedSuperclass.class};
        MODEL_TYPES = new ModelType[]{ModelType.REFERENCE, ModelType.EMBEDDABLE, ModelType.ABSTRACT};
    }

    private static class Unresolved {
        ClassNode classNode;
        Class<? extends Annotation> modelAnnotationType;
        boolean idPropertyResolved;
        boolean versionPropertyResolved;

        private Unresolved() {
        }
    }
}

