/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.instrument.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.bytecode.ASMTreeUtils;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.lang.instrument.IllegalClassException;
import org.babyfish.lang.internal.I18NUtils;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.model.jpa.instrument.impl.DbIdentifiers;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataClassImpl;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataPropertyImpl;
import org.babyfish.org.objectweb.asm.tree.AnnotationNode;
import org.babyfish.org.objectweb.asm.tree.FieldNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instrumented
final class JPAMetadataJoin {
    private static ResourceBundle {resourceBundle};
    String tableName;
    List<Column> columns;
    List<Column> inversedColumns;

    public JPAMetadataJoin(JPAMetadataPropertyImpl property) {
        JPAMetadataClassImpl referencedSingleIdClass;
        ArrayList annotationTypes = new ArrayList();
        FieldNode fieldNode = property.unresolved.fieldNode;
        AnnotationNode joinColumnNode = ASMTreeUtils.getAnnotationNode((Object)fieldNode, JoinColumn.class);
        AnnotationNode joinColumnsNode = ASMTreeUtils.getAnnotationNode((Object)fieldNode, JoinColumns.class);
        AnnotationNode joinTableNode = ASMTreeUtils.getAnnotationNode((Object)fieldNode, JoinTable.class);
        if (property.unresolved.primaryAnnotationNode.desc.equals("Ljavax/persistence/ManyToMany;") && joinTableNode == null) {
            throw new IllegalClassException(JPAMetadataJoin.requireAnnoatation(property, ASMUtils.toClassName((String)property.unresolved.primaryAnnotationNode.desc), JoinTable.class));
        }
        if (joinColumnNode != null) {
            annotationTypes.add(JoinColumn.class);
        } else if (joinColumnsNode != null) {
            annotationTypes.add(JoinColumns.class);
        } else if (joinTableNode != null) {
            annotationTypes.add(JoinTable.class);
        }
        if (annotationTypes.isEmpty()) {
            throw new IllegalClassException(JPAMetadataJoin.requireAnyAnnoatation(property, ASMUtils.toClassName((String)property.unresolved.primaryAnnotationNode.desc), JoinColumn.class, JoinColumns.class, JoinTable.class));
        }
        if (annotationTypes.size() > 1) {
            throw new IllegalClassException(JPAMetadataJoin.conflictAnnotations(property, (Collection)annotationTypes));
        }
        JPAMetadataClassImpl inverseReferencedSingleIdClass = null;
        if (joinTableNode != null || property.unresolved.primaryAnnotationNode.desc.equals("Ljavax/persistence/OneToMany;")) {
            referencedSingleIdClass = JPAMetadataJoin.singleIdClass((JPAMetadataClassImpl)property.getDeclaringClass());
            inverseReferencedSingleIdClass = JPAMetadataJoin.singleIdClass(property.targetClass);
        } else {
            referencedSingleIdClass = JPAMetadataJoin.singleIdClass(property.targetClass);
            inverseReferencedSingleIdClass = JPAMetadataJoin.singleIdClass((JPAMetadataClassImpl)property.getDeclaringClass());
        }
        if (joinColumnNode != null) {
            this.initByJoinColumnNode(property, joinColumnNode, referencedSingleIdClass);
        } else if (joinColumnsNode != null) {
            this.initByJoinColumnsNode(property, joinColumnsNode, referencedSingleIdClass);
        } else {
            this.initByJoinTableNode(property, joinTableNode, referencedSingleIdClass, inverseReferencedSingleIdClass);
        }
    }

    private void initByJoinColumnNode(JPAMetadataPropertyImpl property, AnnotationNode joinColumnNode, JPAMetadataClassImpl referencedSingleIdClass) {
        this.columns = MACollections.wrap((Object[])new Column[]{new Column(property, joinColumnNode, "joinColumns", 0, referencedSingleIdClass)});
    }

    private void initByJoinColumnsNode(JPAMetadataPropertyImpl property, AnnotationNode joinColumnsNode, JPAMetadataClassImpl referencedSingleIdClass) {
        List joinColumnNodes = (List)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinColumnsNode, (String)"value");
        if (joinColumnNodes == null || joinColumnNodes.isEmpty()) {
            throw new IllegalClassException(JPAMetadataJoin.emptyJoinColumns(property, JoinColumns.class, JoinColumn.class));
        }
        if (joinColumnNodes.size() == 1) {
            this.columns = MACollections.wrap((Object[])new Column[]{new Column(property, (AnnotationNode)joinColumnNodes.get(0), "joinColumns", 0, referencedSingleIdClass)});
        } else {
            Object[] columns = new Column[joinColumnNodes.size()];
            int index = 0;
            for (AnnotationNode joinColumnNode : joinColumnNodes) {
                columns[index++] = new Column(property, joinColumnNode, "joinColumns", index, null);
            }
            this.columns = MACollections.wrap((Object[])columns);
        }
    }

    private void initByJoinTableNode(JPAMetadataPropertyImpl property, AnnotationNode joinTableNode, JPAMetadataClassImpl referencedSingleIdClass, JPAMetadataClassImpl inverseReferencedSingleIdClass) {
        this.tableName = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinTableNode, (String)"name", (Object)"");
        if (this.tableName.isEmpty()) {
            throw new IllegalClassException(JPAMetadataJoin.emptyJoinTableName(property, JoinTable.class));
        }
        List joinColumnNodes = (List)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinTableNode, (String)"joinColumns");
        if (joinColumnNodes == null || joinColumnNodes.isEmpty()) {
            throw new IllegalClassException(JPAMetadataJoin.emptyJoinTableColumns(property, JoinTable.class, "joinColumns", JoinColumn.class));
        }
        List inverseJoinColumnNodes = (List)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinTableNode, (String)"inverseJoinColumns");
        if (inverseJoinColumnNodes == null || inverseJoinColumnNodes.isEmpty()) {
            throw new IllegalClassException(JPAMetadataJoin.emptyJoinTableColumns(property, JoinTable.class, "inverseJoinColumnNodes", JoinColumn.class));
        }
        int count = joinColumnNodes.size();
        if (count == 1) {
            this.columns = MACollections.wrap((Object[])new Column[]{new Column(property, (AnnotationNode)joinColumnNodes.get(0), "joinColumns", 0, referencedSingleIdClass)});
            this.inversedColumns = MACollections.wrap((Object[])new Column[]{new Column(property, (AnnotationNode)inverseJoinColumnNodes.get(0), "inverseJoinColumns", 0, inverseReferencedSingleIdClass)});
        } else {
            Object[] columns = new Column[count];
            Object[] inverseColumns = new Column[count];
            int index = 0;
            for (AnnotationNode joinColumnNode : joinColumnNodes) {
                columns[index++] = new Column(property, joinColumnNode, "joinColumns", index, null);
            }
            index = 0;
            for (AnnotationNode inverseJoinColumnNode : inverseJoinColumnNodes) {
                inverseColumns[index++] = new Column(property, inverseJoinColumnNode, "inverseJoinColumns", index, null);
            }
            this.columns = MACollections.wrap((Object[])columns);
            this.inversedColumns = MACollections.wrap((Object[])inverseColumns);
        }
    }

    private static JPAMetadataClassImpl singleIdClass(JPAMetadataClassImpl jpaMetadataClassImpl) {
        if (jpaMetadataClassImpl.idProperty.targetClass != null) {
            return null;
        }
        return jpaMetadataClassImpl;
    }

    public boolean likeBedirectionalAssociation(JPAMetadataJoin join) {
        if (join == null) {
            return false;
        }
        if (this.tableName != null && join.tableName != null) {
            return DbIdentifiers.laxIdentifier(this.tableName).equals(DbIdentifiers.laxIdentifier(join.tableName)) && JPAMetadataJoin.like(this.columns, join.inversedColumns) && JPAMetadataJoin.like(this.inversedColumns, join.columns);
        }
        if (this.tableName == null && join.tableName == null) {
            return JPAMetadataJoin.like(this.columns, join.columns);
        }
        return false;
    }

    public boolean isReadonly() {
        for (Column column : this.columns) {
            if (!column.insertable && !column.updatable) continue;
            return false;
        }
        if (this.inversedColumns != null) {
            for (Column inversedColumn : this.inversedColumns) {
                if (!inversedColumn.insertable && !inversedColumn.updatable) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.tableName != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("@JoinTable(name = \"").append(this.tableName).append("\", joinColumns = ");
            JPAMetadataJoin.appendColumns(this.columns, builder);
            builder.append(", inverseJoinColumns = ");
            JPAMetadataJoin.appendColumns(this.inversedColumns, builder);
            builder.append(')');
            return builder.toString();
        }
        if (this.columns.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("@JoinColumns(");
            JPAMetadataJoin.appendColumns(this.columns, builder);
            builder.append(')');
            return builder.toString();
        }
        return this.columns.get(0).toString();
    }

    private static void appendColumns(List<Column> columns, StringBuilder builder) {
        if (columns.size() == 1) {
            builder.append(columns.get(0));
        } else {
            builder.append("{ ");
            boolean addComma = false;
            for (Column column : columns) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(column);
            }
            builder.append(" }");
        }
    }

    private static boolean like(List<Column> a, List<Column> b) {
        if (a.size() != b.size()) {
            return false;
        }
        a = JPAMetadataJoin.sort(a);
        b = JPAMetadataJoin.sort(b);
        for (int i = a.size() - 1; i >= 0; --i) {
            if (JPAMetadataJoin.like(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<Column> sort(List<Column> columns) {
        ArrayList list = new ArrayList(columns);
        Collections.sort(list, new Comparator<Column>(){

            @Override
            public int compare(Column c1, Column c2) {
                return DbIdentifiers.laxIdentifier(c1.name).compareTo(DbIdentifiers.laxIdentifier(c2.name));
            }
        });
        return list;
    }

    private static boolean like(Column a, Column b) {
        return DbIdentifiers.laxIdentifier(a.name).equals(DbIdentifiers.laxIdentifier(b.name)) && DbIdentifiers.laxIdentifier(a.referencedColumnName).equals(DbIdentifiers.laxIdentifier(b.referencedColumnName));
    }

    private static String requireAnnoatation(JPAMetadataPropertyImpl arg0, String arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("requireAnnoatation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String requireAnyAnnoatation(JPAMetadataPropertyImpl arg0, String arg1, Class arg2, Class arg3, Class arg4) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("requireAnyAnnoatation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3)).replace("{4}", I18NUtils.toString((Object)arg4));
    }

    private static String conflictAnnotations(JPAMetadataPropertyImpl arg0, Collection arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("conflictAnnotations").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String emptyJoinColumns(JPAMetadataPropertyImpl arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("emptyJoinColumns").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String emptyJoinTableName(JPAMetadataPropertyImpl arg0, Class arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("emptyJoinTableName").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String emptyJoinTableColumns(JPAMetadataPropertyImpl arg0, Class arg1, String arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("emptyJoinTableColumns").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String requireJoinColumnName(JPAMetadataPropertyImpl arg0, String arg1, int arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("requireJoinColumnName").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", Integer.toString(arg2));
    }

    private static String requireReferencedColumnName(JPAMetadataPropertyImpl arg0, String arg1, int arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataJoin");
        }
        return {resourceBundle}.getString("requireReferencedColumnName").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", Integer.toString(arg2));
    }

    private static class Column {
        String name;
        String referencedColumnName;
        boolean insertable;
        boolean updatable;

        Column(JPAMetadataPropertyImpl property, AnnotationNode joinColumnNode, String joinColumnsKindName, int index, JPAMetadataClassImpl referencedSingleIdClass) {
            this.name = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinColumnNode, (String)"name", (Object)"");
            if (this.name.isEmpty()) {
                throw new IllegalClassException(JPAMetadataJoin.requireJoinColumnName(property, joinColumnsKindName, index));
            }
            this.referencedColumnName = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinColumnNode, (String)"referencedColumnName", (Object)"");
            if (this.referencedColumnName.isEmpty()) {
                if (referencedSingleIdClass == null) {
                    throw new IllegalClassException(JPAMetadataJoin.requireReferencedColumnName(property, joinColumnsKindName, index));
                }
                this.referencedColumnName = referencedSingleIdClass.idProperty.unresolved.singleColumnName;
            }
            this.insertable = (Boolean)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinColumnNode, (String)"insertable", (Object)true);
            this.updatable = (Boolean)ASMTreeUtils.getAnnotationValue((AnnotationNode)joinColumnNode, (String)"updatable", (Object)false);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("@JoinColumn(name = \"").append(this.name).append("\", referencedColumnName = \"").append(this.referencedColumnName).append('\"');
            if (!this.insertable) {
                builder.append(", insertable = false");
            }
            if (!this.updatable) {
                builder.append(", updatable = false");
            }
            builder.append(')');
            return builder.toString();
        }
    }
}

