/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.instrument.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.Transient;
import org.babyfish.lang.bytecode.ASMTreeUtils;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.lang.instrument.IllegalClassException;
import org.babyfish.lang.internal.I18NUtils;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.model.Association;
import org.babyfish.model.ComparatorRule;
import org.babyfish.model.Contravariance;
import org.babyfish.model.IndexOf;
import org.babyfish.model.KeyOf;
import org.babyfish.model.instrument.metadata.MetadataClass;
import org.babyfish.model.instrument.metadata.MetadataComparatorPart;
import org.babyfish.model.instrument.metadata.MetadataProperty;
import org.babyfish.model.instrument.metadata.spi.AbstractMetadataClass;
import org.babyfish.model.instrument.metadata.spi.AbstractMetadataProperty;
import org.babyfish.model.jpa.JPAModel;
import org.babyfish.model.jpa.instrument.impl.DbIdentifiers;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataClassImpl;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataJoin;
import org.babyfish.model.jpa.instrument.impl.ObjectModel4JPAInstrumenter;
import org.babyfish.model.jpa.instrument.metadata.JPAMetadataProperty;
import org.babyfish.model.jpa.metadata.JPAScalarType;
import org.babyfish.model.metadata.AssociationType;
import org.babyfish.model.metadata.PropertyType;
import org.babyfish.org.objectweb.asm.tree.AnnotationNode;
import org.babyfish.org.objectweb.asm.tree.FieldNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instrumented
final class JPAMetadataPropertyImpl
extends AbstractMetadataProperty
implements JPAMetadataProperty {
    private static ResourceBundle {resourceBundle};
    private static final AnnotationNode DEFAULT_BASIC_ANNOTATION_NODE;
    int id;
    PropertyType propertyType;
    JPAScalarType scalarType;
    AssociationType associationType;
    JPAMetadataClassImpl keyClass;
    JPAMetadataClassImpl targetClass;
    JPAMetadataPropertyImpl convarianceProperty;
    JPAMetadataPropertyImpl oppositeProperty;
    JPAMetadataPropertyImpl indexProperty;
    JPAMetadataPropertyImpl keyProperty;
    JPAMetadataPropertyImpl referenceProperty;
    Collection<MetadataComparatorPart> comparatorParts;
    boolean deferrable;
    boolean absolute;
    boolean inverse;
    Unresolved unresolved = new Unresolved();

    public JPAMetadataPropertyImpl(JPAMetadataClassImpl declaringClass, FieldNode fieldNode) {
        super((AbstractMetadataClass)declaringClass, fieldNode);
        this.unresolved.fieldNode = fieldNode;
        this.determinePrimaryAnnoataion();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public boolean isMandatory() {
        return this.scalarType == JPAScalarType.ID || this.scalarType == JPAScalarType.VERSION;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public MetadataClass getKeyClass() {
        return this.keyClass;
    }

    public MetadataClass getTargetClass() {
        return this.targetClass;
    }

    public MetadataProperty getIndexProperty() {
        return this.indexProperty;
    }

    public MetadataProperty getKeyProperty() {
        return this.keyProperty;
    }

    public MetadataProperty getReferenceProperty() {
        return this.referenceProperty;
    }

    public MetadataProperty getConvarianceProperty() {
        return this.convarianceProperty;
    }

    public MetadataProperty getOppositeProperty() {
        return this.oppositeProperty;
    }

    public Collection<MetadataComparatorPart> getComparatorParts() {
        return this.comparatorParts;
    }

    @Override
    public JPAScalarType getScalarType() {
        return this.scalarType;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    public void finish() {
        this.unresolved = null;
    }

    protected void setKeyClass(AbstractMetadataClass keyClass) {
        this.keyClass = (JPAMetadataClassImpl)keyClass;
    }

    protected void setTargetClass(AbstractMetadataClass targetClass) {
        this.targetClass = (JPAMetadataClassImpl)targetClass;
    }

    public void resolveConvarianceProperty() {
        if (this.unresolved.contravarianceFrom == null) {
            return;
        }
        JPAMetadataClassImpl superMetadataClass = (JPAMetadataClassImpl)this.declaringClass.getSuperClass();
        if (superMetadataClass == null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.contraviancePropertyMissSuperClass(this, Contravariance.class));
        }
        JPAMetadataPropertyImpl superProperty = (JPAMetadataPropertyImpl)superMetadataClass.properties.get((Object)this.unresolved.contravarianceFrom);
        if (superProperty == null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.noConvarianceProperty(this, Contravariance.class, this.unresolved.contravarianceFrom, superMetadataClass));
        }
        if (!Objects.equals(this.keyTypeName, superProperty.keyTypeName)) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.diffKeyTypeNameOfConvarianceProperty(this, Contravariance.class, superProperty, this.keyTypeName, superProperty.keyTypeName));
        }
        if (this.targetClass == superProperty.targetClass) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.sameTargetTypeNameOfConvarianceProperty(this, Contravariance.class, superProperty));
        }
        boolean concurrentConvariance = false;
        JPAMetadataClassImpl superClass = this.targetClass.superClass;
        while (superClass != null) {
            if (superClass == superProperty.targetClass) {
                concurrentConvariance = true;
                break;
            }
            superClass = superClass.superClass;
        }
        if (!concurrentConvariance) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.illegalTypeOfContravarianceProperty(this, Contravariance.class, superProperty, this.targetClass, superProperty.targetClass));
        }
        this.convarianceProperty = superProperty;
    }

    public void calculateJoin() {
        if (this.propertyType != PropertyType.ASSOCIATION) {
            return;
        }
        String mappedBy = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)this.unresolved.primaryAnnotationNode, (String)"mappedBy", (Object)"");
        if (mappedBy.isEmpty()) {
            this.unresolved.join = new JPAMetadataJoin(this);
        } else {
            AnnotationNode joinNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, JoinColumn.class);
            if (joinNode == null && (joinNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, JoinColumns.class)) == null) {
                joinNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, JoinTable.class);
            }
            if (joinNode != null) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.explicitJoinCanNotBeMappedBy(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), ASMUtils.toClassName((String)joinNode.desc)));
            }
        }
    }

    public void resolveExplicitBidrectionalAssociations() {
        if (this.oppositeProperty != null || this.propertyType != PropertyType.ASSOCIATION) {
            return;
        }
        String mappedBy = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)this.unresolved.primaryAnnotationNode, (String)"mappedBy", (Object)"");
        if (mappedBy.isEmpty()) {
            return;
        }
        this.inverse = true;
        JPAMetadataPropertyImpl oppositeProperty = (JPAMetadataPropertyImpl)this.targetClass.declaredProperties.get((Object)mappedBy);
        if (oppositeProperty == null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.explicitOppositeProprtyIsNotExisting(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), mappedBy, this.targetClass));
        }
        if (oppositeProperty == this) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.explicitOppositeProprtyCanNotBeSelf(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), mappedBy));
        }
        if (oppositeProperty.declaringClass != this.targetClass) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.declaringClassOfExplicitOppositePropertyShouldBe(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), oppositeProperty, this.targetClass));
        }
        if (oppositeProperty.propertyType != PropertyType.ASSOCIATION) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.explicitOppositePropertyIsNotAssociation(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), mappedBy, oppositeProperty));
        }
        if (oppositeProperty.unresolved.join == null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.explicitOppositePropertySpecifiedMappedBy(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), mappedBy, oppositeProperty, ASMUtils.toClassName((String)oppositeProperty.unresolved.primaryAnnotationNode.desc)));
        }
        this.setOppositeProperty(oppositeProperty);
        oppositeProperty.setOppositeProperty(this);
    }

    public void resolveImplicitBidrectionalAssociations() {
        if (this.oppositeProperty != null || this.propertyType != PropertyType.ASSOCIATION || this.unresolved.join == null) {
            return;
        }
        JPAMetadataPropertyImpl oppositeProperty = null;
        for (JPAMetadataPropertyImpl mayBeOppositeProperty : this.targetClass.propertyList) {
            if (this == mayBeOppositeProperty || !this.unresolved.join.likeBedirectionalAssociation(mayBeOppositeProperty.unresolved.join)) continue;
            if (mayBeOppositeProperty.getDeclaringClass() != this.targetClass) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.declaringClassOfImplicitOppositePropertyShouldBe(this, mayBeOppositeProperty, this.targetClass));
            }
            if (oppositeProperty != null) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.conflictOppositeProperties(this, oppositeProperty, mayBeOppositeProperty));
            }
            oppositeProperty = mayBeOppositeProperty;
        }
        if (oppositeProperty == null) {
            return;
        }
        boolean thisReadonly = this.unresolved.join.isReadonly();
        boolean oppositeReadonly = oppositeProperty.unresolved.join.isReadonly();
        if (thisReadonly) {
            this.inverse = true;
        } else if (oppositeReadonly) {
            oppositeProperty.inverse = true;
        }
        this.setOppositeProperty(oppositeProperty);
        super.setOppositeProperty(this);
    }

    public void resolveIndexPropertyOfOpposite() {
        if (this.oppositeProperty == null || this.unresolved.orderColumn == null) {
            return;
        }
        JPAMetadataPropertyImpl oppositeIndexProperty = null;
        String laxOrderColumnName = DbIdentifiers.laxIdentifier(this.unresolved.orderColumn);
        for (JPAMetadataPropertyImpl mayBeOppositeIndexProperty : this.targetClass.propertyList) {
            String otherColumnName = mayBeOppositeIndexProperty.unresolved.singleColumnName;
            if (otherColumnName == null || !DbIdentifiers.laxIdentifier(otherColumnName).equals(laxOrderColumnName)) continue;
            if (mayBeOppositeIndexProperty.getDeclaringClass() != this.targetClass) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.declaringClassOfOppositeIndexPropertyShouldBe(this, OrderColumn.class, mayBeOppositeIndexProperty, this.targetClass));
            }
            if (oppositeIndexProperty != null) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.conflictOppositeIndexProperties(this, OrderColumn.class, oppositeIndexProperty, mayBeOppositeIndexProperty));
            }
            oppositeIndexProperty = mayBeOppositeIndexProperty;
        }
        String mappedBy = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)this.unresolved.primaryAnnotationNode, (String)"mappedBy", (Object)"");
        if (oppositeIndexProperty != null) {
            if (!this.unresolved.primaryAnnotationNode.desc.equals("Ljavax/persistence/OneToMany;")) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.oneToManyIsRequiredWhenOppositeIndexPropertyIsFound(this, OrderColumn.class, oppositeIndexProperty, OneToMany.class));
            }
            if (mappedBy.isEmpty()) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.mappedByIsRequiredWhenOppositeIndexPropertyIsFound(this, OrderColumn.class, oppositeIndexProperty, OneToMany.class));
            }
            if (!oppositeIndexProperty.getDescriptor().equals("I")) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.typeOfOppositeIndexPropertyShouldBeInteger(this, OrderColumn.class, oppositeIndexProperty));
            }
            this.oppositeProperty.indexProperty = oppositeIndexProperty;
            oppositeIndexProperty.setReferenceProperty(this.oppositeProperty);
        } else if (!mappedBy.isEmpty()) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.mappedByIsForbiddenWhenOppositeIndexPropertyIsNotFound(this, OrderColumn.class, this.targetClass, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc)));
        }
    }

    public void resolveKeyPropertyOfOpposite() {
        if (this.oppositeProperty == null || this.unresolved.mapKeyName == null && this.unresolved.mapKeyColumnName == null) {
            return;
        }
        JPAMetadataPropertyImpl oppositeKeyProperty = null;
        if (this.unresolved.mapKeyName != null) {
            oppositeKeyProperty = (JPAMetadataPropertyImpl)this.targetClass.declaredProperties.get((Object)this.unresolved.mapKeyName);
            if (oppositeKeyProperty == null) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.canNotFindOppositeKeyPropertyByMapKey(this, MapKey.class, this.unresolved.mapKeyName, this.targetClass));
            }
        } else if (this.unresolved.mapKeyColumnName != null) {
            String laxKeyColumnName = DbIdentifiers.laxIdentifier(this.unresolved.mapKeyColumnName);
            for (JPAMetadataPropertyImpl mayBeOppositeKeyProperty : this.targetClass.propertyList) {
                String otherColumnName = mayBeOppositeKeyProperty.unresolved.singleColumnName;
                if (otherColumnName == null || !DbIdentifiers.laxIdentifier(otherColumnName).equals(laxKeyColumnName)) continue;
                if (mayBeOppositeKeyProperty.getDeclaringClass() != this.targetClass) {
                    throw new IllegalClassException(JPAMetadataPropertyImpl.declaringClassOfOppositeKeyPropertyShouldBe(this, MapKeyColumn.class, mayBeOppositeKeyProperty, this.targetClass));
                }
                if (oppositeKeyProperty != null) {
                    throw new IllegalClassException(JPAMetadataPropertyImpl.conflictOppositeKeyProperties(this, MapKeyColumn.class, oppositeKeyProperty, mayBeOppositeKeyProperty));
                }
                oppositeKeyProperty = mayBeOppositeKeyProperty;
            }
        }
        String mappedBy = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)this.unresolved.primaryAnnotationNode, (String)"mappedBy", (Object)"");
        if (oppositeKeyProperty != null) {
            if (!this.unresolved.primaryAnnotationNode.desc.equals("Ljavax/persistence/OneToMany;")) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.oneToManyIsRequiredWhenOppositeKeyPropertyIsFound(this, this.unresolved.mapKeyName != null ? MapKey.class : MapKeyColumn.class, oppositeKeyProperty, OneToMany.class));
            }
            if (mappedBy.isEmpty()) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.mappedByIsRequiredWhenOppositeKeyPropertyIsFound(this, this.unresolved.mapKeyName != null ? MapKey.class : MapKeyColumn.class, oppositeKeyProperty, OneToMany.class));
            }
            if (!this.keyDescriptor.equals(oppositeKeyProperty.getDescriptor())) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.typeOfOppositeKeyPropertyShouldBe(this, this.unresolved.mapKeyName != null ? MapKey.class : MapKeyColumn.class, oppositeKeyProperty, ASMUtils.toClassName((String)this.keyDescriptor)));
            }
            this.oppositeProperty.keyProperty = oppositeKeyProperty;
            oppositeKeyProperty.setReferenceProperty(this.oppositeProperty);
        } else if (!mappedBy.isEmpty()) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.mappedByIsForbiddenWhenOppositeKeyPropertyIsNotFound(this, MapKeyColumn.class, this.targetClass, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc)));
        }
    }

    public void resolveStateAfterAssociationResolved() {
        if (this.propertyType == PropertyType.ASSOCIATION) {
            if (this.oppositeProperty != null) {
                if (this.inverse && this.oppositeProperty.inverse) {
                    throw new IllegalClassException(JPAMetadataPropertyImpl.oppositePropertyShouldNotBeInverse(this, Association.class, this.oppositeProperty));
                }
                if (!this.inverse && !this.oppositeProperty.inverse) {
                    throw new IllegalClassException(JPAMetadataPropertyImpl.oppositePropertyShouldBeInverse(this, Association.class, this.oppositeProperty));
                }
            }
            this.associationType = this.standardCollectionType == null ? (this.indexProperty != null ? AssociationType.INDEXED_REFERENCE : (this.keyProperty != null ? AssociationType.KEYED_REFERENCE : AssociationType.REFERENCE)) : (this.isCollection(List.class) ? AssociationType.LIST : (this.isCollection(Map.class) ? AssociationType.MAP : AssociationType.COLLECTION));
        } else if (this.referenceProperty != null) {
            if (this.propertyType != null) {
                throw new AssertionError((Object)"Internal bug");
            }
            this.propertyType = this.referenceProperty.indexProperty == this ? PropertyType.INDEX : PropertyType.KEY;
        }
        if (this.propertyType == null) {
            this.propertyType = PropertyType.SCALAR;
        }
        if (this.associationType == null) {
            this.associationType = AssociationType.NONE;
        }
        if (this.scalarType == null) {
            this.scalarType = this.propertyType == PropertyType.SCALAR ? JPAScalarType.GENERAL : JPAScalarType.NONE;
        }
        switch (this.unresolved.primaryAnnotationNode.desc) {
            case "Ljavax/persistence/ManyToMany;": 
            case "Ljavax/persistence/OneToMany;": {
                if (ASMTreeUtils.getAnnotationEnumValue(FetchType.class, (AnnotationNode)this.unresolved.primaryAnnotationNode, (String)"fetch") == FetchType.EAGER) break;
                this.deferrable = true;
                break;
            }
            case "Ljavax/persistence/ManyToOne;": 
            case "Ljavax/persistence/OneToOne;": 
            case "Ljavax/persistence/Basic;": {
                if (ASMTreeUtils.getAnnotationEnumValue(FetchType.class, (AnnotationNode)this.unresolved.primaryAnnotationNode, (String)"fetch") != FetchType.LAZY) break;
                this.deferrable = true;
            }
        }
        AnnotationNode indexOfNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, IndexOf.class);
        if (indexOfNode != null) {
            if (this.propertyType != PropertyType.INDEX) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.requireIndexOrKeyAnnotation(this, this.referenceProperty, IndexOf.class));
            }
            String value = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)indexOfNode, (String)"value");
            if (!this.referenceProperty.getName().equals(value)) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.illegalIndexOrKeyAnnotationValue(this, this.referenceProperty, IndexOf.class, this.referenceProperty.getName()));
            }
            this.absolute = (Boolean)ASMTreeUtils.getAnnotationValue((AnnotationNode)indexOfNode, (String)"absolute", (Object)false);
        } else if (this.propertyType == PropertyType.INDEX) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.unexpectedIndexOrKeyAnnotation(this, IndexOf.class));
        }
        AnnotationNode keyOfNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, KeyOf.class);
        if (keyOfNode != null) {
            if (this.propertyType != PropertyType.KEY) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.requireIndexOrKeyAnnotation(this, this.referenceProperty, KeyOf.class));
            }
            String value = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)keyOfNode, (String)"value");
            if (!this.referenceProperty.getName().equals(value)) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.illegalIndexOrKeyAnnotationValue(this, this.referenceProperty, KeyOf.class, this.referenceProperty.getName()));
            }
            this.absolute = (Boolean)ASMTreeUtils.getAnnotationValue((AnnotationNode)keyOfNode, (String)"absolute", (Object)false);
        } else if (this.propertyType == PropertyType.KEY) {
            System.err.println(">>>> miss @KeyOf: " + this.declaringClass.getName());
            throw new IllegalClassException(JPAMetadataPropertyImpl.unexpectedIndexOrKeyAnnotation(this, KeyOf.class));
        }
    }

    public void resolveComparatorParts(ObjectModel4JPAInstrumenter instrumenter) {
        this.comparatorParts = this.determineComparatorParts(this.unresolved.fieldNode, instrumenter);
    }

    private void determinePrimaryAnnoataion() {
        FieldNode fieldNode = this.unresolved.fieldNode;
        if (fieldNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.visibleAnnotations) {
                switch (annotationNode.desc) {
                    case "Ljavax/persistence/ManyToMany;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        this.propertyType = PropertyType.ASSOCIATION;
                        break;
                    }
                    case "Ljavax/persistence/OneToMany;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        this.propertyType = PropertyType.ASSOCIATION;
                        break;
                    }
                    case "Ljavax/persistence/ManyToOne;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        this.propertyType = PropertyType.ASSOCIATION;
                        break;
                    }
                    case "Ljavax/persistence/OneToOne;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        this.propertyType = PropertyType.ASSOCIATION;
                        break;
                    }
                    case "Ljavax/persistence/Embedded;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        break;
                    }
                    case "Ljavax/persistence/Basic;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        break;
                    }
                    case "Ljavax/persistence/Id;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        this.propertyType = PropertyType.SCALAR;
                        this.scalarType = JPAScalarType.ID;
                        break;
                    }
                    case "Ljavax/persistence/Version;": {
                        this.setPrimaryAnnotationNode(annotationNode);
                        this.propertyType = PropertyType.SCALAR;
                        this.scalarType = JPAScalarType.VERSION;
                        break;
                    }
                }
            }
        }
        if (fieldNode.invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.invisibleAnnotations) {
                if ("Lorg/babyfish/model/Contravariance;".equals(annotationNode.desc)) {
                    this.setPrimaryAnnotationNode(annotationNode);
                    this.propertyType = PropertyType.CONTRAVARIANCE;
                    if (ASMTreeUtils.getAnnotationNode((Object)fieldNode, Transient.class) == null) {
                        throw new IllegalClassException(JPAMetadataPropertyImpl.contravariancePropertyMustBeTransient(this, Contravariance.class, Transient.class));
                    }
                    this.unresolved.contravarianceFrom = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)annotationNode, (String)"from", (Object)fieldNode.name);
                }
                if (!"Lorg/babyfish/model/ComparatorRule;".equals(annotationNode.desc) || this.unresolved.contravarianceFrom == null) continue;
                throw new IllegalClassException(JPAMetadataPropertyImpl.conflictAnnotations(this, Contravariance.class.getName(), ComparatorRule.class.getName()));
            }
        }
        if (this.unresolved.primaryAnnotationNode == null) {
            this.setPrimaryAnnotationNode(DEFAULT_BASIC_ANNOTATION_NODE);
        }
    }

    private void setPrimaryAnnotationNode(AnnotationNode primaryAnnotationNode) {
        if (this.unresolved.primaryAnnotationNode != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.conflictAnnotations(this, ASMUtils.toClassName((String)this.unresolved.primaryAnnotationNode.desc), ASMUtils.toClassName((String)primaryAnnotationNode.desc)));
        }
        if (this.propertyType == PropertyType.ASSOCIATION && ASMTreeUtils.getAnnotationValue((AnnotationNode)primaryAnnotationNode, (String)"targetEntity") != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.targetEntityCanNotBeSpecified(this, ASMUtils.toClassName((String)primaryAnnotationNode.desc), this.declaringClass, JPAModel.class));
        }
        switch (primaryAnnotationNode.desc) {
            case "Ljavax/persistence/OneToMany;": 
            case "Ljavax/persistence/ManyToMany;": {
                if (this.standardCollectionType != null) break;
                throw new IllegalClassException(JPAMetadataPropertyImpl.requireCollectionField(this, ASMUtils.toClassName((String)primaryAnnotationNode.desc)));
            }
            case "Lorg/babyfish/model/Contravariance;": {
                break;
            }
            default: {
                if (this.standardCollectionType == null) break;
                throw new IllegalClassException(JPAMetadataPropertyImpl.requireNonCollectionField(this, ASMUtils.toClassName((String)primaryAnnotationNode.desc)));
            }
        }
        if (ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, PrimaryKeyJoinColumn.class) != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.unsupportedAnnoatation(this, PrimaryKeyJoinColumn.class));
        }
        if (ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, PrimaryKeyJoinColumns.class) != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.unsupportedAnnoatation(this, PrimaryKeyJoinColumns.class));
        }
        AnnotationNode orderColumnAnnotationNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, OrderColumn.class);
        if (orderColumnAnnotationNode != null) {
            if (primaryAnnotationNode.desc.equals("Lorg/babyfish/model/Contravariance;")) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.conflictAnnotations(this, OrderColumn.class.getName(), Contravariance.class.getName()));
            }
            if (!this.isCollection(List.class)) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.annotationRequireFieldType(this, OrderColumn.class, List.class));
            }
            String orderColumn = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)orderColumnAnnotationNode, (String)"name", (Object)"");
            if (orderColumn.isEmpty()) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.annotationArgumentCanNotBeEmpty(this, OrderColumn.class, "name"));
            }
            if (primaryAnnotationNode.desc.equals("Ljavax/persistence/OneToMany;")) {
                this.unresolved.orderColumn = orderColumn;
            }
        } else if (this.isCollection(List.class) && !primaryAnnotationNode.desc.equals("Lorg/babyfish/model/Contravariance;")) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.fieldTypeRequireAnnotation(this, List.class, OrderColumn.class, Contravariance.class));
        }
        AnnotationNode mapKeyAnnotationNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, MapKey.class);
        AnnotationNode mapKeyColumnAnnotationNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, MapKeyColumn.class);
        if (mapKeyAnnotationNode != null) {
            if (primaryAnnotationNode.desc.equals("Lorg/babyfish/model/Contravariance;")) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.conflictAnnotations(this, MapKey.class.getName(), Contravariance.class.getName()));
            }
            if (!this.isCollection(Map.class)) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.annotationRequireFieldType(this, MapKey.class, Map.class));
            }
            if (!primaryAnnotationNode.desc.equals("Ljavax/persistence/OneToMany;")) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.mapKeyRequireOneToMany(this, MapKey.class, OneToMany.class));
            }
            this.unresolved.mapKeyName = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)mapKeyAnnotationNode, (String)"name", (Object)"");
            if (this.unresolved.mapKeyName.isEmpty()) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.annotationArgumentCanNotBeEmpty(this, MapKey.class, "name"));
            }
        }
        if (mapKeyColumnAnnotationNode != null) {
            if (!this.isCollection(Map.class)) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.annotationRequireFieldType(this, MapKeyColumn.class, Map.class));
            }
            String mapKeyColumnName = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)mapKeyColumnAnnotationNode, (String)"name", (Object)"");
            if (mapKeyColumnName.isEmpty()) {
                throw new IllegalClassException(JPAMetadataPropertyImpl.annotationArgumentCanNotBeEmpty(this, MapKeyColumn.class, "name"));
            }
            this.unresolved.mapKeyColumnName = mapKeyColumnName;
        }
        if (mapKeyAnnotationNode != null && mapKeyColumnAnnotationNode != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.conflictAnnotations(this, MapKey.class.getName(), MapKeyColumn.class.getName()));
        }
        if (mapKeyAnnotationNode == null && mapKeyColumnAnnotationNode == null && this.isCollection(Map.class)) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.fieldTypeRequireAnnotation(this, Map.class, MapKey.class, MapKeyColumn.class, Contravariance.class));
        }
        if (primaryAnnotationNode.desc.equals("Ljavax/persistence/Basic;") || primaryAnnotationNode.desc.equals("Ljavax/persistence/Id;") || primaryAnnotationNode.desc.equals("Ljavax/persistence/Version;")) {
            AnnotationNode columnNode = ASMTreeUtils.getAnnotationNode((Object)this.unresolved.fieldNode, Column.class);
            String columnName = "";
            if (columnNode != null) {
                columnName = (String)ASMTreeUtils.getAnnotationValue((AnnotationNode)columnNode, (String)"name", (Object)"");
            }
            if (columnName.isEmpty()) {
                columnName = this.name;
            }
            this.unresolved.singleColumnName = columnName;
        }
        this.unresolved.primaryAnnotationNode = primaryAnnotationNode;
    }

    private void setOppositeProperty(JPAMetadataPropertyImpl oppositeProperty) {
        if (this.oppositeProperty != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.conflictOppositeProperties(this, this.oppositeProperty, oppositeProperty));
        }
        this.oppositeProperty = oppositeProperty;
    }

    private void setReferenceProperty(JPAMetadataPropertyImpl referenceProperty) {
        if (this.referenceProperty != null) {
            throw new IllegalClassException(JPAMetadataPropertyImpl.referencePropertyHasBeenUsed(this, this.referenceProperty, this.referenceProperty.indexProperty != null ? this.referenceProperty.indexProperty : this.referenceProperty.keyProperty));
        }
        this.referenceProperty = referenceProperty;
    }

    private boolean isCollection(Class<?> collectionType) {
        if (this.standardCollectionType == null) {
            return false;
        }
        return collectionType.isAssignableFrom(this.standardCollectionType);
    }

    private static String conflictAnnotations(JPAMetadataPropertyImpl arg0, String arg1, String arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("conflictAnnotations").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String contravariancePropertyMustBeTransient(JPAMetadataPropertyImpl arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("contravariancePropertyMustBeTransient").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String targetEntityCanNotBeSpecified(JPAMetadataPropertyImpl arg0, String arg1, AbstractMetadataClass arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("targetEntityCanNotBeSpecified").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String requireCollectionField(JPAMetadataPropertyImpl arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("requireCollectionField").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String requireNonCollectionField(JPAMetadataPropertyImpl arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("requireNonCollectionField").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String explicitJoinCanNotBeMappedBy(JPAMetadataPropertyImpl arg0, String arg1, String arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("explicitJoinCanNotBeMappedBy").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String explicitOppositeProprtyIsNotExisting(JPAMetadataPropertyImpl arg0, String arg1, String arg2, JPAMetadataClassImpl arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("explicitOppositeProprtyIsNotExisting").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String explicitOppositeProprtyCanNotBeSelf(JPAMetadataPropertyImpl arg0, String arg1, String arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("explicitOppositeProprtyCanNotBeSelf").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String declaringClassOfExplicitOppositePropertyShouldBe(JPAMetadataPropertyImpl arg0, String arg1, JPAMetadataPropertyImpl arg2, MetadataClass arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("declaringClassOfExplicitOppositePropertyShouldBe").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String explicitOppositePropertyIsNotAssociation(JPAMetadataPropertyImpl arg0, String arg1, String arg2, JPAMetadataPropertyImpl arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("explicitOppositePropertyIsNotAssociation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String explicitOppositePropertySpecifiedMappedBy(JPAMetadataPropertyImpl arg0, String arg1, String arg2, JPAMetadataPropertyImpl arg3, String arg4) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("explicitOppositePropertySpecifiedMappedBy").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3)).replace("{4}", I18NUtils.toString((Object)arg4));
    }

    private static String contraviancePropertyMissSuperClass(JPAMetadataPropertyImpl arg0, Class arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("contraviancePropertyMissSuperClass").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String noConvarianceProperty(JPAMetadataPropertyImpl arg0, Class arg1, String arg2, MetadataClass arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("noConvarianceProperty").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String diffKeyTypeNameOfConvarianceProperty(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, String arg3, String arg4) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("diffKeyTypeNameOfConvarianceProperty").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3)).replace("{4}", I18NUtils.toString((Object)arg4));
    }

    private static String sameTargetTypeNameOfConvarianceProperty(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("sameTargetTypeNameOfConvarianceProperty").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String illegalTypeOfContravarianceProperty(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, MetadataClass arg3, MetadataClass arg4) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("illegalTypeOfContravarianceProperty").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3)).replace("{4}", I18NUtils.toString((Object)arg4));
    }

    private static String declaringClassOfImplicitOppositePropertyShouldBe(JPAMetadataPropertyImpl arg0, JPAMetadataPropertyImpl arg1, MetadataClass arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("declaringClassOfImplicitOppositePropertyShouldBe").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String conflictOppositeProperties(JPAMetadataPropertyImpl arg0, JPAMetadataPropertyImpl arg1, JPAMetadataPropertyImpl arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("conflictOppositeProperties").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String declaringClassOfOppositeIndexPropertyShouldBe(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, MetadataClass arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("declaringClassOfOppositeIndexPropertyShouldBe").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String conflictOppositeIndexProperties(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, JPAMetadataPropertyImpl arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("conflictOppositeIndexProperties").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String oneToManyIsRequiredWhenOppositeIndexPropertyIsFound(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("oneToManyIsRequiredWhenOppositeIndexPropertyIsFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String mappedByIsRequiredWhenOppositeIndexPropertyIsFound(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("mappedByIsRequiredWhenOppositeIndexPropertyIsFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String typeOfOppositeIndexPropertyShouldBeInteger(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("typeOfOppositeIndexPropertyShouldBeInteger").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String mappedByIsForbiddenWhenOppositeIndexPropertyIsNotFound(JPAMetadataPropertyImpl arg0, Class arg1, MetadataClass arg2, String arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("mappedByIsForbiddenWhenOppositeIndexPropertyIsNotFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String canNotFindOppositeKeyPropertyByMapKey(JPAMetadataPropertyImpl arg0, Class arg1, String arg2, MetadataClass arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("canNotFindOppositeKeyPropertyByMapKey").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String declaringClassOfOppositeKeyPropertyShouldBe(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, MetadataClass arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("declaringClassOfOppositeKeyPropertyShouldBe").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String conflictOppositeKeyProperties(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, JPAMetadataPropertyImpl arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("conflictOppositeKeyProperties").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String oneToManyIsRequiredWhenOppositeKeyPropertyIsFound(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("oneToManyIsRequiredWhenOppositeKeyPropertyIsFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String mappedByIsRequiredWhenOppositeKeyPropertyIsFound(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, Class arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("mappedByIsRequiredWhenOppositeKeyPropertyIsFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String typeOfOppositeKeyPropertyShouldBe(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2, String arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("typeOfOppositeKeyPropertyShouldBe").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String mappedByIsForbiddenWhenOppositeKeyPropertyIsNotFound(JPAMetadataPropertyImpl arg0, Class arg1, MetadataClass arg2, String arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("mappedByIsForbiddenWhenOppositeKeyPropertyIsNotFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String oppositePropertyShouldBeInverse(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("oppositePropertyShouldBeInverse").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String oppositePropertyShouldNotBeInverse(JPAMetadataPropertyImpl arg0, Class arg1, JPAMetadataPropertyImpl arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("oppositePropertyShouldNotBeInverse").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String requireIndexOrKeyAnnotation(JPAMetadataPropertyImpl arg0, JPAMetadataPropertyImpl arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("requireIndexOrKeyAnnotation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String illegalIndexOrKeyAnnotationValue(JPAMetadataPropertyImpl arg0, JPAMetadataPropertyImpl arg1, Class arg2, String arg3) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("illegalIndexOrKeyAnnotationValue").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2)).replace("{3}", I18NUtils.toString((Object)arg3));
    }

    private static String unexpectedIndexOrKeyAnnotation(JPAMetadataPropertyImpl arg0, Class arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("unexpectedIndexOrKeyAnnotation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String unsupportedAnnoatation(JPAMetadataPropertyImpl arg0, Class arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("unsupportedAnnoatation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String mapKeyRequireOneToMany(JPAMetadataPropertyImpl arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("mapKeyRequireOneToMany").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String annotationRequireFieldType(JPAMetadataPropertyImpl arg0, Class arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("annotationRequireFieldType").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String fieldTypeRequireAnnotation(JPAMetadataPropertyImpl arg0, Class arg1, Class ... arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("fieldTypeRequireAnnotation").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String annotationArgumentCanNotBeEmpty(JPAMetadataPropertyImpl arg0, Class arg1, String arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("annotationArgumentCanNotBeEmpty").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String referencePropertyHasBeenUsed(JPAMetadataPropertyImpl arg0, JPAMetadataPropertyImpl arg1, JPAMetadataPropertyImpl arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/JPAMetadataPropertyImpl");
        }
        return {resourceBundle}.getString("referencePropertyHasBeenUsed").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    static {
        DEFAULT_BASIC_ANNOTATION_NODE = new AnnotationNode(327680, "Ljavax/persistence/Basic;");
    }

    static class Unresolved {
        FieldNode fieldNode;
        AnnotationNode primaryAnnotationNode;
        String contravarianceFrom;
        String singleColumnName;
        JPAMetadataJoin join;
        String orderColumn;
        String mapKeyName;
        String mapKeyColumnName;

        Unresolved() {
        }
    }
}

