/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.instrument.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import org.babyfish.lang.Nulls;
import org.babyfish.lang.UncheckedException;
import org.babyfish.lang.instrument.IllegalClassException;
import org.babyfish.lang.internal.I18NUtils;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.model.instrument.metadata.spi.AbstractMetadataClass;
import org.babyfish.model.instrument.metadata.spi.ClassProcessor;
import org.babyfish.model.instrument.metadata.spi.Processor;
import org.babyfish.model.instrument.metadata.spi.PropertyProcessor;
import org.babyfish.model.instrument.spi.AbstractObjectModelInstrumenter;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataClassImpl;
import org.babyfish.model.jpa.instrument.impl.JPAMetadataPropertyImpl;
import org.babyfish.model.jpa.instrument.spi.AbstractObjectModel4JPAReplacer;
import org.babyfish.org.objectweb.asm.tree.ClassNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instrumented
public class ObjectModel4JPAInstrumenter
extends AbstractObjectModelInstrumenter {
    private static ResourceBundle {resourceBundle};
    private static final String CONFIGURATION_LOCATION = "META-INF/ObjectModel4JPA.properties";
    private static final Constructor<?> REPLACER_CONSTRUCTOR;

    protected AbstractMetadataClass createMetadataClass(File classFile, ClassNode classNode) {
        return new JPAMetadataClassImpl(classFile, classNode);
    }

    public AbstractObjectModel4JPAReplacer createReplacer(String className, File classFile) {
        try {
            return (AbstractObjectModel4JPAReplacer)((Object)REPLACER_CONSTRUCTOR.newInstance(new Object[]{this, className, classFile}));
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new AssertionError("Internal bug", ex);
        }
        catch (InvocationTargetException ex) {
            throw UncheckedException.rethrow((Throwable)ex.getTargetException());
        }
    }

    protected Processor[] getProcessors() {
        final ObjectModel4JPAInstrumenter that = this;
        return new Processor[]{new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveClass(that);
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolveSuperClass(that);
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolveAncestorClass();
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolveProperties();
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolvePropertyList();
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolveIdProperty();
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolveVersionProperty();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveConvarianceProperty();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.calculateJoin();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveExplicitBidrectionalAssociations();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveImplicitBidrectionalAssociations();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveIndexPropertyOfOpposite();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveKeyPropertyOfOpposite();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveStateAfterAssociationResolved();
            }
        }, new ClassProcessor<JPAMetadataClassImpl>(){

            public void processClass(JPAMetadataClassImpl c) {
                c.resolveComparatorParts();
            }
        }, new PropertyProcessor<JPAMetadataPropertyImpl>(){

            public void processProperty(JPAMetadataPropertyImpl p) {
                p.resolveComparatorParts(that);
            }
        }};
    }

    private static String findObjectModel4JPAConfigurationFailed(String arg0) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("findObjectModel4JPAConfigurationFailed").replace("{0}", I18NUtils.toString((Object)arg0));
    }

    private static String conflicitObjectModel4JPAConfigurations(URL arg0, URL arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("conflicitObjectModel4JPAConfigurations").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String noObjectModel4JPAConfiguration(String arg0) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("noObjectModel4JPAConfiguration").replace("{0}", I18NUtils.toString((Object)arg0));
    }

    private static String readObjectModel4JPAConfigurationFailed(URL arg0) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("readObjectModel4JPAConfigurationFailed").replace("{0}", I18NUtils.toString((Object)arg0));
    }

    private static String modelReplacerIsNotConfigured(URL arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerIsNotConfigured").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String modelReplacerClassIsNotFound(URL arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerClassIsNotFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String modelReplacerClassMustBePublic(URL arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerClassMustBePublic").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String modelReplacerClassMustNotBeAbstract(URL arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerClassMustNotBeAbstract").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String modelReplacerClassIsNotDerivedTypeOf(URL arg0, String arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerClassIsNotDerivedTypeOf").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String modelReplacerConstructorIsNotFound(URL arg0, String arg1, Class[] arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerConstructorIsNotFound").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    private static String modelReplacerConstructorIsNotPublic(URL arg0, String arg1, Class[] arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/instrument/impl/ObjectModel4JPAInstrumenter");
        }
        return {resourceBundle}.getString("modelReplacerConstructorIsNotPublic").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }

    static {
        Constructor<?> constructor;
        Class<?> clazz;
        Enumeration<URL> configurationFiles;
        try {
            configurationFiles = ObjectModel4JPAInstrumenter.class.getClassLoader().getResources(CONFIGURATION_LOCATION);
        }
        catch (IOException ex) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.findObjectModel4JPAConfigurationFailed(CONFIGURATION_LOCATION), (Throwable)ex);
        }
        URL configurationFile = null;
        while (configurationFiles.hasMoreElements()) {
            URL url = configurationFiles.nextElement();
            if (configurationFile != null) {
                throw new IllegalClassException(ObjectModel4JPAInstrumenter.conflicitObjectModel4JPAConfigurations(configurationFile, url));
            }
            configurationFile = url;
        }
        if (configurationFile == null) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.noObjectModel4JPAConfiguration(CONFIGURATION_LOCATION));
        }
        Properties properties = new Properties();
        try (InputStream inputStream = configurationFile.openStream();){
            properties.load(inputStream);
        }
        catch (IOException ex) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.readObjectModel4JPAConfigurationFailed(configurationFile), (Throwable)ex);
        }
        String className = properties.getProperty("modelReplacer");
        if (Nulls.isNullOrEmpty((String)className)) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerIsNotConfigured(configurationFile, "modelReplacer"));
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerClassIsNotFound(configurationFile, className), (Throwable)ex);
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerClassMustBePublic(configurationFile, className));
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerClassMustNotBeAbstract(configurationFile, className));
        }
        if (!AbstractObjectModel4JPAReplacer.class.isAssignableFrom(clazz)) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerClassIsNotDerivedTypeOf(configurationFile, className, AbstractObjectModel4JPAReplacer.class));
        }
        try {
            constructor = clazz.getDeclaredConstructor(ObjectModel4JPAInstrumenter.class, String.class, File.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerConstructorIsNotFound(configurationFile, className, new Class[]{ObjectModel4JPAInstrumenter.class, String.class, File.class}), (Throwable)ex);
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new IllegalClassException(ObjectModel4JPAInstrumenter.modelReplacerConstructorIsNotPublic(configurationFile, className, new Class[]{ObjectModel4JPAInstrumenter.class, String.class, File.class}));
        }
        REPLACER_CONSTRUCTOR = constructor;
    }
}

