/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source;

public class CodeBuilder {
    private static final String LINE_SPERATOR = System.getProperty("line.separator", "\n");
    private boolean newLine;
    private int tabCount;
    private StringBuilder builder = new StringBuilder();

    public CodeBuilder(int tabCount) {
        this.tabCount = tabCount;
        this.newLine = true;
    }

    public CodeBuilder append(String code) {
        this.appendTabsIfNecessary();
        this.builder.append(code);
        return this;
    }

    public CodeBuilder appendLine(String code) {
        this.append(code);
        return this.appendLine();
    }

    public CodeBuilder appendLine() {
        this.builder.append(LINE_SPERATOR);
        this.newLine = true;
        return this;
    }

    public CodeBuilder appendBeginBlock() {
        return this.appendBeginBlock(" {");
    }

    public CodeBuilder appendBeginBlock(String beginText) {
        if (beginText != null) {
            this.append(beginText);
        }
        this.appendLine();
        ++this.tabCount;
        return this;
    }

    public CodeBuilder appendEndBlock() {
        return this.appendEndBlock(true, "}");
    }

    public CodeBuilder appendEndBlock(boolean newLine) {
        return this.appendEndBlock(newLine, "}");
    }

    public CodeBuilder appendEndBlock(String endText) {
        return this.appendEndBlock(true, endText);
    }

    public CodeBuilder appendEndBlock(boolean newLine, String endText) {
        --this.tabCount;
        if (endText != null) {
            this.append(endText);
        }
        if (newLine) {
            this.appendLine();
        }
        return this;
    }

    private CodeBuilder appendTabsIfNecessary() {
        if (this.newLine) {
            this.newLine = false;
            for (int i = this.tabCount - 1; i >= 0; --i) {
                this.builder.append('\t');
            }
        }
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }
}

