/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.babyfish.model.jpa.source.SimpleAnnotationValueVisitor;

public class ElementHelper {
    @SafeVarargs
    public static boolean containsAnyAnnotation(Element element, Class<? extends Annotation> ... annotationTypes) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                if (annotationType == null || !annotationType.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getAnnotationValue(Element element, Class<? extends Annotation> annotationType, String parameterName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationType.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals(parameterName)) continue;
                return entry.getValue().accept(new SimpleAnnotationValueVisitor(), null);
            }
        }
        return null;
    }

    public static <E extends Enum<E>> E getAnnotationEnumValue(Element element, Class<? extends Annotation> annotationType, String parameterName, Class<E> enumType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationType.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals(parameterName)) continue;
                return Enum.valueOf(enumType, (String)entry.getValue().accept(new SimpleAnnotationValueVisitor(), null));
            }
        }
        return null;
    }

    private ElementHelper() {
    }
}

