/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Generated;
import org.babyfish.collection.HashMap;
import org.babyfish.collection.TreeMap;
import org.babyfish.collection.TreeSet;
import org.babyfish.lang.Nulls;
import org.babyfish.model.jpa.path.CollectionFetchType;
import org.babyfish.model.jpa.path.FetchPath;
import org.babyfish.model.jpa.path.FetchPathWrapper;
import org.babyfish.model.jpa.path.GetterType;
import org.babyfish.model.jpa.path.QueryPath;
import org.babyfish.model.jpa.path.QueryPaths;
import org.babyfish.model.jpa.path.SimpleOrderPath;
import org.babyfish.model.jpa.path.SimpleOrderPathWrapper;
import org.babyfish.model.jpa.path.TypedFetchPath;
import org.babyfish.model.jpa.path.TypedQueryPath;
import org.babyfish.model.jpa.path.TypedSimpleOrderPath;
import org.babyfish.model.jpa.source.BlockScope;
import org.babyfish.model.jpa.source.CodeBuilder;
import org.babyfish.model.jpa.source.TypedQueryPathProcessor;
import org.babyfish.model.jpa.source.metadata.MetadataAssociation;
import org.babyfish.model.jpa.source.metadata.MetadataClass;
import org.babyfish.model.jpa.source.metadata.MetadataProperty;
import org.babyfish.model.jpa.source.metadata.MetadataScalar;

class SourceGenerator {
    static final String NAME_POSTFIX = "__";
    private static final String LINE_SPERATOR = System.getProperty("line.separator", "\n");
    private MetadataClass metadataClass;
    private Map<String, MetadataClass> samePackageMetadataClassMap;
    private Map<String, String> importMap = new HashMap();

    SourceGenerator(MetadataClass metadataClass, Collection<MetadataClass> allMetadataClasses) {
        this.metadataClass = metadataClass;
        HashMap spMetadataClassMap = new HashMap();
        for (MetadataClass mc : allMetadataClasses) {
            if (!Nulls.equals((Object)metadataClass.getPackageName(), (Object)mc.getPackageName())) continue;
            spMetadataClassMap.put(mc.getSimpleName(), mc);
        }
        this.samePackageMetadataClassMap = spMetadataClassMap;
        this.importClasses();
    }

    public void generate(Writer writer) throws IOException {
        writer.write("package ");
        writer.write(this.metadataClass.getPackageName());
        writer.write(";");
        writer.write(LINE_SPERATOR);
        writer.write(LINE_SPERATOR);
        this.generateImports(writer);
        writer.write("@Generated(\"");
        writer.write(TypedQueryPathProcessor.class.getName());
        writer.write("\")");
        writer.write(LINE_SPERATOR);
        writer.write("public abstract class ");
        writer.write(this.metadataClass.getSimpleName());
        writer.write(NAME_POSTFIX);
        if (this.metadataClass.isEntity()) {
            writer.write(" implements ");
            String typedQueryPathName = this.getRenderName(TypedQueryPath.class);
            writer.write(typedQueryPathName);
            writer.write("<");
            writer.write(this.metadataClass.getSimpleName());
            writer.write(">");
        }
        writer.write(" {");
        writer.write(LINE_SPERATOR);
        if (this.metadataClass.isEntity()) {
            this.generateSerialVersionUID(writer, 0, 1);
        }
        CodeBuilder builder = new CodeBuilder(1);
        if (this.metadataClass.isEntity()) {
            this.generateMembers(builder);
            this.generateFetchPathImpl(builder);
            this.generateSimpleOrderPathImpl(builder);
            this.generateFetchPathBuilderImpl(builder);
        }
        this.generateSimpleOrderPathBuilderImpl(builder);
        writer.write(builder.toString());
        writer.write("}");
        writer.write(LINE_SPERATOR);
    }

    private void generateImports(Writer writer) throws IOException {
        TreeSet javaClasses = new TreeSet();
        TreeSet javaXClasses = new TreeSet();
        TreeMap otherClassMap = new TreeMap();
        for (String importedClass : this.importMap.values()) {
            if (importedClass.startsWith("java.")) {
                javaClasses.add(importedClass);
                continue;
            }
            if (importedClass.startsWith("javax.")) {
                javaXClasses.add(importedClass);
                continue;
            }
            int index = importedClass.indexOf(46);
            String prefix = importedClass.substring(0, index);
            NavigableSet set = (NavigableSet)otherClassMap.get(prefix);
            if (set == null) {
                set = new TreeSet();
                otherClassMap.put(prefix, set);
            }
            set.add(importedClass);
        }
        this.generateImports(writer, (Set<String>)javaClasses);
        this.generateImports(writer, (Set<String>)javaXClasses);
        for (NavigableSet classes : otherClassMap.values()) {
            this.generateImports(writer, classes);
        }
    }

    private void generateImports(Writer writer, Set<String> importedClasses) throws IOException {
        if (!importedClasses.isEmpty()) {
            for (String importedClass : importedClasses) {
                writer.write("import ");
                writer.write(importedClass);
                writer.write(59);
                writer.write(LINE_SPERATOR);
            }
            writer.write(LINE_SPERATOR);
        }
    }

    private long getSerialVersionUID(String nestedSimpleClassName) throws IOException {
        long serialVersionUID = nestedSimpleClassName != null ? (long)nestedSimpleClassName.hashCode() : 0L;
        for (MetadataProperty property : this.metadataClass.getProperties().values()) {
            serialVersionUID += serialVersionUID * 31L + (long)property.getName().hashCode();
        }
        return serialVersionUID;
    }

    private void generateSerialVersionUID(Writer writer, int shift, int tabCount) throws IOException {
        long serialVersionUID = 0L;
        for (MetadataScalar scalar : this.metadataClass.getScalars().values()) {
            serialVersionUID += (long)scalar.getName().hashCode();
        }
        for (MetadataAssociation association : this.metadataClass.getAssociations().values()) {
            serialVersionUID += (long)association.getName().hashCode() << 32 | (long)association.getRelatedMetadataClass().getName().hashCode();
        }
        serialVersionUID <<= shift;
        writer.write(LINE_SPERATOR);
        for (int i = tabCount - 1; i >= 0; --i) {
            writer.write(9);
        }
        writer.write("private static final long serialVersionUID = ");
        writer.write(Long.toString(serialVersionUID));
        writer.write("L;");
        writer.write(LINE_SPERATOR);
    }

    private void generateMembers(CodeBuilder builder) throws IOException {
        BlockScope parameterBlock2;
        Throwable throwable;
        String entityName = this.metadataClass.getSimpleName();
        String fetchPathName = this.getRenderName(FetchPath.class);
        String simpleOrderPathName = this.getRenderName(SimpleOrderPath.class);
        String queryPathsName = this.getRenderName(QueryPaths.class);
        String functionName = this.getRenderName(Function.class);
        String biFunctionName = this.getRenderName(BiFunction.class);
        builder.appendLine().append("private static final ").append(functionName).append("<").append(fetchPathName).append(".Builder, FetchPathImpl> FETCH_PATH_CREATOR =").appendBeginBlock(null).append("fetchPathBuilder -> new FetchPathImpl(fetchPathBuilder.end());").appendEndBlock(false, null);
        builder.appendLine().append("private static final ").append(biFunctionName).append("<").append(simpleOrderPathName).append(".Builder, Boolean, SimpleOrderPathImpl> SIMPLE_ORDER_PATH_CREATOR =").appendBeginBlock(null).append("(simpleOrderPathBuilder, desc) ->");
        try (BlockScope methodScope = new BlockScope(builder);){
            builder.append("if (desc)");
            throwable = null;
            try (BlockScope ifScope = new BlockScope(builder);){
                builder.appendLine("return new SimpleOrderPathImpl(simpleOrderPathBuilder.desc());");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            builder.appendLine("return new SimpleOrderPathImpl(simpleOrderPathBuilder.asc());");
        }
        builder.append(";").appendEndBlock(false, null);
        builder.appendLine().appendLine("@Override").append("public Class<").append(entityName).append("> getRootType()");
        methodScope = new BlockScope(builder);
        var9_9 = null;
        try {
            builder.append("return ").append(entityName).appendLine(".class;");
        }
        catch (Throwable ifScope) {
            var9_9 = ifScope;
            throw ifScope;
        }
        finally {
            if (methodScope != null) {
                if (var9_9 != null) {
                    try {
                        methodScope.close();
                    }
                    catch (Throwable ifScope) {
                        var9_9.addSuppressed(ifScope);
                    }
                } else {
                    methodScope.close();
                }
            }
        }
        builder.appendLine().append("public static FetchPathBuilder<").append(entityName).append(", FetchPathImpl> begin()");
        methodScope = new BlockScope(builder);
        var9_9 = null;
        try {
            builder.append("return new FetchPathBuilder<").append(entityName).append(", ").append("FetchPathImpl>");
            parameterBlock2 = new BlockScope(builder, "(", ");");
            throwable = null;
            try {
                builder.append(queryPathsName).appendLine(".begin(), FETCH_PATH_CREATOR");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (parameterBlock2 != null) {
                    if (throwable != null) {
                        try {
                            parameterBlock2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        parameterBlock2.close();
                    }
                }
            }
        }
        catch (Throwable parameterBlock2) {
            var9_9 = parameterBlock2;
            throw parameterBlock2;
        }
        finally {
            if (methodScope != null) {
                if (var9_9 != null) {
                    try {
                        methodScope.close();
                    }
                    catch (Throwable parameterBlock2) {
                        var9_9.addSuppressed(parameterBlock2);
                    }
                } else {
                    methodScope.close();
                }
            }
        }
        builder.appendLine().append("public static SimpleOrderPathBuilder<").append(entityName).append(", SimpleOrderPathImpl> preOrderBy()");
        methodScope = new BlockScope(builder);
        var9_9 = null;
        try {
            builder.append("return new SimpleOrderPathBuilder<").append(entityName).append(", ").append("SimpleOrderPathImpl>");
            parameterBlock2 = new BlockScope(builder, "(", ");");
            throwable = null;
            try {
                builder.appendLine("QueryPaths.preOrderBy(), SIMPLE_ORDER_PATH_CREATOR");
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (parameterBlock2 != null) {
                    if (throwable != null) {
                        try {
                            parameterBlock2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        parameterBlock2.close();
                    }
                }
            }
        }
        catch (Throwable parameterBlock3) {
            var9_9 = parameterBlock3;
            throw parameterBlock3;
        }
        finally {
            if (methodScope != null) {
                if (var9_9 != null) {
                    try {
                        methodScope.close();
                    }
                    catch (Throwable parameterBlock3) {
                        var9_9.addSuppressed(parameterBlock3);
                    }
                } else {
                    methodScope.close();
                }
            }
        }
        builder.appendLine().append("public static SimpleOrderPathBuilder<").append(entityName).append(", SimpleOrderPathImpl> postOrderBy()");
        methodScope = new BlockScope(builder);
        var9_9 = null;
        try {
            builder.append("return new SimpleOrderPathBuilder<").append(entityName).append(", ").append("SimpleOrderPathImpl>");
            parameterBlock2 = new BlockScope(builder, "(", ");");
            throwable = null;
            try {
                builder.appendLine("QueryPaths.postOrderBy(), SIMPLE_ORDER_PATH_CREATOR");
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (parameterBlock2 != null) {
                    if (throwable != null) {
                        try {
                            parameterBlock2.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        parameterBlock2.close();
                    }
                }
            }
        }
        catch (Throwable parameterBlock4) {
            var9_9 = parameterBlock4;
            throw parameterBlock4;
        }
        finally {
            if (methodScope != null) {
                if (var9_9 != null) {
                    try {
                        methodScope.close();
                    }
                    catch (Throwable parameterBlock4) {
                        var9_9.addSuppressed(parameterBlock4);
                    }
                } else {
                    methodScope.close();
                }
            }
        }
        builder.appendLine().append("public static ").append(this.metadataClass.getSimpleName()).append(NAME_POSTFIX).append("[] compile(String queryPath)");
        methodScope = new BlockScope(builder);
        var9_9 = null;
        try {
            builder.appendLine("return compile(new String[]{ queryPath });");
        }
        catch (Throwable parameterBlock4) {
            var9_9 = parameterBlock4;
            throw parameterBlock4;
        }
        finally {
            if (methodScope != null) {
                if (var9_9 != null) {
                    try {
                        methodScope.close();
                    }
                    catch (Throwable parameterBlock4) {
                        var9_9.addSuppressed(parameterBlock4);
                    }
                } else {
                    methodScope.close();
                }
            }
        }
        builder.appendLine().append("public static ").append(this.metadataClass.getSimpleName()).append(NAME_POSTFIX).append("[] compile(String[] queryPaths)");
        methodScope = new BlockScope(builder);
        var9_9 = null;
        try {
            builder.append(this.getRenderName(QueryPath.class)).append("[] arr = ").append(queryPathsName).append(".compile(queryPaths);").appendLine().append(this.metadataClass.getSimpleName()).append(NAME_POSTFIX).append("[] typedQueryPaths = new ").append(this.metadataClass.getSimpleName()).append(NAME_POSTFIX).appendLine("[arr.length];").append("for (int i = arr.length - 1; i >= 0; i--)");
            throwable = null;
            try (BlockScope forScope = new BlockScope(builder);){
                builder.append("if (arr[i] instanceof ").append(fetchPathName).append(")");
                try (BlockScope ifScope = new BlockScope(builder, false);){
                    builder.appendLine("typedQueryPaths[i] = new FetchPathImpl((").append(fetchPathName).appendLine(")arr[i]);");
                }
                builder.append(" else");
                var13_38 = null;
                try (BlockScope elseScope = new BlockScope(builder);){
                    builder.appendLine("typedQueryPaths[i] = new SimpleOrderPathImpl((").append(simpleOrderPathName).appendLine(")arr[i]);");
                }
                catch (Throwable throwable9) {
                    var13_38 = throwable9;
                    throw throwable9;
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            builder.appendLine("return typedQueryPaths;");
        }
        catch (Throwable throwable11) {
            var9_9 = throwable11;
            throw throwable11;
        }
        finally {
            if (methodScope != null) {
                if (var9_9 != null) {
                    try {
                        methodScope.close();
                    }
                    catch (Throwable throwable12) {
                        var9_9.addSuppressed(throwable12);
                    }
                } else {
                    methodScope.close();
                }
            }
        }
    }

    private void generateFetchPathImpl(CodeBuilder builder) throws IOException {
        String entityName = this.metadataClass.getSimpleName();
        String typedFetchPathName = this.getRenderName(TypedFetchPath.class);
        String fetchPathWrapperName = this.getRenderName(FetchPathWrapper.class);
        String fetchPathName = this.getRenderName(FetchPath.class);
        builder.appendLine().append("public static class FetchPathImpl extends ").append(entityName).append(NAME_POSTFIX).append(" implements ").append(typedFetchPathName).append("<").append(entityName).append(">, ").append(fetchPathWrapperName);
        try (BlockScope classScope = new BlockScope(builder);){
            builder.appendLine().append("private static final long serialVersionUID = ").append(Long.toString(this.getSerialVersionUID("FetchPathImpl"))).appendLine("L;").appendLine().append("private ").append(fetchPathName).appendLine(" fetchPath;").appendLine().append("FetchPathImpl(").append(fetchPathName).append(" fetchPath)");
            try (BlockScope methodScope = new BlockScope(builder);){
                builder.appendLine("this.fetchPath = fetchPath;");
            }
            builder.appendLine().appendLine("@Override").append("public Node getFirstNode()");
            methodScope = new BlockScope(builder);
            var9_11 = null;
            try {
                builder.appendLine("return this.fetchPath.getFirstNode();");
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (methodScope != null) {
                    if (var9_11 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        methodScope.close();
                    }
                }
            }
            builder.appendLine().appendLine("@Override").append("public ").append(fetchPathName).append(" unwrap()");
            methodScope = new BlockScope(builder);
            var9_11 = null;
            try {
                builder.appendLine("return this.fetchPath;");
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (methodScope != null) {
                    if (var9_11 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        methodScope.close();
                    }
                }
            }
        }
    }

    private void generateFetchPathBuilderImpl(CodeBuilder builder) throws IOException {
        String fetchPathName = this.getRenderName(FetchPath.class);
        String functionName = this.getRenderName(Function.class);
        String typedFetchPathName = this.getRenderName(TypedFetchPath.class);
        builder.appendLine().append("public static class FetchPathBuilder<R, P extends ").append(typedFetchPathName).append("<R>> extends ");
        if (this.metadataClass.getSuperMetadataClass() != null && this.metadataClass.getSuperMetadataClass().isEntity()) {
            builder.append(this.getTypedQueryPathRenderName(this.metadataClass.getSuperMetadataClass())).append(".FetchPathBuilder<R, P> ");
        } else {
            builder.append("").append(typedFetchPathName).append(".TypedBuilder<R, P>");
        }
        try (BlockScope classScope = new BlockScope(builder);){
            builder.appendLine().append("public FetchPathBuilder").append("(").append(fetchPathName).append(".Builder builder, ").append(functionName).append("<").append(fetchPathName).append(".Builder, P> pathCreator)");
            try (BlockScope methodScope = new BlockScope(builder);){
                builder.appendLine("super(builder, pathCreator);");
            }
            String getterTypeName = this.getRenderName(GetterType.class);
            String collectionFetchTypeName = this.getRenderName(CollectionFetchType.class);
            for (MetadataAssociation association : this.metadataClass.getAssociations().values()) {
                String targetEntityTypedQueryPathName = this.getTypedQueryPathRenderName(association.getRelatedMetadataClass());
                builder.appendLine().append("public ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P> ").append(association.getName()).append("()");
                try (BlockScope methodScope = new BlockScope(builder);){
                    builder.append("return new ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P>(this.builder.get(\"").append(association.getName()).appendLine("\"), this.pathCreator);");
                }
                builder.appendLine().append("public ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P> ").append(association.getName()).append("(").append(getterTypeName).append(" getterType)");
                methodScope = new BlockScope(builder);
                var13_19 = null;
                try {
                    builder.append("return new ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P>(this.builder.get(\"").append(association.getName()).appendLine("\", getterType), this.pathCreator);");
                }
                catch (Throwable throwable) {
                    var13_19 = throwable;
                    throw throwable;
                }
                finally {
                    if (methodScope != null) {
                        if (var13_19 != null) {
                            try {
                                methodScope.close();
                            }
                            catch (Throwable throwable) {
                                var13_19.addSuppressed(throwable);
                            }
                        } else {
                            methodScope.close();
                        }
                    }
                }
                if (!association.isCollection()) continue;
                builder.appendLine().append("public ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P> ").append(association.getName()).append("(").append(collectionFetchTypeName).append(" collectionFetchType)");
                methodScope = new BlockScope(builder);
                var13_19 = null;
                try {
                    builder.append("return new ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P>(this.builder.get(\"").append(association.getName()).appendLine("\", collectionFetchType), this.pathCreator);");
                }
                catch (Throwable throwable) {
                    var13_19 = throwable;
                    throw throwable;
                }
                finally {
                    if (methodScope != null) {
                        if (var13_19 != null) {
                            try {
                                methodScope.close();
                            }
                            catch (Throwable throwable) {
                                var13_19.addSuppressed(throwable);
                            }
                        } else {
                            methodScope.close();
                        }
                    }
                }
                builder.appendLine().append("public ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P> ").append(association.getName()).append("(").append(getterTypeName).append(" getterType, ").append(collectionFetchTypeName).append(" collectionFetchType)");
                methodScope = new BlockScope(builder);
                var13_19 = null;
                try {
                    builder.append("return new ").append(targetEntityTypedQueryPathName).append(".FetchPathBuilder<R, P>(this.builder.get(\"").append(association.getName()).appendLine("\", getterType, collectionFetchType), this.pathCreator);");
                }
                catch (Throwable throwable) {
                    var13_19 = throwable;
                    throw throwable;
                }
                finally {
                    if (methodScope == null) continue;
                    if (var13_19 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var13_19.addSuppressed(throwable);
                        }
                        continue;
                    }
                    methodScope.close();
                }
            }
            for (MetadataScalar scalar : this.metadataClass.getScalars().values()) {
                if (!scalar.isLazy()) continue;
                builder.appendLine().append("public ").append("").append(typedFetchPathName).append(".TypedBuilder<R, P> ").append(scalar.getName()).append("()");
                BlockScope methodScope = new BlockScope(builder);
                Throwable throwable = null;
                try {
                    builder.append("return new ").append(typedFetchPathName).append(".TypedBuilder<R, P>(this.builder.get(\"").append(scalar.getName()).appendLine("\"), this.pathCreator);");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (methodScope == null) continue;
                    if (throwable != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    methodScope.close();
                }
            }
        }
    }

    private void generateSimpleOrderPathImpl(CodeBuilder builder) throws IOException {
        String entityName = this.metadataClass.getSimpleName();
        String typedSimpleOrderPathName = this.getRenderName(TypedSimpleOrderPath.class);
        String simpleOrderPathWrapperName = this.getRenderName(SimpleOrderPathWrapper.class);
        String simpleOrderPathName = this.getRenderName(SimpleOrderPath.class);
        builder.appendLine().append("public static class SimpleOrderPathImpl extends ").append(entityName).append(NAME_POSTFIX).append(" implements ").append(typedSimpleOrderPathName).append("<").append(entityName).append(">, ").append(simpleOrderPathWrapperName);
        try (BlockScope classScope = new BlockScope(builder);){
            builder.appendLine().append("private static final long serialVersionUID = ").append(Long.toString(this.getSerialVersionUID("SimpleOrderPathImpl"))).appendLine("L;").appendLine().append("private ").append(simpleOrderPathName).appendLine(" simpleOrderPath;").appendLine().append("SimpleOrderPathImpl(").append(simpleOrderPathName).append(" simpleOrderPath)");
            try (BlockScope methodScope = new BlockScope(builder);){
                builder.append("this.simpleOrderPath = simpleOrderPath;");
            }
            builder.appendLine().appendLine("@Override").append("public boolean isPost()");
            methodScope = new BlockScope(builder);
            var9_11 = null;
            try {
                builder.appendLine("return this.simpleOrderPath.isPost();");
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (methodScope != null) {
                    if (var9_11 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        methodScope.close();
                    }
                }
            }
            builder.appendLine().appendLine("@Override").append("public boolean isDesc()");
            methodScope = new BlockScope(builder);
            var9_11 = null;
            try {
                builder.appendLine("return this.simpleOrderPath.isDesc();");
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (methodScope != null) {
                    if (var9_11 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        methodScope.close();
                    }
                }
            }
            builder.appendLine().appendLine("@Override").append("public Node getFirstNode()");
            methodScope = new BlockScope(builder);
            var9_11 = null;
            try {
                builder.appendLine("return this.simpleOrderPath.getFirstNode();");
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (methodScope != null) {
                    if (var9_11 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        methodScope.close();
                    }
                }
            }
            builder.appendLine().appendLine("@Override").append("public ").append(simpleOrderPathName).append(" unwrap()");
            methodScope = new BlockScope(builder);
            var9_11 = null;
            try {
                builder.appendLine("return this.simpleOrderPath;");
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (methodScope != null) {
                    if (var9_11 != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        methodScope.close();
                    }
                }
            }
        }
    }

    private void generateSimpleOrderPathBuilderImpl(CodeBuilder builder) throws IOException {
        String typedSimpleOrderPathName = this.getRenderName(TypedSimpleOrderPath.class);
        String simpleOrderPathName = this.getRenderName(SimpleOrderPath.class);
        String biFunctionName = this.getRenderName(BiFunction.class);
        builder.appendLine().append("public static class SimpleOrderPathBuilder<R, P extends ").append(typedSimpleOrderPathName).append("<R>> extends ");
        if (this.metadataClass.getSuperMetadataClass() != null) {
            builder.append(this.getTypedQueryPathRenderName(this.metadataClass.getSuperMetadataClass())).append(".SimpleOrderPathBuilder<R, P> ");
        } else {
            builder.append("").append(typedSimpleOrderPathName).append(".TypedBuilder<R, P>");
        }
        try (BlockScope classScope = new BlockScope(builder);){
            Throwable throwable;
            BlockScope methodScope;
            builder.appendLine().append("public SimpleOrderPathBuilder").append("(").append(simpleOrderPathName).append(".Builder builder, ").append(biFunctionName).append("<").append(simpleOrderPathName).append(".Builder, Boolean, P> pathCreator)");
            BlockScope methodScope2 = new BlockScope(builder);
            Iterator<MetadataScalar> iterator = null;
            try {
                builder.appendLine("super(builder, pathCreator);");
            }
            catch (Throwable throwable2) {
                iterator = throwable2;
                throw throwable2;
            }
            finally {
                if (methodScope2 != null) {
                    if (iterator != null) {
                        try {
                            methodScope2.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable3);
                        }
                    } else {
                        methodScope2.close();
                    }
                }
            }
            String getterTypeName = this.getRenderName(GetterType.class);
            for (MetadataAssociation association : this.metadataClass.getAssociations().values()) {
                String targetEntityTypedQueryPathName = this.getTypedQueryPathRenderName(association.getRelatedMetadataClass());
                builder.appendLine().append("public ").append(targetEntityTypedQueryPathName).append(".SimpleOrderPathBuilder<R, P> ").append(association.getName()).append("()");
                methodScope = new BlockScope(builder);
                throwable = null;
                try {
                    builder.append("return new ").append(targetEntityTypedQueryPathName).append(".SimpleOrderPathBuilder<R, P>(this.builder.get(\"").append(association.getName()).appendLine("\"), this.pathCreator);");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (methodScope != null) {
                        if (throwable != null) {
                            try {
                                methodScope.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            methodScope.close();
                        }
                    }
                }
                builder.appendLine().append("public ").append(targetEntityTypedQueryPathName).append(".SimpleOrderPathBuilder<R, P> ").append(association.getName()).append("(").append(getterTypeName).append(" getterType)");
                methodScope = new BlockScope(builder);
                throwable = null;
                try {
                    builder.append("return new ").append(targetEntityTypedQueryPathName).append(".SimpleOrderPathBuilder<R, P>(this.builder.get(\"").append(association.getName()).appendLine("\", getterType), this.pathCreator);");
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (methodScope == null) continue;
                    if (throwable != null) {
                        try {
                            methodScope.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    methodScope.close();
                }
            }
            for (MetadataScalar scalar : this.metadataClass.getScalars().values()) {
                if (scalar.isEmbedded()) {
                    String embeddableTypedQueryPathName = this.getTypedQueryPathRenderName(scalar.getRelatedMetadataClass());
                    builder.appendLine().append("public ").append(embeddableTypedQueryPathName).append(".SimpleOrderPathBuilder<R, P> ").append(scalar.getName()).append("()");
                    methodScope = new BlockScope(builder);
                    throwable = null;
                    try {
                        builder.append("return new ").append(embeddableTypedQueryPathName).append(".SimpleOrderPathBuilder<R, P>(this.builder.get(\"").append(scalar.getName()).appendLine("\"), this.pathCreator);");
                        continue;
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (methodScope == null) continue;
                        if (throwable != null) {
                            try {
                                methodScope.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        methodScope.close();
                        continue;
                    }
                }
                builder.appendLine().append("public ").append(typedSimpleOrderPathName).append(".TypedBuilder<R, P> ").append(scalar.getName()).append("()");
                BlockScope methodScope3 = new BlockScope(builder);
                Throwable throwable10 = null;
                try {
                    builder.append("return new ").append(typedSimpleOrderPathName).append(".TypedBuilder<R, P>(this.builder.get(\"").append(scalar.getName()).appendLine("\"), this.pathCreator);");
                }
                catch (Throwable throwable11) {
                    throwable10 = throwable11;
                    throw throwable11;
                }
                finally {
                    if (methodScope3 == null) continue;
                    if (throwable10 != null) {
                        try {
                            methodScope3.close();
                        }
                        catch (Throwable throwable12) {
                            throwable10.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    methodScope3.close();
                }
            }
        }
    }

    private void importClasses() {
        this.importClass(Generated.class);
        this.importClass(BiFunction.class);
        this.importClass(TypedSimpleOrderPath.class);
        this.importClass(SimpleOrderPath.class);
        for (MetadataScalar scalar : this.metadataClass.getScalars().values()) {
            if (scalar.getRelatedMetadataClass() == null) continue;
            this.importTypedQueryPathClass(scalar.getRelatedMetadataClass());
        }
        if (this.metadataClass.isEntity()) {
            for (MetadataAssociation association : this.metadataClass.getAssociations().values()) {
                if (!association.isCollection()) continue;
                this.importClass(CollectionFetchType.class);
                break;
            }
            if (!this.metadataClass.getAssociations().isEmpty()) {
                this.importClass(GetterType.class);
            }
            this.importClass(Function.class);
            this.importClass(FetchPath.class);
            this.importClass(FetchPathWrapper.class);
            this.importClass(QueryPath.class);
            this.importClass(QueryPaths.class);
            this.importClass(SimpleOrderPathWrapper.class);
            this.importClass(TypedQueryPath.class);
            this.importClass(TypedFetchPath.class);
        }
        for (MetadataAssociation association : this.metadataClass.getAssociations().values()) {
            MetadataClass otherClass = association.getRelatedMetadataClass();
            this.importTypedQueryPathClass(otherClass);
        }
    }

    private void importClass(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            return;
        }
        while (clazz.getDeclaringClass() != null) {
            clazz = clazz.getDeclaringClass();
        }
        this.importClass(clazz.getPackage().getName(), clazz.getSimpleName());
    }

    private void importTypedQueryPathClass(MetadataClass metadataClass) {
        this.importClass(metadataClass.getPackageName(), metadataClass.getSimpleName() + NAME_POSTFIX);
    }

    private void importClass(String packageName, String simpleName) {
        if (Nulls.isNullOrEmpty((String)packageName) || Nulls.equals((Object)this.metadataClass.getPackageName(), (Object)packageName)) {
            return;
        }
        if (this.samePackageMetadataClassMap.containsKey(simpleName)) {
            return;
        }
        this.importMap.put(simpleName, packageName + '.' + simpleName);
    }

    private String getTypedQueryPathRenderName(MetadataClass clazz) {
        return this.getRenderName(clazz.getPackageName(), clazz.getSimpleName() + NAME_POSTFIX);
    }

    private String getRenderName(Class<?> clazz) {
        return this.getRenderName(clazz.getPackage() != null ? clazz.getPackage().getName() : null, clazz.getSimpleName());
    }

    private String getRenderName(String packageName, String simpleName) {
        if (Nulls.isNullOrEmpty((String)packageName) || Nulls.equals((Object)this.metadataClass.getPackageName(), (Object)packageName)) {
            return simpleName;
        }
        String className = this.importMap.get(simpleName);
        if (className != null && className.length() == packageName.length() + 1 + simpleName.length() && className.charAt(packageName.length()) == '.' && className.substring(0, packageName.length()).equals(packageName)) {
            return simpleName;
        }
        return packageName + '.' + simpleName;
    }
}

