/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source;

import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.JavaFileObject;
import org.babyfish.collection.HashMap;
import org.babyfish.lang.IllegalProgramException;
import org.babyfish.lang.UncheckedException;
import org.babyfish.model.jpa.source.ElementHelper;
import org.babyfish.model.jpa.source.SourceGenerator;
import org.babyfish.model.jpa.source.metadata.MetadataClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedAnnotationTypes(value={"javax.persistence.Entity", "javax.persistence.MappedSuperclass", "javax.persistence.Embeddable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TypedQueryPathProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypedQueryPathProcessor.class);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processImpl(annotations, roundEnv);
            return true;
        }
        catch (Error | RuntimeException ex) {
            LOGGER.error("Failed to process because an exception raised", ex);
            throw ex;
        }
    }

    private void processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            LOGGER.info("Skip the process because the processing is over");
            return;
        }
        if (annotations.isEmpty()) {
            LOGGER.info("Skip the process because there is no annotations");
            return;
        }
        HashMap metadataClasses = new HashMap();
        for (Element element : roundEnv.getRootElements()) {
            if (!ElementHelper.containsAnyAnnotation(element, Entity.class, Embeddable.class, MappedSuperclass.class)) continue;
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                throw new IllegalProgramException("Entity, Embeddable, MappedSuperClass can not be nested class.");
            }
            MetadataClass entity = new MetadataClass(typeElement);
            metadataClasses.put(entity.getName(), entity);
        }
        if (metadataClasses.isEmpty()) {
            LOGGER.info("Skip the process because there is no class that is marked by \"@" + Entity.class.getName() + ", " + Embeddable.class.getName() + "\" and \"@" + MappedSuperclass.class.getName() + "\"");
            return;
        }
        for (MetadataClass metadataClass : metadataClasses.values()) {
            metadataClass.secondaryPass((Map<String, MetadataClass>)metadataClasses);
        }
        this.generate(metadataClasses.values());
    }

    private void generate(Collection<MetadataClass> metadataClasses) {
        for (MetadataClass metadataClass : metadataClasses) {
            try {
                JavaFileObject fo = this.processingEnv.getFiler().createSourceFile(metadataClass.getName() + "__", new Element[0]);
                Writer writer = fo.openWriter();
                Throwable throwable = null;
                try {
                    new SourceGenerator(metadataClass, metadataClasses).generate(writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (Throwable ex) {
                UncheckedException.rethrow((Throwable)ex);
            }
        }
    }
}

